/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.transformation;

import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.RealRandomAccess;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.type.Type;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class ImageTransform<T extends Type<T>>
implements OutputAlgorithm<RandomAccessibleInterval<T>> {
    final InvertibleBoundable transform;
    final RandomAccessibleInterval<T> image;
    final int numDimensions;
    final InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory;
    ImgFactory<T> outputImageFactory;
    final long[] newDim;
    final double[] offset;
    Img<T> transformed;
    String errorMessage = "";

    @Deprecated
    public ImageTransform(ExtendedRandomAccessibleInterval<T, Img<T>> container, InvertibleBoundable transform, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory) {
        this(container, container.getSource(), transform, interpolatorFactory, container.getSource().factory());
    }

    public ImageTransform(RandomAccessible<T> input, Interval interval, InvertibleBoundable transform, InterpolatorFactory<T, RandomAccessible<T>> interpolatorFactory, ImgFactory<T> outImgFactory) {
        this.image = Views.interval(input, interval);
        this.interpolatorFactory = interpolatorFactory;
        this.numDimensions = input.numDimensions();
        this.transform = transform;
        double[] min = new double[this.numDimensions];
        double[] max = new double[this.numDimensions];
        this.image.realMin(min);
        this.image.realMax(max);
        transform.estimateBounds(min, max);
        this.outputImageFactory = outImgFactory;
        this.offset = new double[this.numDimensions];
        this.newDim = new long[this.numDimensions];
        for (int d = 0; d < this.numDimensions; ++d) {
            this.newDim[d] = Math.round(max[d]) - Math.round(min[d]);
            this.offset[d] = min[d];
        }
    }

    @Deprecated
    public void setOutputContainerFactory(ImgFactory<T> outputContainerFactory) {
        this.outputImageFactory = outputContainerFactory;
    }

    @Deprecated
    public ImgFactory<T> getOutputContainerFactory() {
        return this.outputImageFactory;
    }

    public void setOutputImgFactory(ImgFactory<T> outputImgFactory) {
        this.outputImageFactory = outputImgFactory;
    }

    public ImgFactory<T> getOutputImgFactory() {
        return this.outputImageFactory;
    }

    public double[] getOffset() {
        return this.offset;
    }

    public void setOffset(double[] offset) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.offset[d] = offset[d];
        }
    }

    public long[] getNewImageSize() {
        return this.newDim;
    }

    public void setNewImageSize(long[] newDim) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.newDim[d] = newDim[d];
        }
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "AffineTransform: [Container<T> container] is null.";
            return false;
        }
        if (this.interpolatorFactory == null) {
            this.errorMessage = "AffineTransform: [InterpolatorFactory<T> interpolatorFactory] is null.";
            return false;
        }
        if (this.transform == null) {
            this.errorMessage = "AffineTransform: [Transform3D transform] or [float[] transform] is null.";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Img<T> getResult() {
        return this.transformed;
    }

    @Override
    public boolean process() {
        if (!this.checkInput()) {
            return false;
        }
        this.transformed = this.outputImageFactory.create(this.newDim);
        RealCursor transformedIterator = this.transformed.localizingCursor();
        RealRandomAccess<T> interpolator = this.interpolatorFactory.create(this.image);
        try {
            double[] tmp = new double[this.numDimensions];
            while (transformedIterator.hasNext()) {
                transformedIterator.fwd();
                for (int d = 0; d < this.numDimensions; ++d) {
                    tmp[d] = (double)transformedIterator.getIntPosition(d) + this.offset[d];
                }
                this.transform.applyInverseInPlace(tmp);
                interpolator.setPosition(tmp);
                ((Type)transformedIterator.get()).set((Type)interpolator.get());
            }
        }
        catch (NoninvertibleModelException e) {
            this.errorMessage = "ImageTransform.process(): " + e.getMessage();
            return false;
        }
        return true;
    }
}

