/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;

public class ExplicitInvertibleRealTransform
implements InvertibleRealTransform {
    private final RealTransform forwardTransform;
    private final RealTransform inverseTransform;
    private final ExplicitInvertibleRealTransform inverse;

    public ExplicitInvertibleRealTransform(RealTransform forwardTransform, RealTransform inverseTransform) {
        assert (forwardTransform.numTargetDimensions() == inverseTransform.numSourceDimensions() && forwardTransform.numSourceDimensions() == inverseTransform.numTargetDimensions()) : "number of target and source dimensions not compatible";
        this.forwardTransform = forwardTransform;
        this.inverseTransform = inverseTransform;
        this.inverse = new ExplicitInvertibleRealTransform(this);
    }

    private ExplicitInvertibleRealTransform(ExplicitInvertibleRealTransform inverse) {
        this.forwardTransform = inverse.inverseTransform;
        this.inverseTransform = inverse.forwardTransform;
        this.inverse = inverse;
    }

    @Override
    public int numSourceDimensions() {
        return this.forwardTransform.numSourceDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.forwardTransform.numTargetDimensions();
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.forwardTransform.apply(source, target);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        this.forwardTransform.apply(source, target);
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        this.inverseTransform.apply(target, source);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        this.inverseTransform.apply(target, source);
    }

    @Override
    public ExplicitInvertibleRealTransform inverse() {
        return this.inverse;
    }

    @Override
    public InvertibleRealTransform copy() {
        return new ExplicitInvertibleRealTransform(this.forwardTransform.copy(), this.inverseTransform.copy());
    }
}

