/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util;

import net.imglib2.AbstractWrappedPositionableLocalizable;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.PositionableIterableInterval;
import net.imglib2.roi.PositionableIterableRegion;
import net.imglib2.roi.util.OffsetLocalizable;
import net.imglib2.roi.util.OffsetPositionableLocalizable;
import net.imglib2.roi.util.PositionableInterval;
import net.imglib2.roi.util.PositionableLocalizable;
import net.imglib2.type.BooleanType;
import net.imglib2.util.Intervals;

public class PositionableWrappedIterableRegion<T extends BooleanType<T>>
extends PositionableInterval
implements PositionableIterableRegion<T> {
    private final IterableRegion<T> source;
    private final InsideIterable inside;

    public PositionableWrappedIterableRegion(IterableRegion<T> source) {
        super(source);
        this.source = source;
        this.inside = new InsideIterable();
    }

    private PositionableWrappedIterableRegion(PositionableWrappedIterableRegion<T> other) {
        super(other.source);
        this.source = other.source;
        this.inside = new InsideIterable();
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return new RA(this.source.randomAccess(), this.currentOffset);
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return new RA(this.source.randomAccess(Intervals.translate(interval, this.currentOffset)), this.currentOffset);
    }

    @Override
    public Cursor<T> cursor() {
        return new C(this.source.cursor(), this.currentOffset);
    }

    @Override
    public Cursor<T> localizingCursor() {
        return new C(this.source.localizingCursor(), this.currentOffset);
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public long size() {
        return this.source.size();
    }

    @Override
    public T getType() {
        return (T)((BooleanType)this.source.getType());
    }

    @Override
    public PositionableWrappedIterableRegion<T> copy() {
        return new PositionableWrappedIterableRegion<T>(this);
    }

    @Override
    public PositionableIterableInterval<Void> inside() {
        return this.inside;
    }

    private final class PositionableInsideCursor
    extends OffsetLocalizable<Cursor<Void>>
    implements Cursor<Void> {
        public PositionableInsideCursor(Cursor<Void> cursor) {
            super(cursor, PositionableWrappedIterableRegion.this.currentOffset);
        }

        @Override
        public Void get() {
            return null;
        }

        @Override
        public void jumpFwd(long steps) {
            ((Cursor)this.source).jumpFwd(steps);
        }

        @Override
        public void fwd() {
            ((Cursor)this.source).fwd();
        }

        @Override
        public void reset() {
            ((Cursor)this.source).reset();
        }

        @Override
        public boolean hasNext() {
            return ((Cursor)this.source).hasNext();
        }

        @Override
        public Void next() {
            return (Void)((Cursor)this.source).next();
        }

        @Override
        public PositionableInsideCursor copy() {
            return new PositionableInsideCursor((Cursor<Void>)((Cursor)this.source).copy());
        }
    }

    private final class InsideIterable
    extends AbstractWrappedPositionableLocalizable<PositionableWrappedIterableRegion<T>>
    implements PositionableIterableInterval<Void> {
        InsideIterable() {
            super(PositionableWrappedIterableRegion.this);
        }

        @Override
        public PositionableLocalizable origin() {
            return PositionableWrappedIterableRegion.this.origin();
        }

        @Override
        public PositionableIterableInterval<Void> copy() {
            return ((PositionableWrappedIterableRegion)PositionableWrappedIterableRegion.this.copy()).inside();
        }

        @Override
        public Cursor<Void> cursor() {
            return new PositionableInsideCursor((Cursor<Void>)PositionableWrappedIterableRegion.this.inside().cursor());
        }

        @Override
        public Cursor<Void> localizingCursor() {
            return new PositionableInsideCursor((Cursor<Void>)PositionableWrappedIterableRegion.this.inside().localizingCursor());
        }

        @Override
        public long size() {
            return PositionableWrappedIterableRegion.this.inside().size();
        }

        @Override
        public Object iterationOrder() {
            return this;
        }

        @Override
        public long min(int d) {
            return PositionableWrappedIterableRegion.this.min(d);
        }

        @Override
        public long max(int d) {
            return PositionableWrappedIterableRegion.this.max(d);
        }

        @Override
        public Void getType() {
            return null;
        }
    }

    private final class C
    extends OffsetLocalizable<Cursor<T>>
    implements Cursor<T> {
        public C(Cursor<T> cursor, long[] offset) {
            super(cursor, offset);
        }

        @Override
        public T get() {
            return (BooleanType)((Cursor)this.source).get();
        }

        @Override
        public void jumpFwd(long steps) {
            ((Cursor)this.source).jumpFwd(steps);
        }

        @Override
        public void fwd() {
            ((Cursor)this.source).fwd();
        }

        @Override
        public void reset() {
            ((Cursor)this.source).reset();
        }

        @Override
        public boolean hasNext() {
            return ((Cursor)this.source).hasNext();
        }

        @Override
        public T next() {
            return (BooleanType)((Cursor)this.source).next();
        }

        @Override
        public C copy() {
            return new C(((Cursor)this.source).copy(), this.offset);
        }
    }

    private final class RA
    extends OffsetPositionableLocalizable<RandomAccess<T>>
    implements RandomAccess<T> {
        public RA(RandomAccess<T> source, long[] offset) {
            super(source, offset);
        }

        @Override
        public T get() {
            return (BooleanType)((RandomAccess)this.source).get();
        }

        @Override
        public T getType() {
            return (BooleanType)((RandomAccess)this.source).getType();
        }

        @Override
        public RA copy() {
            return new RA(((RandomAccess)this.source).copy(), this.offset);
        }
    }
}

