/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util;

import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;

@Deprecated
public class RandomAccessibleRegionCursor<T extends BooleanType<T>>
extends AbstractWrappedInterval<RandomAccessibleInterval<T>>
implements Cursor<Void> {
    private final RandomAccess<T> randomAccess;
    private final int n;
    private long index;
    private final long maxIndex;
    private long lineIndex;
    private final long maxLineIndex;
    private final boolean empty;

    public RandomAccessibleRegionCursor(RandomAccessibleInterval<T> interval, long size) {
        super(interval);
        this.randomAccess = interval.randomAccess();
        this.n = this.numDimensions();
        this.maxLineIndex = this.dimension(0) - 1L;
        this.maxIndex = size;
        this.empty = size == 0L;
        this.reset();
    }

    protected RandomAccessibleRegionCursor(RandomAccessibleRegionCursor<T> cursor) {
        super((Interval)cursor.sourceInterval);
        this.randomAccess = cursor.randomAccess.copyRandomAccess();
        this.n = cursor.n;
        this.lineIndex = cursor.lineIndex;
        this.maxIndex = cursor.maxIndex;
        this.maxLineIndex = cursor.maxLineIndex;
        this.empty = cursor.empty;
    }

    @Override
    public Void get() {
        return null;
    }

    @Override
    public void jumpFwd(long steps) {
        for (long i = 0L; i < steps; ++i) {
            this.fwd();
        }
    }

    @Override
    public void fwd() {
        if (this.empty) {
            return;
        }
        do {
            this.randomAccess.fwd(0);
            if (++this.lineIndex <= this.maxLineIndex) continue;
            this.nextLine();
        } while (!((BooleanType)this.randomAccess.get()).get());
        ++this.index;
    }

    private void nextLine() {
        this.lineIndex = 0L;
        this.randomAccess.setPosition(this.min(0), 0);
        for (int d = 1; d < this.n; ++d) {
            this.randomAccess.fwd(d);
            if (this.randomAccess.getLongPosition(d) <= this.max(d)) break;
            this.randomAccess.setPosition(this.min(d), d);
        }
    }

    @Override
    public void reset() {
        this.index = 0L;
        this.lineIndex = -1L;
        this.min(this.randomAccess);
        this.randomAccess.bck(0);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    @Override
    public Void next() {
        this.fwd();
        return this.get();
    }

    @Override
    public void remove() {
    }

    @Override
    public RandomAccessibleRegionCursor<T> copy() {
        return new RandomAccessibleRegionCursor<T>(this);
    }

    @Override
    public RandomAccessibleRegionCursor<T> copyCursor() {
        return this.copy();
    }

    @Override
    public void localize(float[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.randomAccess.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.randomAccess.getDoublePosition(d);
    }

    @Override
    public void localize(int[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public void localize(long[] position) {
        this.randomAccess.localize(position);
    }

    @Override
    public int getIntPosition(int d) {
        return this.randomAccess.getIntPosition(d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.randomAccess.getLongPosition(d);
    }
}

