/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui;

import java.awt.image.BufferedImage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.imglib2.EuclideanSpace;
import net.imglib2.display.screenimage.awt.ARGBScreenImage;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineSet;
import net.imglib2.ui.AbstractRenderer;
import net.imglib2.ui.AffineTransformType;
import net.imglib2.ui.InterruptibleProjector;
import net.imglib2.ui.PainterThread;
import net.imglib2.ui.RenderTarget;
import net.imglib2.ui.util.GuiUtil;

public abstract class AbstractMultiResolutionRenderer<A extends AffineSet & AffineGet>
extends AbstractRenderer<A> {
    protected InterruptibleProjector projector;
    protected final boolean doubleBuffered;
    protected final ArrayDeque<Integer> renderIdQueue;
    protected final HashMap<BufferedImage, Integer> bufferedImageToRenderId;
    protected ARGBScreenImage[][] screenImages;
    protected BufferedImage[][] bufferedImages;
    protected final double[] screenScales;
    protected final ArrayList<A> screenScaleTransforms;
    protected final long targetRenderNanos;
    protected int maxScreenScaleIndex;
    protected int requestedScreenScaleIndex;
    protected volatile boolean renderingMayBeCancelled;
    protected final int numRenderingThreads;

    public AbstractMultiResolutionRenderer(AffineTransformType<A> transformType, RenderTarget display, PainterThread painterThread, double[] screenScales, long targetRenderNanos, boolean doubleBuffered, int numRenderingThreads) {
        super(transformType, display, painterThread);
        this.screenScales = (double[])screenScales.clone();
        this.doubleBuffered = doubleBuffered;
        this.numRenderingThreads = numRenderingThreads;
        this.renderIdQueue = new ArrayDeque();
        this.bufferedImageToRenderId = new HashMap();
        this.screenImages = new ARGBScreenImage[screenScales.length][3];
        this.bufferedImages = new BufferedImage[screenScales.length][3];
        this.screenScaleTransforms = new ArrayList();
        for (int i = 0; i < screenScales.length; ++i) {
            this.screenScaleTransforms.add(transformType.createTransform());
        }
        this.projector = null;
        this.targetRenderNanos = targetRenderNanos;
        this.requestedScreenScaleIndex = this.maxScreenScaleIndex = screenScales.length - 1;
        this.renderingMayBeCancelled = true;
    }

    @Override
    public synchronized void requestRepaint() {
        this.requestRepaint(this.maxScreenScaleIndex);
    }

    public synchronized void requestRepaint(int screenScaleIndex) {
        if (this.renderingMayBeCancelled && this.projector != null) {
            this.projector.cancel();
        }
        this.requestedScreenScaleIndex = screenScaleIndex;
        this.painterThread.requestRepaint();
    }

    protected synchronized boolean checkResize() {
        int componentW = this.display.getWidth();
        int componentH = this.display.getHeight();
        if (this.screenImages[0][0] == null || (double)this.screenImages[0][0].dimension(0) * this.screenScales[0] != (double)componentW || (double)this.screenImages[0][0].dimension(1) * this.screenScales[0] != (double)componentH) {
            this.renderIdQueue.clear();
            this.renderIdQueue.addAll(Arrays.asList(0, 1, 2));
            this.bufferedImageToRenderId.clear();
            for (int i = 0; i < this.screenScales.length; ++i) {
                double screenToViewerScale = this.screenScales[i];
                int w = (int)(screenToViewerScale * (double)componentW);
                int h = (int)(screenToViewerScale * (double)componentH);
                if (this.doubleBuffered) {
                    for (int b = 0; b < (this.doubleBuffered ? 3 : 1); ++b) {
                        BufferedImage bi;
                        this.screenImages[i][b] = i == 0 ? new ARGBScreenImage(w, h) : new ARGBScreenImage(w, h, this.screenImages[0][b].getData());
                        this.bufferedImages[i][b] = bi = GuiUtil.getBufferedImage(this.screenImages[i][b]);
                        this.bufferedImageToRenderId.put(bi, b);
                    }
                } else {
                    this.screenImages[i][0] = new ARGBScreenImage(w, h);
                    this.bufferedImages[i][0] = GuiUtil.getBufferedImage(this.screenImages[i][0]);
                }
                AffineSet scale = (AffineSet)this.screenScaleTransforms.get(i);
                double xScale = (double)w / (double)componentW;
                double yScale = (double)h / (double)componentH;
                scale.set(xScale, 0, 0);
                scale.set(yScale, 1, 1);
                scale.set(0.5 * xScale - 0.5, 0, ((EuclideanSpace)((Object)scale)).numDimensions());
                scale.set(0.5 * yScale - 0.5, 1, ((EuclideanSpace)((Object)scale)).numDimensions());
            }
            return true;
        }
        return false;
    }

    protected abstract InterruptibleProjector createProjector(A var1, A var2, ARGBScreenImage var3);

    protected boolean isComplete() {
        return this.requestedScreenScaleIndex == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean paint(A viewerTransform) {
        InterruptibleProjector p;
        BufferedImage bufferedImage;
        int currentScreenScaleIndex;
        if (this.display.getWidth() <= 0 || this.display.getHeight() <= 0) {
            return false;
        }
        this.checkResize();
        AbstractMultiResolutionRenderer abstractMultiResolutionRenderer = this;
        synchronized (abstractMultiResolutionRenderer) {
            this.renderingMayBeCancelled = this.requestedScreenScaleIndex < this.maxScreenScaleIndex;
            currentScreenScaleIndex = this.requestedScreenScaleIndex;
            AffineSet currentScreenScaleTransform = (AffineSet)this.screenScaleTransforms.get(currentScreenScaleIndex);
            int renderId = this.renderIdQueue.peek();
            bufferedImage = this.bufferedImages[currentScreenScaleIndex][renderId];
            ARGBScreenImage screenImage = this.screenImages[currentScreenScaleIndex][renderId];
            this.projector = p = this.createProjector(viewerTransform, currentScreenScaleTransform, screenImage);
        }
        boolean success = p.map();
        AbstractMultiResolutionRenderer abstractMultiResolutionRenderer2 = this;
        synchronized (abstractMultiResolutionRenderer2) {
            if (success) {
                BufferedImage bi = this.display.setBufferedImage(bufferedImage);
                if (this.doubleBuffered) {
                    this.renderIdQueue.pop();
                    Integer id = this.bufferedImageToRenderId.get(bi);
                    if (id != null) {
                        this.renderIdQueue.add(id);
                    }
                }
                long rendertime = p.getLastFrameRenderNanoTime();
                if (currentScreenScaleIndex == this.maxScreenScaleIndex) {
                    if (rendertime > this.targetRenderNanos && this.maxScreenScaleIndex < this.screenScales.length - 1) {
                        ++this.maxScreenScaleIndex;
                    }
                } else if (currentScreenScaleIndex == this.maxScreenScaleIndex - 1 && rendertime < this.targetRenderNanos && this.maxScreenScaleIndex > 0) {
                    --this.maxScreenScaleIndex;
                }
                if (!this.isComplete()) {
                    this.requestRepaint(currentScreenScaleIndex > 0 ? currentScreenScaleIndex - 1 : 0);
                }
            }
        }
        return success;
    }
}

