/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui.viewer;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.converter.Converter;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.ui.AffineTransformType3D;
import net.imglib2.ui.InteractiveDisplayCanvasComponent;
import net.imglib2.ui.TransformEventHandler3D;
import net.imglib2.ui.overlay.BoxOverlayRenderer;
import net.imglib2.ui.util.Defaults;
import net.imglib2.ui.util.InterpolatingSource;
import net.imglib2.ui.viewer.InteractiveRealViewer;

public class InteractiveViewer3D<T extends NumericType<T>>
extends InteractiveRealViewer<AffineTransform3D, InteractiveDisplayCanvasComponent<AffineTransform3D>> {
    public InteractiveViewer3D(int width, int height, RandomAccessible<T> source, Interval sourceInterval, AffineTransform3D sourceTransform, Converter<? super T, ARGBType> converter) {
        this(width, height, new InterpolatingSource<T, AffineTransform3D>(source, sourceTransform, converter), sourceInterval);
    }

    public InteractiveViewer3D(int width, int height, RandomAccessible<T> source, Interval sourceInterval, Converter<? super T, ARGBType> converter) {
        this(width, height, source, sourceInterval, new AffineTransform3D(), converter);
    }

    public InteractiveViewer3D(int width, int height, final InterpolatingSource<T, AffineTransform3D> interpolatingSource, Interval sourceInterval) {
        super(AffineTransformType3D.instance, new InteractiveDisplayCanvasComponent<AffineTransform3D>(width, height, TransformEventHandler3D.factory()), Defaults.rendererFactory(AffineTransformType3D.instance, interpolatingSource));
        BoxOverlayRenderer box = new BoxOverlayRenderer(width, height);
        box.setSource(sourceInterval, interpolatingSource.getSourceTransform());
        ((InteractiveDisplayCanvasComponent)this.display).addTransformListener(box);
        ((InteractiveDisplayCanvasComponent)this.display).addOverlayRenderer(box);
        ((InteractiveDisplayCanvasComponent)this.display).addHandler(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 73) {
                    interpolatingSource.switchInterpolation();
                    InteractiveViewer3D.this.requestRepaint();
                }
            }
        });
    }
}

