/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.imglib2icy;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import plugins.tinevez.imglib2icy.ImgLib2IcySequenceAdapter;
import plugins.tinevez.imglib2icy.VirtualSequence;

public class ImgLib2IcyFunctions {
    public static <T extends NumericType<T> & RealType<T>> Sequence wrap(RandomAccessibleInterval<T> rai) {
        VirtualSequence.DimensionArrangement arrangement = ImgLib2IcyFunctions.heuristics(rai);
        return ImgLib2IcyFunctions.wrap(rai, arrangement);
    }

    private static VirtualSequence.DimensionArrangement heuristics(Interval source) {
        int n = source.numDimensions();
        if (n <= 2) {
            return VirtualSequence.DimensionArrangement.XY;
        }
        if (n == 3) {
            long l = source.dimension(2);
            if (l <= 5L) {
                return VirtualSequence.DimensionArrangement.XYC;
            }
            if (l <= 41L) {
                return VirtualSequence.DimensionArrangement.XYZ;
            }
            return VirtualSequence.DimensionArrangement.XYT;
        }
        if (n == 4) {
            long l1 = source.dimension(2);
            if (l1 <= 5L) {
                long l2 = source.dimension(3);
                if (l2 <= 41L) {
                    return VirtualSequence.DimensionArrangement.XYCZ;
                }
                return VirtualSequence.DimensionArrangement.XYCT;
            }
            return VirtualSequence.DimensionArrangement.XYZT;
        }
        if (n == 5) {
            return VirtualSequence.DimensionArrangement.XYCZT;
        }
        throw new UnsupportedOperationException("Source Img with ndims > 5 are not supported.");
    }

    public static <T extends NumericType<T> & RealType<T>> Sequence wrap(RandomAccessibleInterval<T> rai, VirtualSequence.DimensionArrangement arrangement) {
        return new VirtualSequence(rai, arrangement);
    }

    public static <T extends NumericType<T> & RealType<T>> Img<T> wrap(Sequence sequence) {
        return ImgLib2IcySequenceAdapter.wrap(sequence);
    }

    public static <T extends NumericType<T> & RealType<T>> Img<T> wrap(IcyBufferedImage image) {
        return ImgLib2IcyFunctions.wrap(new Sequence(image));
    }

    public static Img<ByteType> wrapByte(Sequence sequence) {
        return ImgLib2IcySequenceAdapter.wrapByte(sequence);
    }

    public static Img<DoubleType> wrapDouble(Sequence sequence) {
        return ImgLib2IcySequenceAdapter.wrapDouble(sequence);
    }

    public static Img<FloatType> wrapFloat(Sequence sequence) {
        return ImgLib2IcySequenceAdapter.wrapFloat(sequence);
    }

    public static Img<IntType> wrapInt(Sequence sequence) {
        return ImgLib2IcySequenceAdapter.wrapInt(sequence);
    }

    public static Img<ShortType> wrapShort(Sequence sequence) {
        return ImgLib2IcySequenceAdapter.wrapShort(sequence);
    }

    public static Img<UnsignedByteType> wrapUnsignedByte(Sequence sequence) {
        return ImgLib2IcySequenceAdapter.wrapUnsignedByte(sequence);
    }

    public static Img<UnsignedIntType> wrapUnsignedInt(Sequence sequence) {
        return ImgLib2IcySequenceAdapter.wrapUnsignedInt(sequence);
    }

    public static Img<UnsignedShortType> wrapUnsignedShort(Sequence sequence) {
        return ImgLib2IcySequenceAdapter.wrapUnsignedShort(sequence);
    }

    public static VirtualSequence.DimensionArrangement getDimensionArrangement(Sequence sequence) {
        boolean hasT;
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        boolean hasC = sizeC > 1;
        boolean hasZ = sizeZ > 1;
        boolean bl = hasT = sizeT > 1;
        if (hasC) {
            if (hasZ) {
                if (hasT) {
                    return VirtualSequence.DimensionArrangement.XYCZT;
                }
                return VirtualSequence.DimensionArrangement.XYCZ;
            }
            if (hasT) {
                return VirtualSequence.DimensionArrangement.XYCT;
            }
            return VirtualSequence.DimensionArrangement.XYC;
        }
        if (hasZ) {
            if (hasT) {
                return VirtualSequence.DimensionArrangement.XYZT;
            }
            return VirtualSequence.DimensionArrangement.XYZ;
        }
        if (hasT) {
            return VirtualSequence.DimensionArrangement.XYT;
        }
        return VirtualSequence.DimensionArrangement.XY;
    }

    private ImgLib2IcyFunctions() {
    }
}

