/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.Iterator;
import java.util.List;
import net.imglib2.EuclideanSpace;
import net.imglib2.IterableRealInterval;
import net.imglib2.KDTreeNode;
import net.imglib2.RealCursor;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;
import net.imglib2.converter.AbstractConvertedIterableRealInterval;
import net.imglib2.converter.AbstractConvertedRealCursor;
import net.imglib2.kdtree.KDTreeData;
import net.imglib2.kdtree.KDTreeImpl;
import net.imglib2.util.Cast;

public class KDTree<T>
implements EuclideanSpace,
IterableRealInterval<T> {
    private final KDTreeData<T> treeData;
    final KDTreeImpl impl;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public KDTreeData<T> treeData() {
        return this.treeData;
    }

    public KDTreeImpl impl() {
        return this.impl;
    }

    public <L extends RealLocalizable> KDTree(List<T> values, List<L> positions) {
        this(KDTree.verifySize(values, positions), values, positions);
    }

    private static int verifySize(List<?> values, List<?> positions) {
        if (values.size() != positions.size()) {
            throw new IllegalArgumentException("The list of values and the list of positions provided to KDTree should have the same size.");
        }
        if (positions.isEmpty()) {
            throw new IllegalArgumentException("List of positions is empty. At least one point is requires to construct a KDTree.");
        }
        return values.size();
    }

    public KDTree(IterableRealInterval<T> interval) {
        this(KDTree.verifySize(interval), KDTree.copySamplesIterable(interval), KDTree.positionsIterable(interval));
    }

    private static int verifySize(IterableRealInterval<?> interval) {
        long size = interval.size();
        if (size > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("Interval contains too many points to store in KDTree");
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("Interval is empty. At least one point is requires to construct a KDTree.");
        }
        return (int)size;
    }

    private static <A> Iterable<RealLocalizable> positionsIterable(IterableRealInterval<A> sourceInterval) {
        return new AbstractConvertedIterableRealInterval<A, RealLocalizable>((IterableRealInterval)sourceInterval){

            @Override
            public AbstractConvertedRealCursor<A, RealLocalizable> cursor() {
                return new Cursor(((IterableRealInterval)this.sourceInterval).cursor());
            }

            @Override
            public AbstractConvertedRealCursor<A, RealLocalizable> localizingCursor() {
                return new Cursor(((IterableRealInterval)this.sourceInterval).localizingCursor());
            }

            class Cursor
            extends AbstractConvertedRealCursor<A, RealLocalizable> {
                Cursor(RealCursor<A> source) {
                    super(source);
                }

                @Override
                public RealLocalizable get() {
                    return this.source;
                }

                @Override
                public Cursor copy() {
                    return new Cursor(this.source.copy());
                }

                @Override
                public RealLocalizable getType() {
                    return this.source;
                }
            }
        };
    }

    private static <T> Iterable<T> copySamplesIterable(Iterable<T> source) {
        if (!(source.iterator() instanceof Sampler)) {
            throw new IllegalArgumentException();
        }
        return () -> {
            final Iterator it = source.iterator();
            final Sampler sampler = (Sampler)Cast.unchecked(it);
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public T next() {
                    it.next();
                    return sampler.copy().get();
                }
            };
        };
    }

    public <L extends RealLocalizable> KDTree(int numPoints, Iterable<T> values, Iterable<L> positions) {
        this(KDTreeData.create(numPoints, values, positions, true));
    }

    public KDTree(KDTreeData<T> data) {
        this.treeData = data;
        this.impl = new KDTreeImpl(this.treeData.positions());
    }

    @Deprecated
    public KDTreeNode<T> getRoot() {
        return new KDTreeNode(this).setNodeIndex(this.impl.root());
    }

    @Override
    public T getType() {
        return this.treeData.getType();
    }

    @Override
    public int numDimensions() {
        return this.impl.numDimensions();
    }

    @Override
    public double realMin(int d) {
        return this.treeData.boundingBox().realMin(d);
    }

    @Override
    public double realMax(int d) {
        return this.treeData.boundingBox().realMax(d);
    }

    public KDTreeCursor cursor() {
        return new KDTreeCursor();
    }

    public KDTreeCursor localizingCursor() {
        return this.cursor();
    }

    public KDTreeCursor iterator() {
        return this.cursor();
    }

    @Override
    public long size() {
        return this.impl.size();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    public String toString() {
        return this.toString(this.impl.root(), "", this.createNode());
    }

    private String toString(int node, String indent, KDTreeNode<T> ref) {
        if (node < 0) {
            return "";
        }
        return indent + "- " + ref.setNodeIndex(node).toString() + "\n" + this.toString(this.impl.left(node), indent + "  ", ref) + this.toString(this.impl.right(node), indent + "  ", ref);
    }

    public KDTreeNode<T> createNode() {
        return new KDTreeNode(this);
    }

    KDTreeNode<T> left(KDTreeNode<T> parent) {
        int c = this.impl.left(parent.nodeIndex());
        return c < 0 ? null : this.createNode().setNodeIndex(c);
    }

    KDTreeNode<T> right(KDTreeNode<T> parent) {
        int c = this.impl.right(parent.nodeIndex());
        return c < 0 ? null : this.createNode().setNodeIndex(c);
    }

    public final class KDTreeCursor
    extends KDTreeNode<T>
    implements RealCursor<T> {
        KDTreeCursor() {
            super(KDTree.this);
            this.reset();
        }

        @Override
        public void fwd() {
            this.setNodeIndex(this.nodeIndex() + 1);
        }

        @Override
        public void reset() {
            this.setNodeIndex(-1);
        }

        @Override
        public boolean hasNext() {
            return this.nodeIndex() < KDTree.this.impl.size() - 1;
        }

        @Override
        public T getType() {
            return KDTree.this.treeData.getType();
        }

        @Override
        public KDTreeCursor copy() {
            KDTreeCursor copy = new KDTreeCursor();
            copy.setNodeIndex(this.nodeIndex());
            return copy;
        }
    }
}

