/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.fill;

import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.fill.Filter;
import net.imglib2.algorithm.fill.TypeWriter;
import net.imglib2.algorithm.fill.Writer;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.type.Type;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;

public class FloodFill {
    private static final int CLEANUP_THRESHOLD = 100000;

    public static <T extends Type<T>, U extends Type<U>> void fill(RandomAccessible<T> source, RandomAccessible<U> target, Localizable seed, U fillLabel, Shape shape) {
        RandomAccess<T> access = source.randomAccess();
        access.setPosition(seed);
        Object seedValue = ((Type)access.get()).copy();
        BiPredicate<Type, Type> filter = (t, u) -> t.valueEquals(seedValue) && !u.valueEquals(fillLabel);
        FloodFill.fill(source, target, seed, fillLabel, shape, filter);
    }

    public static <T, U extends Type<U>> void fill(RandomAccessible<T> source, RandomAccessible<U> target, Localizable seed, U fillLabel, Shape shape, BiPredicate<T, U> filter) {
        FloodFill.fill(source, target, seed, shape, filter, (U targetPixel) -> targetPixel.set(fillLabel));
    }

    public static <T, U> void fill(RandomAccessible<T> source, RandomAccessible<U> target, Localizable seed, Shape shape, BiPredicate<T, U> filter, Consumer<U> writer) {
        int n = source.numDimensions();
        RandomAccessible<Pair<T, U>> paired = Views.pair(source, target);
        TLongArrayList coordinates = new TLongArrayList();
        for (int d = 0; d < n; ++d) {
            coordinates.add(seed.getLongPosition(d));
        }
        int cleanupThreshold = n * 100000;
        RandomAccessible<Neighborhood<Pair<T, U>>> neighborhood = shape.neighborhoodsRandomAccessible(paired);
        RandomAccess<Neighborhood<Pair<T, U>>> neighborhoodAccess = neighborhood.randomAccess();
        RandomAccess<U> targetAccess = target.randomAccess();
        targetAccess.setPosition(seed);
        writer.accept(targetAccess.get());
        for (int i = 0; i < coordinates.size(); i += n) {
            for (int d = 0; d < n; ++d) {
                neighborhoodAccess.setPosition(coordinates.get(i + d), d);
            }
            RealCursor neighborhoodCursor = ((Neighborhood)neighborhoodAccess.get()).cursor();
            while (neighborhoodCursor.hasNext()) {
                Pair p = (Pair)neighborhoodCursor.next();
                if (!filter.test(p.getA(), p.getB())) continue;
                writer.accept(p.getB());
                for (int d = 0; d < n; ++d) {
                    coordinates.add(neighborhoodCursor.getLongPosition(d));
                }
            }
            if (i <= cleanupThreshold) continue;
            coordinates = coordinates.subList(i, coordinates.size());
            i = 0;
        }
    }

    @Deprecated
    public static <T extends Type<T>, U extends Type<U>> void fill(RandomAccessible<T> source, RandomAccessible<U> target, Localizable seed, U fillLabel, Shape shape, Filter<Pair<T, U>, Pair<T, U>> filter) {
        RandomAccess<T> access = source.randomAccess();
        access.setPosition(seed);
        FloodFill.fill(source, target, seed, ((Type)access.get()).copy(), fillLabel, shape, filter);
    }

    @Deprecated
    public static <T, U extends Type<U>> void fill(RandomAccessible<T> source, RandomAccessible<U> target, Localizable seed, T seedLabel, U fillLabel, Shape shape, Filter<Pair<T, U>, Pair<T, U>> filter) {
        FloodFill.fill(source, target, seed, seedLabel, fillLabel, shape, filter, new TypeWriter());
    }

    @Deprecated
    public static <T, U> void fill(RandomAccessible<T> source, RandomAccessible<U> target, Localizable seed, T seedLabel, U fillLabel, Shape shape, Filter<Pair<T, U>, Pair<T, U>> filter, Writer<U> writer) {
        int n = source.numDimensions();
        ValuePair<T, U> reference = new ValuePair<T, U>(seedLabel, fillLabel);
        RandomAccessible<Pair<T, U>> paired = Views.pair(source, target);
        TLongList[] coordinates = new TLongList[n];
        for (int d = 0; d < n; ++d) {
            coordinates[d] = new TLongArrayList();
            coordinates[d].add(seed.getLongPosition(d));
        }
        RandomAccessible<Neighborhood<Pair<T, U>>> neighborhood = shape.neighborhoodsRandomAccessible(paired);
        RandomAccess<Neighborhood<Pair<T, U>>> neighborhoodAccess = neighborhood.randomAccess();
        RandomAccess<U> targetAccess = target.randomAccess();
        targetAccess.setPosition(seed);
        writer.write(fillLabel, targetAccess.get());
        for (int i = 0; i < coordinates[0].size(); ++i) {
            for (int d = 0; d < n; ++d) {
                neighborhoodAccess.setPosition(coordinates[d].get(i), d);
            }
            RealCursor neighborhoodCursor = ((Neighborhood)neighborhoodAccess.get()).cursor();
            while (neighborhoodCursor.hasNext()) {
                Pair p = (Pair)neighborhoodCursor.next();
                if (!filter.accept(p, reference)) continue;
                writer.write(fillLabel, p.getB());
                for (int d = 0; d < n; ++d) {
                    coordinates[d].add(neighborhoodCursor.getLongPosition(d));
                }
            }
            if (i <= 100000) continue;
            for (int d = 0; d < coordinates.length; ++d) {
                TLongList c = coordinates[d];
                coordinates[d] = c.subList(i, c.size());
            }
            i = 0;
        }
    }
}

