/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gradient;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class PartialDerivative {
    public static <T extends NumericType<T>> void gradientCentralDifference2(RandomAccessible<T> source, RandomAccessibleInterval<T> gradient, int dimension) {
        RealCursor front = Views.flatIterable(Views.interval(source, Intervals.translate(gradient, 1L, dimension))).cursor();
        RealCursor back = Views.flatIterable(Views.interval(source, Intervals.translate(gradient, -1L, dimension))).cursor();
        for (NumericType t : Views.flatIterable(gradient)) {
            t.set((Type)front.next());
            t.sub(back.next());
            t.mul(0.5);
        }
    }

    public static <T extends NumericType<T>> void gradientCentralDifferenceParallel(RandomAccessible<T> source, RandomAccessibleInterval<T> gradient, int dimension, int nTasks, ExecutorService es) throws InterruptedException, ExecutionException {
        int nDim = source.numDimensions();
        if (nDim < 2) {
            PartialDerivative.gradientCentralDifference(source, gradient, dimension);
            return;
        }
        long dimensionMax = Long.MIN_VALUE;
        int dimensionArgMax = -1;
        for (int d = 0; d < nDim; ++d) {
            long size = gradient.dimension(d);
            if (d == dimension || size <= dimensionMax) continue;
            dimensionMax = size;
            dimensionArgMax = d;
        }
        long stepSize = Math.max(dimensionMax / (long)nTasks, 1L);
        long stepSizeMinusOne = stepSize - 1L;
        long min = gradient.min(dimensionArgMax);
        long max = gradient.max(dimensionArgMax);
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        long currentMin = min;
        for (long minZeroBase = 0L; minZeroBase < dimensionMax; minZeroBase += stepSize) {
            long currentMax = Math.min(currentMin + stepSizeMinusOne, max);
            long[] mins = new long[nDim];
            long[] maxs = new long[nDim];
            gradient.min(mins);
            gradient.max(maxs);
            mins[dimensionArgMax] = currentMin;
            maxs[dimensionArgMax] = currentMax;
            IntervalView currentInterval = Views.interval(gradient, new FinalInterval(mins, maxs));
            tasks.add(() -> {
                PartialDerivative.gradientCentralDifference(source, currentInterval, dimension);
                return null;
            });
            currentMin += stepSize;
        }
        List futures = es.invokeAll(tasks);
        for (Future f : futures) {
            f.get();
        }
    }

    public static <T extends NumericType<T>> void gradientCentralDifference(RandomAccessible<T> source, RandomAccessibleInterval<T> result, int dimension) {
        IntervalView<T> back = Views.interval(source, Intervals.translate(result, -1L, dimension));
        IntervalView<T> front = Views.interval(source, Intervals.translate(result, 1L, dimension));
        LoopBuilder.setImages(result, back, front).forEachPixel((r, b, f) -> {
            r.set(f);
            r.sub(b);
            r.mul(0.5);
        });
    }

    public static <T extends NumericType<T>> void gradientBackwardDifference(RandomAccessible<T> source, RandomAccessibleInterval<T> result, int dimension) {
        IntervalView<T> back = Views.interval(source, Intervals.translate(result, -1L, dimension));
        IntervalView<T> front = Views.interval(source, result);
        LoopBuilder.setImages(result, back, front).forEachPixel((r, b, f) -> {
            r.set(f);
            r.sub(b);
        });
    }

    public static <T extends NumericType<T>> void gradientForwardDifference(RandomAccessible<T> source, RandomAccessibleInterval<T> result, int dimension) {
        IntervalView<T> back = Views.interval(source, result);
        IntervalView<T> front = Views.interval(source, Intervals.translate(result, 1L, dimension));
        LoopBuilder.setImages(result, back, front).forEachPixel((r, b, f) -> {
            r.set(f);
            r.sub(b);
        });
    }
}

