/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology.distance;

import net.imglib2.algorithm.morphology.distance.Distance;

public class EuclidianDistanceIsotropic
implements Distance {
    private final double weight;
    private final double oneOverTwoTimesWeight;

    public EuclidianDistanceIsotropic(double weight) {
        this.weight = weight;
        this.oneOverTwoTimesWeight = 0.5 / weight;
    }

    @Override
    public double evaluate(double x, double xShift, double yShift, int dim) {
        double diff = x - xShift;
        return this.weight * diff * diff + yShift;
    }

    @Override
    public double intersect(double xShift1, double yShift1, double xShift2, double yShift2, int dim) {
        return this.oneOverTwoTimesWeight * (this.weight * xShift2 * xShift2 + yShift2 - (this.weight * xShift1 * xShift1 + yShift1)) / (xShift2 - xShift1);
    }
}

