/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodLocalizableSampler;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.util.IntervalIndexer;

public class DiamondTipsNeighborhoodCursor<T>
extends DiamondTipsNeighborhoodLocalizableSampler<T>
implements Cursor<Neighborhood<T>> {
    private final long[] dimensions;
    private final long maxIndex;
    private long maxIndexOnLine;
    private long index;
    private long[] min;
    private long[] max;

    public DiamondTipsNeighborhoodCursor(RandomAccessibleInterval<T> source, long radius, DiamondTipsNeighborhoodFactory<T> factory) {
        super(source, radius, factory, source);
        this.dimensions = new long[this.n];
        this.min = new long[this.n];
        this.max = new long[this.n];
        source.dimensions(this.dimensions);
        source.min(this.min);
        source.max(this.max);
        long size = this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            size *= this.dimensions[d];
        }
        this.maxIndex = size - 1L;
        this.reset();
    }

    public DiamondTipsNeighborhoodCursor(DiamondTipsNeighborhoodCursor<T> c) {
        super(c);
        this.dimensions = (long[])c.dimensions.clone();
        this.maxIndex = c.maxIndex;
        this.index = c.index;
        this.maxIndexOnLine = c.maxIndexOnLine;
    }

    @Override
    public void fwd() {
        this.currentPos[0] = this.currentPos[0] + 1L;
        if (++this.index > this.maxIndexOnLine) {
            this.nextLine();
        }
    }

    private void nextLine() {
        this.currentPos[0] = this.min[0];
        this.maxIndexOnLine += this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + 1L;
            if (this.currentPos[d] <= this.max[d]) break;
            this.currentPos[d] = this.min[d];
        }
    }

    @Override
    public void reset() {
        this.index = -1L;
        this.maxIndexOnLine = -1L;
        System.arraycopy(this.max, 0, this.currentPos, 0, this.n);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    @Override
    public void jumpFwd(long steps) {
        this.index += steps;
        if (this.index < 0L) {
            this.maxIndexOnLine = (1L + this.index) / this.dimensions[0] * this.dimensions[0] - 1L;
            long size = this.maxIndex + 1L;
            IntervalIndexer.indexToPositionWithOffset(size - -this.index % size, this.dimensions, this.min, this.currentPos);
        } else {
            this.maxIndexOnLine = (1L + this.index / this.dimensions[0]) * this.dimensions[0] - 1L;
            IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.min, this.currentPos);
        }
    }

    @Override
    public Neighborhood<T> next() {
        this.fwd();
        return this.get();
    }

    @Override
    public void remove() {
    }

    @Override
    public DiamondTipsNeighborhoodCursor<T> copy() {
        return new DiamondTipsNeighborhoodCursor<T>(this);
    }

    @Override
    public DiamondTipsNeighborhoodCursor<T> copyCursor() {
        return this.copy();
    }
}

