/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import java.util.Arrays;
import java.util.Iterator;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractInterval;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhood;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodCursor;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodRandomAccess;
import net.imglib2.algorithm.neighborhood.DiamondTipsNeighborhoodUnsafe;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;

public class DiamondTipsShape
implements Shape {
    private final long radius;

    public DiamondTipsShape(long radius) {
        this.radius = radius;
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoods(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsIterableInterval<T>(source, this.radius, DiamondTipsNeighborhoodUnsafe.factory());
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessible(RandomAccessible<T> source) {
        DiamondTipsNeighborhoodFactory f = DiamondTipsNeighborhoodUnsafe.factory();
        return new NeighborhoodsAccessible<T>(source, this.radius, f);
    }

    public <T> NeighborhoodsIterableInterval<T> neighborhoodsSafe(RandomAccessibleInterval<T> source) {
        return new NeighborhoodsIterableInterval<T>(source, this.radius, DiamondTipsNeighborhood.factory());
    }

    public <T> NeighborhoodsAccessible<T> neighborhoodsRandomAccessibleSafe(RandomAccessible<T> source) {
        DiamondTipsNeighborhoodFactory f = DiamondTipsNeighborhood.factory();
        return new NeighborhoodsAccessible<T>(source, this.radius, f);
    }

    public long getRadius() {
        return this.radius;
    }

    public String toString() {
        return "DiamondTipsShape, radius = " + this.radius;
    }

    @Override
    public Interval getStructuringElementBoundingBox(int numDimensions) {
        long[] min = new long[numDimensions];
        Arrays.fill(min, -this.getRadius());
        long[] max = new long[numDimensions];
        Arrays.fill(max, this.getRadius());
        return new FinalInterval(min, max);
    }

    public static final class NeighborhoodsAccessible<T>
    extends AbstractEuclideanSpace
    implements RandomAccessible<Neighborhood<T>> {
        final RandomAccessible<T> source;
        final DiamondTipsNeighborhoodFactory<T> factory;
        private final long radius;

        public NeighborhoodsAccessible(RandomAccessible<T> source, long radius, DiamondTipsNeighborhoodFactory<T> factory) {
            super(source.numDimensions());
            this.source = source;
            this.radius = radius;
            this.factory = factory;
        }

        @Override
        public RandomAccess<Neighborhood<T>> randomAccess() {
            return new DiamondTipsNeighborhoodRandomAccess<T>(this.source, this.radius, this.factory);
        }

        @Override
        public RandomAccess<Neighborhood<T>> randomAccess(Interval interval) {
            return this.randomAccess();
        }

        @Override
        public int numDimensions() {
            return this.source.numDimensions();
        }
    }

    public static final class NeighborhoodsIterableInterval<T>
    extends AbstractInterval
    implements IterableInterval<Neighborhood<T>> {
        final RandomAccessibleInterval<T> source;
        final DiamondTipsNeighborhoodFactory<T> factory;
        final long size;
        private final long radius;

        public NeighborhoodsIterableInterval(RandomAccessibleInterval<T> source, long radius, DiamondTipsNeighborhoodFactory<T> factory) {
            super(source);
            this.source = source;
            this.radius = radius;
            this.factory = factory;
            long s = source.dimension(0);
            for (int d = 1; d < this.n; ++d) {
                s *= source.dimension(d);
            }
            this.size = s;
        }

        @Override
        public Cursor<Neighborhood<T>> cursor() {
            return new DiamondTipsNeighborhoodCursor<T>(this.source, this.radius, this.factory);
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public Neighborhood<T> firstElement() {
            return (Neighborhood)this.cursor().next();
        }

        @Override
        public Object iterationOrder() {
            return new FlatIterationOrder(this);
        }

        @Override
        public Iterator<Neighborhood<T>> iterator() {
            return this.cursor();
        }

        @Override
        public Cursor<Neighborhood<T>> localizingCursor() {
            return this.cursor();
        }
    }
}

