/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.neighborhood;

import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodFactory;
import net.imglib2.algorithm.neighborhood.RectangleNeighborhoodLocalizableSampler;
import net.imglib2.util.IntervalIndexer;

public final class RectangleNeighborhoodCursor<T>
extends RectangleNeighborhoodLocalizableSampler<T>
implements Cursor<Neighborhood<T>> {
    private final long[] dimensions;
    private final long[] min;
    private final long[] max;
    private long index;
    private final long maxIndex;
    private long maxIndexOnLine;

    public RectangleNeighborhoodCursor(RandomAccessibleInterval<T> source, Interval span, RectangleNeighborhoodFactory<T> factory) {
        super(source, span, factory, source);
        this.dimensions = new long[this.n];
        this.min = new long[this.n];
        this.max = new long[this.n];
        source.dimensions(this.dimensions);
        source.min(this.min);
        source.max(this.max);
        long size = this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            size *= this.dimensions[d];
        }
        this.maxIndex = size - 1L;
        this.reset();
    }

    private RectangleNeighborhoodCursor(RectangleNeighborhoodCursor<T> c) {
        super(c);
        this.dimensions = (long[])c.dimensions.clone();
        this.min = (long[])c.min.clone();
        this.max = (long[])c.max.clone();
        this.maxIndex = c.maxIndex;
        this.index = c.index;
        this.maxIndexOnLine = c.maxIndexOnLine;
    }

    @Override
    public void fwd() {
        this.currentPos[0] = this.currentPos[0] + 1L;
        this.currentMin[0] = this.currentMin[0] + 1L;
        this.currentMax[0] = this.currentMax[0] + 1L;
        if (++this.index > this.maxIndexOnLine) {
            this.nextLine();
        }
    }

    private void nextLine() {
        this.currentPos[0] = this.min[0];
        this.currentMin[0] = this.currentMin[0] - this.dimensions[0];
        this.currentMax[0] = this.currentMax[0] - this.dimensions[0];
        this.maxIndexOnLine += this.dimensions[0];
        for (int d = 1; d < this.n; ++d) {
            int n = d;
            this.currentPos[n] = this.currentPos[n] + 1L;
            int n2 = d;
            this.currentMin[n2] = this.currentMin[n2] + 1L;
            int n3 = d;
            this.currentMax[n3] = this.currentMax[n3] + 1L;
            if (this.currentPos[d] <= this.max[d]) break;
            this.currentPos[d] = this.min[d];
            int n4 = d;
            this.currentMin[n4] = this.currentMin[n4] - this.dimensions[d];
            int n5 = d;
            this.currentMax[n5] = this.currentMax[n5] - this.dimensions[d];
        }
    }

    @Override
    public void reset() {
        this.index = -1L;
        this.maxIndexOnLine = -1L;
        for (int d = 0; d < this.n; ++d) {
            this.currentPos[d] = this.max[d];
            this.currentMin[d] = this.currentPos[d] + this.span.min(d);
            this.currentMax[d] = this.currentPos[d] + this.span.max(d);
        }
    }

    @Override
    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    @Override
    public void jumpFwd(long steps) {
        this.index += steps;
        if (this.index < 0L) {
            this.maxIndexOnLine = (1L + this.index) / this.dimensions[0] * this.dimensions[0] - 1L;
            long size = this.maxIndex + 1L;
            IntervalIndexer.indexToPositionWithOffset(size - -this.index % size, this.dimensions, this.min, this.currentPos);
        } else {
            this.maxIndexOnLine = (1L + this.index / this.dimensions[0]) * this.dimensions[0] - 1L;
            IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.min, this.currentPos);
        }
        for (int d = 0; d < this.n; ++d) {
            this.currentMin[d] = this.currentPos[d] + this.span.min(d);
            this.currentMax[d] = this.currentPos[d] + this.span.max(d);
        }
    }

    @Override
    public Neighborhood<T> next() {
        this.fwd();
        return this.get();
    }

    @Override
    public void remove() {
    }

    @Override
    public RectangleNeighborhoodCursor<T> copy() {
        return new RectangleNeighborhoodCursor<T>(this);
    }

    @Override
    public RectangleNeighborhoodCursor<T> copyCursor() {
        return this.copy();
    }
}

