/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import net.imglib2.blocks.MemCopy;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Cast;
import net.imglib2.util.IntervalIndexer;

public interface SubArrayCopy {
    public static void copy(Object src, int[] srcSize, int[] srcPos, Object dest, int[] destSize, int[] destPos, int[] size) {
        MemCopy<?, ?> memcopy = MemCopy.forClasses(src.getClass(), dest.getClass());
        int n = srcSize.length;
        if (!1.$assertionsDisabled && srcPos.length != n) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && destSize.length != n) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && destPos.length != n) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && size.length != n) {
            throw new AssertionError();
        }
        int[] srcStrides = IntervalIndexer.createAllocationSteps(srcSize);
        int[] destStrides = IntervalIndexer.createAllocationSteps(destSize);
        int oSrc = IntervalIndexer.positionToIndex(srcPos, srcSize);
        int oDest = IntervalIndexer.positionToIndex(destPos, destSize);
        memcopy.copyNDRangeRecursive(n - 1, src, srcStrides, oSrc, dest, destStrides, oDest, size);
    }

    public static <T> Typed<T, T> forPrimitiveType(PrimitiveType primitiveType) {
        MemCopy memcopy = (MemCopy)Cast.unchecked(MemCopy.forPrimitiveType(primitiveType, false, false));
        return memcopy::copyNDRangeRecursive;
    }

    public static <S, T> Typed<S, T> forPrimitiveType(PrimitiveType primitiveType, boolean fromBuffer, boolean toBuffer) {
        MemCopy memcopy = (MemCopy)Cast.unchecked(MemCopy.forPrimitiveType(primitiveType, fromBuffer, toBuffer));
        return memcopy::copyNDRangeRecursive;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Typed<S, T> {
        default public void copy(S src, int[] srcSize, int[] srcPos, T dest, int[] destSize, int[] destPos, int[] size) {
            int n = srcSize.length;
            if (!1.$assertionsDisabled && srcPos.length != n) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && destSize.length != n) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && destPos.length != n) {
                throw new AssertionError();
            }
            if (!1.$assertionsDisabled && size.length != n) {
                throw new AssertionError();
            }
            int[] srcStrides = IntervalIndexer.createAllocationSteps(srcSize);
            int[] destStrides = IntervalIndexer.createAllocationSteps(destSize);
            int oSrc = IntervalIndexer.positionToIndex(srcPos, srcSize);
            int oDest = IntervalIndexer.positionToIndex(destPos, destSize);
            this.copyNDRangeRecursive(n - 1, src, srcStrides, oSrc, dest, destStrides, oDest, size);
        }

        public void copyNDRangeRecursive(int var1, S var2, int[] var3, int var4, T var5, int[] var6, int var7, int[] var8);
    }
}

