/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.array.AbstractByteArray;
import net.imglib2.img.basictypeaccess.array.AbstractCharArray;
import net.imglib2.img.basictypeaccess.array.AbstractDoubleArray;
import net.imglib2.img.basictypeaccess.array.AbstractFloatArray;
import net.imglib2.img.basictypeaccess.array.AbstractIntArray;
import net.imglib2.img.basictypeaccess.array.AbstractLongArray;
import net.imglib2.img.basictypeaccess.array.AbstractShortArray;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DirtyByteArray;
import net.imglib2.img.basictypeaccess.array.DirtyCharArray;
import net.imglib2.img.basictypeaccess.array.DirtyDoubleArray;
import net.imglib2.img.basictypeaccess.array.DirtyFloatArray;
import net.imglib2.img.basictypeaccess.array.DirtyIntArray;
import net.imglib2.img.basictypeaccess.array.DirtyLongArray;
import net.imglib2.img.basictypeaccess.array.DirtyShortArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileCharArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.DirtyVolatileShortArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileCharArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;

public interface AccessIo<A> {
    public static final DoubleArrayType doubleArrayIo = new DoubleArrayType();
    public static final VolatileDoubleArrayType volatileDoubleArrayIo = new VolatileDoubleArrayType();
    public static final DirtyDoubleArrayType dirtyDoubleArrayIo = new DirtyDoubleArrayType();
    public static final DirtyVolatileDoubleArrayType dirtyVolatileDoubleArrayIo = new DirtyVolatileDoubleArrayType();
    public static final FloatArrayType floatArrayIo = new FloatArrayType();
    public static final VolatileFloatArrayType volatileFloatArrayIo = new VolatileFloatArrayType();
    public static final DirtyFloatArrayType dirtyFloatArrayIo = new DirtyFloatArrayType();
    public static final DirtyVolatileFloatArrayType dirtyVolatileFloatArrayIo = new DirtyVolatileFloatArrayType();
    public static final IntArrayType intArrayIo = new IntArrayType();
    public static final VolatileIntArrayType volatileIntArrayIo = new VolatileIntArrayType();
    public static final DirtyIntArrayType dirtyIntArrayIo = new DirtyIntArrayType();
    public static final DirtyVolatileIntArrayType dirtyVolatileIntArrayIo = new DirtyVolatileIntArrayType();
    public static final LongArrayType longArrayIo = new LongArrayType();
    public static final VolatileLongArrayType volatileLongArrayIo = new VolatileLongArrayType();
    public static final DirtyLongArrayType dirtyLongArrayIo = new DirtyLongArrayType();
    public static final DirtyVolatileLongArrayType dirtyVolatileLongArrayIo = new DirtyVolatileLongArrayType();
    public static final ShortArrayType shortArrayIo = new ShortArrayType();
    public static final VolatileShortArrayType volatileShortArrayIo = new VolatileShortArrayType();
    public static final DirtyShortArrayType dirtyShortArrayIo = new DirtyShortArrayType();
    public static final DirtyVolatileShortArrayType dirtyVolatileShortArrayIo = new DirtyVolatileShortArrayType();
    public static final CharArrayType charArrayIo = new CharArrayType();
    public static final VolatileCharArrayType volatileCharArrayIo = new VolatileCharArrayType();
    public static final DirtyCharArrayType dirtyCharArrayIo = new DirtyCharArrayType();
    public static final DirtyVolatileCharArrayType dirtyVolatileCharArrayIo = new DirtyVolatileCharArrayType();
    public static final ByteArrayType byteArrayIo = new ByteArrayType();
    public static final VolatileByteArrayType volatileByteArrayIo = new VolatileByteArrayType();
    public static final DirtyByteArrayType dirtyByteArrayIo = new DirtyByteArrayType();
    public static final DirtyVolatileByteArrayType dirtyVolatileByteArrayIo = new DirtyVolatileByteArrayType();

    public A load(ByteBuffer var1, int var2);

    public int getBytesPerElement();

    public void save(A var1, ByteBuffer var2, int var3);

    public static <T extends NativeType<T>, A> AccessIo<A> get(T type, Set<AccessFlags> flags) {
        return AccessIo.get(type.getNativeTypeFactory().getPrimitiveType(), flags);
    }

    public static <A> AccessIo<A> get(PrimitiveType primitiveType, Set<AccessFlags> flags) {
        boolean dirty = flags.contains((Object)AccessFlags.DIRTY);
        boolean volatil = flags.contains((Object)AccessFlags.VOLATILE);
        switch (primitiveType) {
            case BYTE: {
                return dirty ? (volatil ? dirtyVolatileByteArrayIo : dirtyByteArrayIo) : (volatil ? volatileByteArrayIo : byteArrayIo);
            }
            case CHAR: {
                return dirty ? (volatil ? dirtyVolatileCharArrayIo : dirtyCharArrayIo) : (volatil ? volatileCharArrayIo : charArrayIo);
            }
            case DOUBLE: {
                return dirty ? (volatil ? dirtyVolatileDoubleArrayIo : dirtyDoubleArrayIo) : (volatil ? volatileDoubleArrayIo : doubleArrayIo);
            }
            case FLOAT: {
                return dirty ? (volatil ? dirtyVolatileFloatArrayIo : dirtyFloatArrayIo) : (volatil ? volatileFloatArrayIo : floatArrayIo);
            }
            case INT: {
                return dirty ? (volatil ? dirtyVolatileIntArrayIo : dirtyIntArrayIo) : (volatil ? volatileIntArrayIo : intArrayIo);
            }
            case LONG: {
                return dirty ? (volatil ? dirtyVolatileLongArrayIo : dirtyLongArrayIo) : (volatil ? volatileLongArrayIo : longArrayIo);
            }
            case SHORT: {
                return dirty ? (volatil ? dirtyVolatileShortArrayIo : dirtyShortArrayIo) : (volatil ? volatileShortArrayIo : shortArrayIo);
            }
        }
        return null;
    }

    public static class DirtyVolatileByteArrayType
    extends AbstractByteArrayIo<DirtyVolatileByteArray> {
        @Override
        public DirtyVolatileByteArray load(ByteBuffer bytes, int numElements) {
            return new DirtyVolatileByteArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class DirtyByteArrayType
    extends AbstractByteArrayIo<DirtyByteArray> {
        @Override
        public DirtyByteArray load(ByteBuffer bytes, int numElements) {
            return new DirtyByteArray(this.loadData(bytes, numElements));
        }
    }

    public static class VolatileByteArrayType
    extends AbstractByteArrayIo<VolatileByteArray> {
        @Override
        public VolatileByteArray load(ByteBuffer bytes, int numElements) {
            return new VolatileByteArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class ByteArrayType
    extends AbstractByteArrayIo<ByteArray> {
        @Override
        public ByteArray load(ByteBuffer bytes, int numElements) {
            return new ByteArray(this.loadData(bytes, numElements));
        }
    }

    public static abstract class AbstractByteArrayIo<A extends AbstractByteArray<A>>
    implements AccessIo<A> {
        @Override
        public int getBytesPerElement() {
            return 1;
        }

        protected byte[] loadData(ByteBuffer bytes, int numElements) {
            byte[] data = new byte[numElements];
            ByteBuffer.wrap(data, 0, numElements).put(bytes);
            return data;
        }

        @Override
        public void save(A access, ByteBuffer out, int numElements) {
            byte[] data = ((AbstractByteArray)access).getCurrentStorageArray();
            out.put(ByteBuffer.wrap(data, 0, numElements));
        }
    }

    public static class DirtyVolatileCharArrayType
    extends AbstractCharArrayIo<DirtyVolatileCharArray> {
        @Override
        public DirtyVolatileCharArray load(ByteBuffer bytes, int numElements) {
            return new DirtyVolatileCharArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class DirtyCharArrayType
    extends AbstractCharArrayIo<DirtyCharArray> {
        @Override
        public DirtyCharArray load(ByteBuffer bytes, int numElements) {
            return new DirtyCharArray(this.loadData(bytes, numElements));
        }
    }

    public static class VolatileCharArrayType
    extends AbstractCharArrayIo<VolatileCharArray> {
        @Override
        public VolatileCharArray load(ByteBuffer bytes, int numElements) {
            return new VolatileCharArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class CharArrayType
    extends AbstractCharArrayIo<CharArray> {
        @Override
        public CharArray load(ByteBuffer bytes, int numElements) {
            return new CharArray(this.loadData(bytes, numElements));
        }
    }

    public static abstract class AbstractCharArrayIo<A extends AbstractCharArray<A>>
    implements AccessIo<A> {
        @Override
        public int getBytesPerElement() {
            return 1;
        }

        protected char[] loadData(ByteBuffer bytes, int numElements) {
            char[] data = new char[numElements];
            CharBuffer.wrap(data, 0, numElements).put(bytes.asCharBuffer());
            return data;
        }

        @Override
        public void save(A access, ByteBuffer out, int numElements) {
            char[] data = ((AbstractCharArray)access).getCurrentStorageArray();
            out.asCharBuffer().put(CharBuffer.wrap(data, 0, numElements));
        }
    }

    public static class DirtyVolatileShortArrayType
    extends AbstractShortArrayIo<DirtyVolatileShortArray> {
        @Override
        public DirtyVolatileShortArray load(ByteBuffer bytes, int numElements) {
            return new DirtyVolatileShortArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class DirtyShortArrayType
    extends AbstractShortArrayIo<DirtyShortArray> {
        @Override
        public DirtyShortArray load(ByteBuffer bytes, int numElements) {
            return new DirtyShortArray(this.loadData(bytes, numElements));
        }
    }

    public static class VolatileShortArrayType
    extends AbstractShortArrayIo<VolatileShortArray> {
        @Override
        public VolatileShortArray load(ByteBuffer bytes, int numElements) {
            return new VolatileShortArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class ShortArrayType
    extends AbstractShortArrayIo<ShortArray> {
        @Override
        public ShortArray load(ByteBuffer bytes, int numElements) {
            return new ShortArray(this.loadData(bytes, numElements));
        }
    }

    public static abstract class AbstractShortArrayIo<A extends AbstractShortArray<A>>
    implements AccessIo<A> {
        @Override
        public int getBytesPerElement() {
            return 2;
        }

        protected short[] loadData(ByteBuffer bytes, int numElements) {
            short[] data = new short[numElements];
            ShortBuffer.wrap(data, 0, numElements).put(bytes.asShortBuffer());
            return data;
        }

        @Override
        public void save(A access, ByteBuffer out, int numElements) {
            short[] data = ((AbstractShortArray)access).getCurrentStorageArray();
            out.asShortBuffer().put(ShortBuffer.wrap(data, 0, numElements));
        }
    }

    public static class DirtyVolatileLongArrayType
    extends AbstractLongArrayIo<DirtyVolatileLongArray> {
        @Override
        public DirtyVolatileLongArray load(ByteBuffer bytes, int numElements) {
            return new DirtyVolatileLongArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class DirtyLongArrayType
    extends AbstractLongArrayIo<DirtyLongArray> {
        @Override
        public DirtyLongArray load(ByteBuffer bytes, int numElements) {
            return new DirtyLongArray(this.loadData(bytes, numElements));
        }
    }

    public static class VolatileLongArrayType
    extends AbstractLongArrayIo<VolatileLongArray> {
        @Override
        public VolatileLongArray load(ByteBuffer bytes, int numElements) {
            return new VolatileLongArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class LongArrayType
    extends AbstractLongArrayIo<LongArray> {
        @Override
        public LongArray load(ByteBuffer bytes, int numElements) {
            return new LongArray(this.loadData(bytes, numElements));
        }
    }

    public static abstract class AbstractLongArrayIo<A extends AbstractLongArray<A>>
    implements AccessIo<A> {
        @Override
        public int getBytesPerElement() {
            return 8;
        }

        protected long[] loadData(ByteBuffer bytes, int numElements) {
            long[] data = new long[numElements];
            LongBuffer.wrap(data, 0, numElements).put(bytes.asLongBuffer());
            return data;
        }

        @Override
        public void save(A access, ByteBuffer out, int numElements) {
            long[] data = ((AbstractLongArray)access).getCurrentStorageArray();
            out.asLongBuffer().put(LongBuffer.wrap(data, 0, numElements));
        }
    }

    public static class DirtyVolatileIntArrayType
    extends AbstractIntArrayIo<DirtyVolatileIntArray> {
        @Override
        public DirtyVolatileIntArray load(ByteBuffer bytes, int numElements) {
            return new DirtyVolatileIntArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class DirtyIntArrayType
    extends AbstractIntArrayIo<DirtyIntArray> {
        @Override
        public DirtyIntArray load(ByteBuffer bytes, int numElements) {
            return new DirtyIntArray(this.loadData(bytes, numElements));
        }
    }

    public static class VolatileIntArrayType
    extends AbstractIntArrayIo<VolatileIntArray> {
        @Override
        public VolatileIntArray load(ByteBuffer bytes, int numElements) {
            return new VolatileIntArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class IntArrayType
    extends AbstractIntArrayIo<IntArray> {
        @Override
        public IntArray load(ByteBuffer bytes, int numElements) {
            return new IntArray(this.loadData(bytes, numElements));
        }
    }

    public static abstract class AbstractIntArrayIo<A extends AbstractIntArray<A>>
    implements AccessIo<A> {
        @Override
        public int getBytesPerElement() {
            return 4;
        }

        protected int[] loadData(ByteBuffer bytes, int numElements) {
            int[] data = new int[numElements];
            IntBuffer.wrap(data, 0, numElements).put(bytes.asIntBuffer());
            return data;
        }

        @Override
        public void save(A access, ByteBuffer out, int numElements) {
            int[] data = ((AbstractIntArray)access).getCurrentStorageArray();
            out.asIntBuffer().put(IntBuffer.wrap(data, 0, numElements));
        }
    }

    public static class DirtyVolatileFloatArrayType
    extends AbstractFloatArrayIo<DirtyVolatileFloatArray> {
        @Override
        public DirtyVolatileFloatArray load(ByteBuffer bytes, int numElements) {
            return new DirtyVolatileFloatArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class DirtyFloatArrayType
    extends AbstractFloatArrayIo<DirtyFloatArray> {
        @Override
        public DirtyFloatArray load(ByteBuffer bytes, int numElements) {
            return new DirtyFloatArray(this.loadData(bytes, numElements));
        }
    }

    public static class VolatileFloatArrayType
    extends AbstractFloatArrayIo<VolatileFloatArray> {
        @Override
        public VolatileFloatArray load(ByteBuffer bytes, int numElements) {
            return new VolatileFloatArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class FloatArrayType
    extends AbstractFloatArrayIo<FloatArray> {
        @Override
        public FloatArray load(ByteBuffer bytes, int numElements) {
            return new FloatArray(this.loadData(bytes, numElements));
        }
    }

    public static abstract class AbstractFloatArrayIo<A extends AbstractFloatArray<A>>
    implements AccessIo<A> {
        @Override
        public int getBytesPerElement() {
            return 4;
        }

        protected float[] loadData(ByteBuffer bytes, int numElements) {
            float[] data = new float[numElements];
            FloatBuffer.wrap(data, 0, numElements).put(bytes.asFloatBuffer());
            return data;
        }

        @Override
        public void save(A access, ByteBuffer out, int numElements) {
            float[] data = ((AbstractFloatArray)access).getCurrentStorageArray();
            out.asFloatBuffer().put(FloatBuffer.wrap(data, 0, numElements));
        }
    }

    public static class DirtyVolatileDoubleArrayType
    extends AbstractDoubleArrayIo<DirtyVolatileDoubleArray> {
        @Override
        public DirtyVolatileDoubleArray load(ByteBuffer bytes, int numElements) {
            return new DirtyVolatileDoubleArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class DirtyDoubleArrayType
    extends AbstractDoubleArrayIo<DirtyDoubleArray> {
        @Override
        public DirtyDoubleArray load(ByteBuffer bytes, int numElements) {
            return new DirtyDoubleArray(this.loadData(bytes, numElements));
        }
    }

    public static class VolatileDoubleArrayType
    extends AbstractDoubleArrayIo<VolatileDoubleArray> {
        @Override
        public VolatileDoubleArray load(ByteBuffer bytes, int numElements) {
            return new VolatileDoubleArray(this.loadData(bytes, numElements), true);
        }
    }

    public static class DoubleArrayType
    extends AbstractDoubleArrayIo<DoubleArray> {
        @Override
        public DoubleArray load(ByteBuffer bytes, int numElements) {
            return new DoubleArray(this.loadData(bytes, numElements));
        }
    }

    public static abstract class AbstractDoubleArrayIo<A extends AbstractDoubleArray<A>>
    implements AccessIo<A> {
        @Override
        public int getBytesPerElement() {
            return 8;
        }

        protected double[] loadData(ByteBuffer bytes, int numElements) {
            double[] data = new double[numElements];
            DoubleBuffer.wrap(data, 0, numElements).put(bytes.asDoubleBuffer());
            return data;
        }

        @Override
        public void save(A access, ByteBuffer out, int numElements) {
            double[] data = ((AbstractDoubleArray)access).getCurrentStorageArray();
            out.asDoubleBuffer().put(DoubleBuffer.wrap(data, 0, numElements));
        }
    }
}

