/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.converter;

import java.util.Arrays;
import net.imglib2.converter.Converter;
import net.imglib2.converter.TypeIdentity;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.FloatType;

class RealTypeConverterInternals {
    private static ConverterFactory TYPE_IDENTITY = new ConverterFactory(TypeIdentity.class);
    private static ConverterFactory DOUBLE = new ConverterFactory(DoubleConverter.class);
    private static ConverterFactory FLOAT = new ConverterFactory(FloatConverter.class);
    private static ConverterFactory INTEGER = new ConverterFactory(IntegerConverter.class);
    private static ConverterFactory LONG = new ConverterFactory(LongConverter.class);
    private static ConverterFactory BYTE = new ConverterFactory(ByteConverter.class);
    private static ConverterFactory SHORT = new ConverterFactory(ShortConverter.class);
    private static ConverterFactory BOOLEAN = new ConverterFactory(BooleanConverter.class);

    RealTypeConverterInternals() {
    }

    static <S extends RealType<?>, T extends RealType<?>> Converter<S, T> getConverter(S inputType, T outputType) {
        ConverterFactory factory = RealTypeConverterInternals.getConverterFactory(inputType, outputType);
        return factory.create(inputType, outputType);
    }

    private static ConverterFactory getConverterFactory(RealType<?> inputType, RealType<?> outputType) {
        if (inputType.getClass().equals(outputType.getClass())) {
            return TYPE_IDENTITY;
        }
        if (inputType instanceof IntegerType && outputType instanceof IntegerType) {
            return RealTypeConverterInternals.integerConverterFactory(inputType, outputType);
        }
        return RealTypeConverterInternals.floatingPointConverterFactory(inputType, outputType);
    }

    private static ConverterFactory floatingPointConverterFactory(RealType<?> inputType, RealType<?> outputType) {
        if (inputType instanceof FloatType || outputType instanceof FloatType) {
            return FLOAT;
        }
        return DOUBLE;
    }

    private static ConverterFactory integerConverterFactory(RealType<?> inputType, RealType<?> outputType) {
        if (inputType instanceof LongType || outputType instanceof LongType) {
            return LONG;
        }
        if (inputType instanceof IntType || outputType instanceof IntType) {
            return INTEGER;
        }
        if (inputType instanceof GenericShortType && outputType instanceof GenericShortType) {
            return SHORT;
        }
        if (inputType instanceof GenericByteType && outputType instanceof GenericByteType) {
            return BYTE;
        }
        if (inputType instanceof BooleanType && outputType instanceof BooleanType) {
            return BOOLEAN;
        }
        if (inputType instanceof GenericIntType && RealTypeConverterInternals.smallerThanInt(outputType) || RealTypeConverterInternals.smallerThanInt(inputType) && outputType instanceof GenericIntType) {
            return INTEGER;
        }
        return LONG;
    }

    static boolean smallerThanInt(RealType<?> variable) {
        boolean lowerBound = variable.getMinValue() >= -2.147483648E9;
        boolean upperBound = variable.getMaxValue() <= 2.147483647E9;
        return lowerBound && upperBound;
    }

    public static class BooleanConverter
    implements Converter<BooleanType<?>, BooleanType<?>> {
        @Override
        public void convert(BooleanType<?> input, BooleanType<?> output) {
            output.set(input.get());
        }
    }

    public static class ShortConverter
    implements Converter<GenericShortType<?>, GenericShortType<?>> {
        @Override
        public void convert(GenericShortType<?> input, GenericShortType<?> output) {
            output.setShort(input.getShort());
        }
    }

    public static class ByteConverter
    implements Converter<GenericByteType<?>, GenericByteType<?>> {
        @Override
        public void convert(GenericByteType<?> input, GenericByteType<?> output) {
            output.setByte(input.getByte());
        }
    }

    public static class LongConverter
    implements Converter<IntegerType<?>, IntegerType<?>> {
        @Override
        public void convert(IntegerType<?> input, IntegerType<?> output) {
            output.setInteger(input.getIntegerLong());
        }
    }

    public static class IntegerConverter
    implements Converter<IntegerType<?>, IntegerType<?>> {
        @Override
        public void convert(IntegerType<?> input, IntegerType<?> output) {
            output.setInteger(input.getInteger());
        }
    }

    public static class FloatConverter
    implements Converter<RealType<?>, RealType<?>> {
        @Override
        public void convert(RealType<?> input, RealType<?> output) {
            output.setReal(input.getRealFloat());
        }
    }

    public static class DoubleConverter
    implements Converter<RealType<?>, RealType<?>> {
        @Override
        public void convert(RealType<?> input, RealType<?> output) {
            output.setReal(input.getRealDouble());
        }
    }

    private static class ConverterFactory {
        private final ClassCopyProvider<Converter> provider;

        private ConverterFactory(Class<? extends Converter> converterClass) {
            this.provider = new ClassCopyProvider<Converter>(converterClass, Converter.class, new Class[0]);
        }

        public Converter create(RealType<?> in, RealType<?> out) {
            return this.provider.newInstanceForKey(Arrays.asList(in.getClass(), out.getClass()), new Object[0]);
        }
    }
}

