/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display;

import net.imglib2.converter.Converter;
import net.imglib2.display.ColorConverter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.volatiles.VolatileARGBType;

public abstract class ScaledARGBConverter<T>
implements ColorConverter,
Converter<T, ARGBType> {
    protected double min = 0.0;
    protected double max = 1.0;
    protected double scale;

    private ScaledARGBConverter(double min, double max) {
        this.min = min;
        this.max = max;
        this.update();
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public void setMax(double max) {
        this.max = max;
        this.update();
    }

    @Override
    public void setMin(double min) {
        this.min = min;
        this.update();
    }

    @Override
    public ARGBType getColor() {
        return new ARGBType();
    }

    @Override
    public void setColor(ARGBType c) {
    }

    @Override
    public boolean supportsColor() {
        return false;
    }

    private void update() {
        this.scale = 255.0 / (this.max - this.min);
    }

    int getScaledColor(int color) {
        int a = ARGBType.alpha(color);
        int r = Math.min(255, (int)(this.scale * Math.max(0.0, (double)ARGBType.red(color) - this.min) + 0.5));
        int g = Math.min(255, (int)(this.scale * Math.max(0.0, (double)ARGBType.green(color) - this.min) + 0.5));
        int b = Math.min(255, (int)(this.scale * Math.max(0.0, (double)ARGBType.blue(color) - this.min) + 0.5));
        return ARGBType.rgba(r, g, b, a);
    }

    public static class VolatileARGB
    extends ScaledARGBConverter<VolatileARGBType> {
        public VolatileARGB(double min, double max) {
            super(min, max);
        }

        @Override
        public void convert(VolatileARGBType input, ARGBType output) {
            output.set(this.getScaledColor(((ARGBType)input.get()).get()));
        }
    }

    public static class ARGB
    extends ScaledARGBConverter<ARGBType> {
        public ARGB(double min, double max) {
            super(min, max);
        }

        @Override
        public void convert(ARGBType input, ARGBType output) {
            output.set(this.getScaledColor(input.get()));
        }
    }
}

