/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector.specialized;

import net.imglib2.display.projector.AbstractProjector2D;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.util.IntervalIndexer;

public class ArrayImgXYByteProjector<A extends GenericByteType<A>>
extends AbstractProjector2D {
    private final byte[] sourceArray;
    private final byte[] targetArray;
    private final double min;
    private final double normalizationFactor;
    private final boolean isSigned;
    private final long[] dims;

    public ArrayImgXYByteProjector(ArrayImg<A, ByteArray> source, ArrayImg<UnsignedByteType, ByteArray> target, double normalizationFactor, double min) {
        super(source.numDimensions());
        this.isSigned = ((GenericByteType)source.firstElement()).getMinValue() < 0.0;
        this.targetArray = ((ByteArray)target.update(null)).getCurrentStorageArray();
        this.normalizationFactor = normalizationFactor;
        this.min = min;
        this.dims = new long[this.n];
        source.dimensions(this.dims);
        this.sourceArray = ((ByteArray)source.update(null)).getCurrentStorageArray();
    }

    @Override
    public void map() {
        int i;
        double minCopy = this.min;
        int offset = 0;
        long[] tmpPos = (long[])this.position.clone();
        tmpPos[0] = 0L;
        tmpPos[1] = 0L;
        offset = (int)IntervalIndexer.positionToIndex(tmpPos, this.dims);
        System.arraycopy(this.sourceArray, offset, this.targetArray, 0, this.targetArray.length);
        if (this.isSigned) {
            for (i = 0; i < this.targetArray.length; ++i) {
                this.targetArray[i] = (byte)(this.targetArray[i] - 128);
            }
            minCopy += 128.0;
        }
        if (this.normalizationFactor != 1.0) {
            for (i = 0; i < this.targetArray.length; ++i) {
                this.targetArray[i] = (byte)Math.min(255L, Math.max(0L, Math.round(((double)(this.targetArray[i] & 0xFF) - minCopy) * this.normalizationFactor)));
            }
        }
    }
}

