/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.projector.specialized;

import net.imglib2.display.projector.AbstractProjector2D;
import net.imglib2.display.projector.specialized.PlanarImgContainerSamplerImpl;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.util.IntervalIndexer;

public class PlanarImgXYByteProjector<A extends GenericByteType<A>>
extends AbstractProjector2D {
    private final PlanarImg<A, ByteArray> source;
    private final byte[] targetArray;
    private final double min;
    private final double normalizationFactor;
    private final boolean isSigned;
    private final long[] dims;

    public PlanarImgXYByteProjector(PlanarImg<A, ByteArray> source, ArrayImg<UnsignedByteType, ByteArray> target, double normalizationFactor, double min) {
        super(source.numDimensions());
        this.isSigned = ((GenericByteType)source.firstElement()).getMinValue() < 0.0;
        this.targetArray = ((ByteArray)target.update(null)).getCurrentStorageArray();
        this.normalizationFactor = normalizationFactor;
        this.min = min;
        this.dims = new long[this.n];
        source.dimensions(this.dims);
        this.source = source;
    }

    @Override
    public void map() {
        int planeIndex;
        double minCopy = this.min;
        boolean offset = false;
        if (this.position.length > 2) {
            long[] tmpPos = new long[this.position.length - 2];
            long[] tmpDim = new long[this.position.length - 2];
            for (int i = 0; i < tmpDim.length; ++i) {
                tmpPos[i] = this.position[i + 2];
                tmpDim[i] = this.source.dimension(i + 2);
            }
            planeIndex = (int)IntervalIndexer.positionToIndex(tmpPos, tmpDim);
        } else {
            planeIndex = 0;
        }
        byte[] sourceArray = ((ByteArray)this.source.update(new PlanarImgContainerSamplerImpl(planeIndex))).getCurrentStorageArray();
        System.arraycopy(sourceArray, 0, this.targetArray, 0, this.targetArray.length);
        if (this.isSigned) {
            for (int i = 0; i < this.targetArray.length; ++i) {
                this.targetArray[i] = (byte)(this.targetArray[i] - 128);
            }
            minCopy += 128.0;
        }
        if (this.normalizationFactor != 1.0) {
            for (int i = 0; i < this.targetArray.length; ++i) {
                this.targetArray[i] = (byte)Math.min(255L, Math.max(0L, Math.round(((double)(this.targetArray[i] & 0xFF) - minCopy) * this.normalizationFactor)));
            }
        }
    }
}

