/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.nio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.function.Function;
import net.imglib2.img.basictypeaccess.nio.BufferAccess;

public abstract class AbstractBufferAccess<A extends AbstractBufferAccess<A, B>, B extends Buffer>
implements BufferAccess<A> {
    static final boolean DEFAULT_IS_VALID = true;
    private final boolean isValid;
    final B buffer;

    public AbstractBufferAccess(B buffer, boolean isValid) {
        this.buffer = buffer;
        this.isValid = isValid;
    }

    public AbstractBufferAccess(B buffer) {
        this(buffer, true);
    }

    public AbstractBufferAccess(Function<Integer, B> allocate, int numEntities) {
        this((Buffer)allocate.apply(numEntities));
    }

    public A createView(Object o) {
        return this.newInstance(this.duplicateBuffer(this.buffer), this.isValid());
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public A createArray(int numEntities) {
        return this.allocate(numEntities);
    }

    @Override
    public B getCurrentStorageArray() {
        return this.buffer;
    }

    @Override
    public int getArrayLength() {
        if (this.buffer == null) {
            return 0;
        }
        return ((Buffer)this.buffer).limit();
    }

    @Override
    public boolean isDirect() {
        return this.buffer != null && ((Buffer)this.buffer).isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return ((Buffer)this.buffer).isReadOnly();
    }

    ByteBuffer allocateByteBuffer(int numEntities, boolean isDirect) {
        if (isDirect) {
            return ByteBuffer.allocateDirect(numEntities * this.getNumBytesPerEntity());
        }
        return ByteBuffer.allocate(numEntities * this.getNumBytesPerEntity());
    }

    A allocate(int numEntities, boolean isDirect, boolean isValid) {
        return (A)((AbstractBufferAccess)this.newInstance((B)this.allocateByteBuffer(numEntities, isDirect), isValid));
    }

    A allocate(int numEntities) {
        return this.allocate(numEntities, this.isDirect(), this.isValid());
    }

    public abstract A newInstance(B var1, boolean var2);

    abstract B duplicateBuffer(B var1);
}

