/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.interpolation.randomaccess.NLinearInterpolator;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.volatiles.AbstractVolatileNumericType;
import net.imglib2.util.Util;

public class ClampingNLinearInterpolatorVolatileARGB<T extends AbstractVolatileNumericType<ARGBType, T>>
extends NLinearInterpolator<T> {
    protected double accA;
    protected double accR;
    protected double accG;
    protected double accB;
    protected boolean valid;

    protected ClampingNLinearInterpolatorVolatileARGB(ClampingNLinearInterpolatorVolatileARGB<T> interpolator) {
        super(interpolator);
    }

    protected ClampingNLinearInterpolatorVolatileARGB(RandomAccessible<T> randomAccessible, T type) {
        super(randomAccessible, type);
    }

    protected ClampingNLinearInterpolatorVolatileARGB(RandomAccessible<T> randomAccessible) {
        this(randomAccessible, (AbstractVolatileNumericType)randomAccessible.randomAccess().get());
    }

    @Override
    public T get() {
        this.fillWeights();
        AbstractVolatileNumericType t = (AbstractVolatileNumericType)((RandomAccess)this.target).get();
        int argb = ((ARGBType)t.get()).get();
        this.valid = t.isValid();
        this.accA = (double)(argb >> 24 & 0xFF) * this.weights[0];
        this.accR = (double)(argb >> 16 & 0xFF) * this.weights[0];
        this.accG = (double)(argb >> 8 & 0xFF) * this.weights[0];
        this.accB = (double)(argb & 0xFF) * this.weights[0];
        this.code = 0;
        this.graycodeFwdRecursive(this.n - 1);
        ((RandomAccess)this.target).bck(this.n - 1);
        int a = Math.min(255, (int)Util.round(this.accA));
        int r = Math.min(255, (int)Util.round(this.accR));
        int g = Math.min(255, (int)Util.round(this.accG));
        int b = Math.min(255, (int)Util.round(this.accB));
        ((ARGBType)((AbstractVolatileNumericType)this.accumulator).get()).set(((a << 8 | r) << 8 | g) << 8 | b);
        ((AbstractVolatileNumericType)this.accumulator).setValid(this.valid);
        return (T)((AbstractVolatileNumericType)this.accumulator);
    }

    @Override
    public ClampingNLinearInterpolatorVolatileARGB<T> copy() {
        return new ClampingNLinearInterpolatorVolatileARGB<T>(this);
    }

    private final void graycodeFwdRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).fwd(0);
            ++this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).fwd(dimension);
            this.code += 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void graycodeBckRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).bck(0);
            --this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).bck(dimension);
            this.code -= 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void accumulate() {
        AbstractVolatileNumericType t = (AbstractVolatileNumericType)((RandomAccess)this.target).get();
        int argb = ((ARGBType)t.get()).get();
        this.valid &= t.isValid();
        this.accA += (double)(argb >> 24 & 0xFF) * this.weights[this.code];
        this.accR += (double)(argb >> 16 & 0xFF) * this.weights[this.code];
        this.accG += (double)(argb >> 8 & 0xFF) * this.weights[this.code];
        this.accB += (double)(argb & 0xFF) * this.weights[this.code];
    }
}

