/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.loops;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.loops.ClassCopyProvider;
import net.imglib2.loops.ListUtils;

public final class SyncedPositionables {
    private static final List<ClassCopyProvider<Positionable>> forwarderFactories = Arrays.asList(new ClassCopyProvider<Positionable>(Private.GeneralForwarder.class, Positionable.class, new Class[0]), new ClassCopyProvider<Positionable>(Private.Forwarder1.class, Positionable.class, new Class[0]), new ClassCopyProvider<Positionable>(Private.Forwarder2.class, Positionable.class, new Class[0]), new ClassCopyProvider<Positionable>(Private.Forwarder3.class, Positionable.class, new Class[0]), new ClassCopyProvider<Positionable>(Private.Forwarder4.class, Positionable.class, new Class[0]), new ClassCopyProvider<Positionable>(Private.Forwarder5.class, Positionable.class, new Class[0]));

    private SyncedPositionables() {
    }

    public static Positionable create(List<? extends Positionable> positionables) {
        List<Class> key = ListUtils.map(Object::getClass, positionables);
        int i = positionables.size();
        return forwarderFactories.get(i >= forwarderFactories.size() ? 0 : i).newInstanceForKey(key, positionables);
    }

    public static Positionable create(Positionable ... positionables) {
        return SyncedPositionables.create(Arrays.asList(positionables));
    }

    static class Private {
        Private() {
        }

        public static class GeneralForwarder
        implements Forwarder {
            private final Positionable[] values;

            public GeneralForwarder(List<? extends Positionable> values) {
                this.values = values.toArray(new Positionable[values.size()]);
            }

            @Override
            public void fwd(int d) {
                for (Positionable positionable : this.values) {
                    positionable.fwd(d);
                }
            }

            @Override
            public void move(long offset, int d) {
                for (Positionable positionable : this.values) {
                    positionable.move(offset, d);
                }
            }
        }

        public static class Forwarder5
        implements Forwarder {
            private final Positionable a;
            private final Positionable b;
            private final Positionable c;
            private final Positionable d;
            private final Positionable e;

            public Forwarder5(List<? extends Positionable> values) {
                this.a = values.get(0);
                this.b = values.get(1);
                this.c = values.get(2);
                this.d = values.get(3);
                this.e = values.get(4);
            }

            @Override
            public void fwd(int d) {
                this.a.fwd(d);
                this.b.fwd(d);
                this.c.fwd(d);
                this.d.fwd(d);
                this.e.fwd(d);
            }

            @Override
            public void move(long offset, int d) {
                this.a.move(offset, d);
                this.b.move(offset, d);
                this.c.move(offset, d);
                this.d.move(offset, d);
                this.e.move(offset, d);
            }
        }

        public static class Forwarder4
        implements Forwarder {
            private final Positionable a;
            private final Positionable b;
            private final Positionable c;
            private final Positionable d;

            public Forwarder4(List<? extends Positionable> values) {
                this.a = values.get(0);
                this.b = values.get(1);
                this.c = values.get(2);
                this.d = values.get(3);
            }

            @Override
            public void fwd(int d) {
                this.a.fwd(d);
                this.b.fwd(d);
                this.c.fwd(d);
                this.d.fwd(d);
            }

            @Override
            public void move(long offset, int d) {
                this.a.move(offset, d);
                this.b.move(offset, d);
                this.c.move(offset, d);
                this.d.move(offset, d);
            }
        }

        public static class Forwarder3
        implements Forwarder {
            private final Positionable a;
            private final Positionable b;
            private final Positionable c;

            public Forwarder3(List<? extends Positionable> values) {
                this.a = values.get(0);
                this.b = values.get(1);
                this.c = values.get(2);
            }

            @Override
            public void fwd(int d) {
                this.a.fwd(d);
                this.b.fwd(d);
                this.c.fwd(d);
            }

            @Override
            public void move(long offset, int d) {
                this.a.move(offset, d);
                this.b.move(offset, d);
                this.c.move(offset, d);
            }
        }

        public static class Forwarder2
        implements Forwarder {
            private final Positionable a;
            private final Positionable b;

            public Forwarder2(List<? extends Positionable> values) {
                this.a = values.get(0);
                this.b = values.get(1);
            }

            @Override
            public void fwd(int d) {
                this.a.fwd(d);
                this.b.fwd(d);
            }

            @Override
            public void move(long offset, int d) {
                this.a.move(offset, d);
                this.b.move(offset, d);
            }
        }

        public static class Forwarder1
        implements Forwarder {
            private final Positionable a;

            public Forwarder1(List<? extends Positionable> values) {
                this.a = values.get(0);
            }

            @Override
            public void fwd(int d) {
                this.a.fwd(d);
            }

            @Override
            public void move(long offset, int d) {
                this.a.move(offset, d);
            }
        }

        public static interface Forwarder
        extends Positionable {
            @Override
            default public void bck(int d) {
                this.move(-1, d);
            }

            @Override
            default public void move(int distance, int d) {
                this.move((long)distance, d);
            }

            @Override
            default public void move(Localizable localizable) {
                for (int i = 0; i < localizable.numDimensions(); ++i) {
                    this.move(localizable.getLongPosition(i), i);
                }
            }

            @Override
            default public void move(int[] distance) {
                for (int i = 0; i < distance.length; ++i) {
                    this.move((long)distance[i], i);
                }
            }

            @Override
            default public void move(long[] distance) {
                for (int i = 0; i < distance.length; ++i) {
                    this.move(distance[i], i);
                }
            }

            @Override
            default public void setPosition(Localizable localizable) {
                throw new UnsupportedOperationException();
            }

            @Override
            default public void setPosition(int[] position) {
                throw new UnsupportedOperationException();
            }

            @Override
            default public void setPosition(long[] position) {
                throw new UnsupportedOperationException();
            }

            @Override
            default public void setPosition(int position, int d) {
                throw new UnsupportedOperationException();
            }

            @Override
            default public void setPosition(long position, int d) {
                throw new UnsupportedOperationException();
            }

            @Override
            default public int numDimensions() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

