/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.ArrayList;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.RealTransform;

public class AbstractRealTransformSequence<R extends RealTransform>
implements RealTransform {
    protected final ArrayList<R> transforms = new ArrayList();
    protected double[] tmp = new double[0];
    protected RealPoint ptmp = RealPoint.wrap(this.tmp);
    protected int nSource = 0;
    protected int nTarget = 0;

    public void add(R transform) {
        this.transforms.add(transform);
        if (this.transforms.size() == 1) {
            this.nSource = transform.numSourceDimensions();
            this.tmp = new double[this.nSource];
            this.ptmp = RealPoint.wrap(this.tmp);
        }
        this.nTarget = transform.numTargetDimensions();
        if (this.tmp.length < this.nTarget) {
            this.tmp = new double[this.nTarget];
            this.ptmp = RealPoint.wrap(this.tmp);
        }
    }

    @Override
    public int numSourceDimensions() {
        return this.nSource;
    }

    @Override
    public int numTargetDimensions() {
        return this.nTarget;
    }

    @Override
    public boolean isIdentity() {
        if (this.transforms.size() == 0) {
            return true;
        }
        for (RealTransform t : this.transforms) {
            if (t.isIdentity()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void apply(double[] source, double[] target) {
        assert (source.length >= this.nSource && target.length >= this.nTarget) : "Input dimensions too small.";
        int s = this.transforms.size() - 1;
        if (s > -1) {
            if (s > 0) {
                ((RealTransform)this.transforms.get(0)).apply(source, this.tmp);
                for (int i = 1; i < s; ++i) {
                    ((RealTransform)this.transforms.get(i)).apply(this.tmp, this.tmp);
                }
                ((RealTransform)this.transforms.get(s)).apply(this.tmp, target);
            } else {
                ((RealTransform)this.transforms.get(0)).apply(source, target);
            }
        } else {
            System.arraycopy(source, 0, target, 0, target.length);
        }
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= this.nSource && target.length >= this.nTarget) : "Input dimensions too small.";
        int s = this.transforms.size() - 1;
        if (s > -1) {
            for (int d = 0; d < this.nSource; ++d) {
                this.tmp[d] = source[d];
            }
            for (RealTransform t : this.transforms) {
                t.apply(this.tmp, this.tmp);
            }
            for (int d = 0; d < this.nTarget; ++d) {
                target[d] = (float)this.tmp[d];
            }
        } else {
            System.arraycopy(source, 0, target, 0, target.length);
        }
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= this.nSource && target.numDimensions() >= this.nTarget) : "Input dimensions too small.";
        int s = this.transforms.size() - 1;
        if (s > -1) {
            if (s > 0) {
                ((RealTransform)this.transforms.get(0)).apply(source, this.ptmp);
                for (int i = 1; i < s; ++i) {
                    ((RealTransform)this.transforms.get(i)).apply(this.tmp, this.tmp);
                }
                ((RealTransform)this.transforms.get(s)).apply(this.ptmp, target);
            } else {
                ((RealTransform)this.transforms.get(0)).apply(source, target);
            }
        } else {
            target.setPosition(source);
        }
    }

    @Override
    public AbstractRealTransformSequence<R> copy() {
        AbstractRealTransformSequence<RealTransform> copy = new AbstractRealTransformSequence<RealTransform>();
        for (RealTransform t : this.transforms) {
            copy.add(t.copy());
        }
        return copy;
    }
}

