/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.EuclideanSpace;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.Perspective3D;

public class InversePerspective3D
implements InvertibleRealTransform,
EuclideanSpace {
    protected static final InversePerspective3D instance = new InversePerspective3D();

    private InversePerspective3D() {
    }

    public static InversePerspective3D getInstance() {
        return instance;
    }

    @Override
    public int numDimensions() {
        return 3;
    }

    @Override
    public int numSourceDimensions() {
        return 3;
    }

    @Override
    public int numTargetDimensions() {
        return 3;
    }

    @Override
    public void apply(double[] source, double[] target) {
        assert (source.length >= 3 && target.length >= 3) : "Input dimensions too small.";
        target[0] = source[0] * source[2];
        target[1] = source[1] * source[2];
        target[2] = source[2];
    }

    @Override
    public void apply(float[] source, float[] target) {
        assert (source.length >= 3 && target.length >= 3) : "Input dimensions too small.";
        target[0] = source[0] * source[2];
        target[1] = source[1] * source[2];
        target[2] = source[2];
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        assert (source.numDimensions() >= 3 && target.numDimensions() >= 3) : "Input dimensions too small.";
        double z = source.getDoublePosition(2);
        target.setPosition(source.getDoublePosition(0) * z, 0);
        target.setPosition(source.getDoublePosition(1) * z, 1);
        target.setPosition(source.getDoublePosition(2), 2);
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        assert (source.length >= 3 && target.length >= 3) : "Input dimensions too small.";
        source[0] = target[0] / target[2];
        source[1] = target[1] / target[2];
        source[2] = target[2];
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        assert (source.length >= 3 && target.length >= 3) : "Input dimensions too small.";
        source[0] = target[0] / target[2];
        source[1] = target[1] / target[2];
        source[2] = target[2];
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        assert (source.numDimensions() >= 3 && target.numDimensions() >= 3) : "Input dimensions too small.";
        double z = target.getDoublePosition(2);
        source.setPosition(target.getDoublePosition(0) / z, 0);
        source.setPosition(target.getDoublePosition(1) / z, 1);
        source.setPosition(target.getDoublePosition(2), 2);
    }

    @Override
    public InvertibleRealTransform inverse() {
        return Perspective3D.getInstance();
    }

    @Override
    public InversePerspective3D copy() {
        return this;
    }
}

