/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.Localizable;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;

public class StackingRealRandomAccessible<T>
implements RealRandomAccessible<T> {
    protected final int numDimensions;
    protected final int sourceNumDimensions;
    protected final RealRandomAccessible<T> source;

    public StackingRealRandomAccessible(RealRandomAccessible<T> source, int numDimensions) {
        this.source = source;
        this.sourceNumDimensions = source.numDimensions();
        this.numDimensions = this.sourceNumDimensions + numDimensions;
    }

    public StackingRealRandomAccess realRandomAccess() {
        return new StackingRealRandomAccess();
    }

    public StackingRealRandomAccess realRandomAccess(RealInterval interval) {
        return this.realRandomAccess();
    }

    @Override
    public int numDimensions() {
        return this.numDimensions;
    }

    @Override
    public T getType() {
        return this.source.getType();
    }

    public class StackingRealRandomAccess
    implements RealRandomAccess<T> {
        protected final RealRandomAccess<T> sourceAccess;
        final double[] position;
        final float[] fMove;
        final double[] dMove;
        final int[] iMove;
        final long[] lMove;

        public StackingRealRandomAccess() {
            this.sourceAccess = StackingRealRandomAccessible.this.source.realRandomAccess();
            this.fMove = new float[this.sourceAccess.numDimensions()];
            this.dMove = new double[this.fMove.length];
            this.iMove = new int[this.fMove.length];
            this.lMove = new long[this.fMove.length];
            this.position = new double[StackingRealRandomAccessible.this.numDimensions];
        }

        @Override
        public void move(float distance, int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.move(distance, d);
            } else {
                int n = d;
                this.position[n] = this.position[n] + (double)distance;
            }
        }

        @Override
        public void move(double distance, int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.move(distance, d);
            } else {
                int n = d;
                this.position[n] = this.position[n] + distance;
            }
        }

        @Override
        public void move(RealLocalizable localizable) {
            int d;
            for (d = 0; d < StackingRealRandomAccessible.this.sourceNumDimensions; ++d) {
                this.dMove[d] = localizable.getDoublePosition(d);
            }
            this.sourceAccess.move(this.dMove);
            for (d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                int n = d;
                this.position[n] = this.position[n] + localizable.getDoublePosition(d);
            }
        }

        @Override
        public void move(float[] distance) {
            System.arraycopy(distance, 0, this.fMove, 0, StackingRealRandomAccessible.this.sourceNumDimensions);
            this.sourceAccess.move(this.fMove);
            for (int d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
        }

        @Override
        public void move(double[] distance) {
            System.arraycopy(distance, 0, this.dMove, 0, StackingRealRandomAccessible.this.sourceNumDimensions);
            this.sourceAccess.move(this.dMove);
            for (int d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                int n = d;
                this.position[n] = this.position[n] + distance[d];
            }
        }

        @Override
        public void setPosition(RealLocalizable localizable) {
            int d;
            for (d = 0; d < StackingRealRandomAccessible.this.sourceNumDimensions; ++d) {
                this.dMove[d] = localizable.getDoublePosition(d);
            }
            this.sourceAccess.setPosition(this.dMove);
            for (d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                this.position[d] = localizable.getDoublePosition(d);
            }
        }

        @Override
        public void setPosition(float[] pos) {
            System.arraycopy(pos, 0, this.fMove, 0, StackingRealRandomAccessible.this.sourceNumDimensions);
            this.sourceAccess.setPosition(this.fMove);
            for (int d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                this.position[d] = pos[d];
            }
        }

        @Override
        public void setPosition(double[] pos) {
            System.arraycopy(pos, 0, this.dMove, 0, StackingRealRandomAccessible.this.sourceNumDimensions);
            this.sourceAccess.setPosition(this.dMove);
            for (int d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                this.position[d] = pos[d];
            }
        }

        @Override
        public void setPosition(float pos, int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.setPosition(pos, d);
            } else {
                this.position[d] = pos;
            }
        }

        @Override
        public void setPosition(double pos, int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.setPosition(pos, d);
            } else {
                this.position[d] = pos;
            }
        }

        @Override
        public void fwd(int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.fwd(d);
            } else {
                int n = d;
                this.position[n] = this.position[n] + 1.0;
            }
        }

        @Override
        public void bck(int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.bck(d);
            } else {
                int n = d;
                this.position[n] = this.position[n] - 1.0;
            }
        }

        @Override
        public void move(int distance, int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.move(distance, d);
            } else {
                int n = d;
                this.position[n] = this.position[n] + (double)distance;
            }
        }

        @Override
        public void move(long distance, int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.move(distance, d);
            } else {
                int n = d;
                this.position[n] = this.position[n] + (double)distance;
            }
        }

        @Override
        public void move(Localizable localizable) {
            int d;
            for (d = 0; d < StackingRealRandomAccessible.this.sourceNumDimensions; ++d) {
                this.lMove[d] = localizable.getLongPosition(d);
            }
            this.sourceAccess.move(this.lMove);
            for (d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)localizable.getLongPosition(d);
            }
        }

        @Override
        public void move(int[] distance) {
            System.arraycopy(distance, 0, this.iMove, 0, StackingRealRandomAccessible.this.sourceNumDimensions);
            this.sourceAccess.move(this.iMove);
            for (int d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
        }

        @Override
        public void move(long[] distance) {
            System.arraycopy(distance, 0, this.lMove, 0, StackingRealRandomAccessible.this.sourceNumDimensions);
            this.sourceAccess.move(this.lMove);
            for (int d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                int n = d;
                this.position[n] = this.position[n] + (double)distance[d];
            }
        }

        @Override
        public void setPosition(Localizable localizable) {
            int d;
            for (d = 0; d < StackingRealRandomAccessible.this.sourceNumDimensions; ++d) {
                this.lMove[d] = localizable.getLongPosition(d);
            }
            this.sourceAccess.setPosition(this.lMove);
            for (d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                this.position[d] = localizable.getLongPosition(d);
            }
        }

        @Override
        public void setPosition(int[] pos) {
            System.arraycopy(pos, 0, this.iMove, 0, StackingRealRandomAccessible.this.sourceNumDimensions);
            this.sourceAccess.setPosition(this.iMove);
            for (int d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                this.position[d] = pos[d];
            }
        }

        @Override
        public void setPosition(long[] pos) {
            System.arraycopy(pos, 0, this.lMove, 0, StackingRealRandomAccessible.this.sourceNumDimensions);
            this.sourceAccess.setPosition(this.lMove);
            for (int d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                this.position[d] = pos[d];
            }
        }

        @Override
        public void setPosition(int pos, int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.setPosition(pos, d);
            } else {
                this.position[d] = pos;
            }
        }

        @Override
        public void setPosition(long pos, int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                this.sourceAccess.setPosition(pos, d);
            } else {
                this.position[d] = pos;
            }
        }

        @Override
        public T get() {
            return this.sourceAccess.get();
        }

        @Override
        public T getType() {
            return this.sourceAccess.getType();
        }

        @Override
        public StackingRealRandomAccess copy() {
            return new StackingRealRandomAccess();
        }

        @Override
        public void localize(float[] pos) {
            int d;
            for (d = 0; d < StackingRealRandomAccessible.this.sourceNumDimensions; ++d) {
                pos[d] = this.sourceAccess.getFloatPosition(d);
            }
            for (d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                pos[d] = (float)this.position[d];
            }
        }

        @Override
        public void localize(double[] pos) {
            int d;
            for (d = 0; d < StackingRealRandomAccessible.this.sourceNumDimensions; ++d) {
                pos[d] = this.sourceAccess.getDoublePosition(d);
            }
            for (d = StackingRealRandomAccessible.this.sourceNumDimensions; d < StackingRealRandomAccessible.this.numDimensions; ++d) {
                pos[d] = this.position[d];
            }
        }

        @Override
        public float getFloatPosition(int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                return this.sourceAccess.getFloatPosition(d);
            }
            return (float)this.position[d];
        }

        @Override
        public double getDoublePosition(int d) {
            if (d < StackingRealRandomAccessible.this.sourceNumDimensions) {
                return this.sourceAccess.getDoublePosition(d);
            }
            return (float)this.position[d];
        }

        @Override
        public int numDimensions() {
            return StackingRealRandomAccessible.this.numDimensions;
        }
    }
}

