/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.inverse;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.inverse.DifferentiableRealTransform;
import net.imglib2.realtransform.inverse.InverseRealTransformGradientDescent;
import net.imglib2.realtransform.inverse.RealTransformFiniteDerivatives;

public class WrappedIterativeInvertibleRealTransform<T extends RealTransform>
implements InvertibleRealTransform {
    protected final T forwardTransform;
    protected final DifferentiableRealTransform differentiableTransform;
    protected final InverseRealTransformGradientDescent inverseTransform;

    public WrappedIterativeInvertibleRealTransform(T xfm) {
        this.forwardTransform = xfm;
        this.differentiableTransform = xfm instanceof DifferentiableRealTransform ? (DifferentiableRealTransform)xfm : new RealTransformFiniteDerivatives((RealTransform)xfm);
        this.inverseTransform = new InverseRealTransformGradientDescent(xfm.numSourceDimensions(), this.differentiableTransform);
    }

    private WrappedIterativeInvertibleRealTransform(T xfm, InverseRealTransformGradientDescent inverse) {
        this.forwardTransform = xfm;
        this.differentiableTransform = xfm instanceof DifferentiableRealTransform ? (DifferentiableRealTransform)xfm : new RealTransformFiniteDerivatives((RealTransform)xfm);
        this.inverseTransform = inverse;
    }

    public T getTransform() {
        return this.forwardTransform;
    }

    @Override
    public int numSourceDimensions() {
        return this.forwardTransform.numSourceDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.forwardTransform.numTargetDimensions();
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.forwardTransform.apply(source, target);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        this.forwardTransform.apply(source, target);
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        this.inverseTransform.apply(target, source);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        this.inverseTransform.apply(target, source);
    }

    @Override
    public InvertibleRealTransform inverse() {
        return new InverseRealTransform(this);
    }

    public InverseRealTransformGradientDescent getOptimzer() {
        return this.inverseTransform;
    }

    @Override
    public WrappedIterativeInvertibleRealTransform<T> copy() {
        return new WrappedIterativeInvertibleRealTransform<RealTransform>(this.forwardTransform.copy(), (InverseRealTransformGradientDescent)this.inverseTransform.copy());
    }
}

