/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import java.util.Arrays;
import java.util.function.Predicate;
import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.AbstractWrappedRealInterval;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RealInterval;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.util.Intervals;

public abstract class Bounds<I extends RealInterval, B extends Bounds<I, B>> {
    public static final BinaryBoundsOperator AND = new BinaryBoundsOperator(){

        @Override
        public <I extends RealInterval, B extends Bounds<I, B>> B apply(B left, B right) {
            return left.and(right);
        }
    };
    public static final BinaryBoundsOperator OR = new BinaryBoundsOperator(){

        @Override
        public <I extends RealInterval, B extends Bounds<I, B>> B apply(B left, B right) {
            return left.or(right);
        }
    };
    public static final UnaryBoundsOperator NEGATE = new UnaryBoundsOperator(){

        @Override
        public <I extends RealInterval, B extends Bounds<I, B>> B apply(B arg) {
            return arg.negate();
        }
    };
    public static final BinaryBoundsOperator XOR = new BinaryBoundsOperator(){

        @Override
        public <I extends RealInterval, B extends Bounds<I, B>> B apply(B left, B right) {
            return left.xor(right);
        }
    };
    public static final BinaryBoundsOperator MINUS = new BinaryBoundsOperator(){

        @Override
        public <I extends RealInterval, B extends Bounds<I, B>> B apply(B left, B right) {
            return left.minus(right);
        }
    };
    private final I interval;

    protected Bounds(I interval) {
        this.interval = interval;
    }

    public boolean isUnbounded() {
        return this.interval == null;
    }

    public I interval() {
        return this.interval;
    }

    protected abstract B intersectBounded(B var1, B var2);

    protected abstract B unionBounded(B var1, B var2);

    protected abstract B unbounded();

    public B and(B that) {
        if (this.isUnbounded()) {
            return that;
        }
        if (((Bounds)that).isUnbounded()) {
            return (B)this;
        }
        return (B)this.intersectBounded(this, that);
    }

    public B or(B that) {
        if (this.isUnbounded() || ((Bounds)that).isUnbounded()) {
            return this.unbounded();
        }
        return (B)this.unionBounded(this, that);
    }

    public B negate() {
        return this.unbounded();
    }

    public B xor(B that) {
        return this.or(that);
    }

    public B minus(B that) {
        return (B)this;
    }

    private static boolean isEmpty(double[] realMin, double[] realMax) {
        for (int d = 0; d < realMin.length; ++d) {
            if (!(realMin[d] > realMax[d])) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmpty(long[] min, long[] max) {
        for (int d = 0; d < min.length; ++d) {
            if (min[d] <= max[d]) continue;
            return true;
        }
        return false;
    }

    private static void getMinMax(RealInterval interval, double[] min, double[] max) {
        if (interval instanceof AbstractWrappedRealInterval) {
            Bounds.getMinMax(((AbstractWrappedRealInterval)interval).getSource(), min, max);
        } else if (interval instanceof AbstractAdaptingRealInterval) {
            ((AbstractAdaptingRealInterval)interval).realMinMax(min, max);
        } else {
            interval.realMin(min);
            interval.realMax(max);
        }
    }

    private static void getMinMax(Interval interval, long[] min, long[] max) {
        if (interval instanceof AbstractWrappedInterval) {
            Bounds.getMinMax((Interval)((AbstractWrappedInterval)interval).getSource(), min, max);
        } else if (interval instanceof AbstractAdaptingInterval) {
            ((AbstractAdaptingInterval)interval).minMax(min, max);
        } else {
            interval.min(min);
            interval.max(max);
        }
    }

    public static class RealTransformRealInterval
    extends AbstractAdaptingRealInterval {
        private final RealInterval source;
        private final InvertibleRealTransform transformToSource;
        private final double[] cachedSourceMin;
        private final double[] cachedSourceMax;
        private final double[] currentSourceMin;
        private final double[] currentSourceMax;
        private final double[] min;
        private final double[] max;
        private final int numSourceDimensions;

        public RealTransformRealInterval(RealInterval source, InvertibleRealTransform transformToSource) {
            super(transformToSource.numSourceDimensions());
            this.source = source;
            this.transformToSource = transformToSource;
            assert (source.numDimensions() == transformToSource.numTargetDimensions());
            this.numSourceDimensions = source.numDimensions();
            this.cachedSourceMin = new double[this.numSourceDimensions];
            this.cachedSourceMax = new double[this.numSourceDimensions];
            Bounds.getMinMax(source, this.cachedSourceMin, this.cachedSourceMax);
            this.currentSourceMin = new double[this.numSourceDimensions];
            this.currentSourceMax = new double[this.numSourceDimensions];
            this.min = new double[this.n];
            this.max = new double[this.n];
            this.updateMinMax();
        }

        @Override
        public double realMin(int d) {
            this.updateMinMaxIfNeeded();
            return this.min[d];
        }

        @Override
        public double realMax(int d) {
            this.updateMinMaxIfNeeded();
            return this.max[d];
        }

        @Override
        public void realMinMax(double[] realMin, double[] realMax) {
            this.updateMinMaxIfNeeded();
            if (realMin != null) {
                System.arraycopy(this.min, 0, realMin, 0, this.n);
            }
            if (realMax != null) {
                System.arraycopy(this.max, 0, realMax, 0, this.n);
            }
        }

        private void updateMinMaxIfNeeded() {
            Bounds.getMinMax(this.source, this.currentSourceMin, this.currentSourceMax);
            for (int d = 0; d < this.numSourceDimensions; ++d) {
                if (this.cachedSourceMin[d] == this.currentSourceMin[d] && this.cachedSourceMax[d] == this.currentSourceMax[d]) continue;
                System.arraycopy(this.currentSourceMin, 0, this.cachedSourceMax, 0, this.numSourceDimensions);
                System.arraycopy(this.currentSourceMax, 0, this.cachedSourceMin, 0, this.numSourceDimensions);
                this.updateMinMax();
                break;
            }
        }

        private void updateMinMax() {
            if (Intervals.isEmpty(this.source)) {
                Arrays.fill(this.max, Double.NEGATIVE_INFINITY);
                Arrays.fill(this.min, Double.POSITIVE_INFINITY);
                return;
            }
            double[][] transformedCorners = this.createCorners();
            int numTransformedCorners = transformedCorners.length;
            for (int d = 0; d < this.n; ++d) {
                double maxCorner = transformedCorners[0][d];
                double minCorner = transformedCorners[0][d];
                for (int i = 1; i < numTransformedCorners; ++i) {
                    minCorner = Math.min(minCorner, transformedCorners[i][d]);
                    maxCorner = Math.max(maxCorner, transformedCorners[i][d]);
                }
                this.min[d] = minCorner;
                this.max[d] = maxCorner;
            }
        }

        private double[][] createCorners() {
            double[][] cornersTransformed = RealTransformRealInterval.corners(this.cachedSourceMin, this.cachedSourceMax);
            double[][] points = new double[cornersTransformed.length][this.n];
            for (int i = 0; i < points.length; ++i) {
                this.transformToSource.inverse().apply(cornersTransformed[i], points[i]);
            }
            return points;
        }

        private static double[][] corners(double[] min, double[] max) {
            assert (min.length == max.length);
            int n = min.length;
            int numCorners = 1 << n;
            double[][] corners = new double[numCorners][n];
            for (int index = 0; index < numCorners; ++index) {
                int d = 0;
                int mask = numCorners >> 1;
                while (d < n) {
                    corners[index][d] = (index & mask) == 0 ? min[d] : max[d];
                    ++d;
                    mask >>= 1;
                }
            }
            return corners;
        }
    }

    public static class RealBounds
    extends Bounds<RealInterval, RealBounds> {
        public static final RealBounds UNBOUNDED = new RealBounds(null);

        public static RealBounds of(Predicate<?> predicate) {
            if (predicate instanceof RealInterval) {
                return RealBounds.of((RealInterval)((Object)predicate));
            }
            return UNBOUNDED;
        }

        public static RealBounds of(RealInterval i) {
            if (i == null) {
                return UNBOUNDED;
            }
            return new RealBounds(i);
        }

        protected RealBounds(RealInterval interval) {
            super(interval);
        }

        @Override
        protected RealBounds intersectBounded(RealBounds arg0, RealBounds arg1) {
            return new RealBounds(new IntersectionRealInterval((RealInterval)arg0.interval(), (RealInterval)arg1.interval()));
        }

        @Override
        protected RealBounds unionBounded(RealBounds arg0, RealBounds arg1) {
            return new RealBounds(new UnionRealInterval((RealInterval)arg0.interval(), (RealInterval)arg1.interval()));
        }

        @Override
        protected RealBounds unbounded() {
            return UNBOUNDED;
        }
    }

    public static class UnionRealInterval
    extends AbstractAdaptingRealInterval {
        private final RealInterval i1;
        private final RealInterval i2;

        public UnionRealInterval(RealInterval i1, RealInterval i2) {
            super(i1.numDimensions());
            this.i1 = i1;
            this.i2 = i2;
            assert (i1.numDimensions() == i2.numDimensions());
        }

        @Override
        public void realMinMax(double[] realMin, double[] realMax) {
            double[] min1 = new double[this.n];
            double[] max1 = new double[this.n];
            Bounds.getMinMax(this.i1, min1, max1);
            double[] min2 = new double[this.n];
            double[] max2 = new double[this.n];
            Bounds.getMinMax(this.i2, min2, max2);
            if (Bounds.isEmpty(min1, max1)) {
                if (realMin != null) {
                    System.arraycopy(min2, 0, realMin, 0, this.n);
                }
                if (realMax != null) {
                    System.arraycopy(max2, 0, realMax, 0, this.n);
                }
            } else if (Bounds.isEmpty(min2, max2)) {
                if (realMin != null) {
                    System.arraycopy(min1, 0, realMin, 0, this.n);
                }
                if (realMax != null) {
                    System.arraycopy(max1, 0, realMax, 0, this.n);
                }
            } else {
                int d;
                if (realMin != null) {
                    for (d = 0; d < this.n; ++d) {
                        realMin[d] = Math.min(min1[d], min2[d]);
                    }
                }
                if (realMax != null) {
                    for (d = 0; d < this.n; ++d) {
                        realMax[d] = Math.max(max1[d], max2[d]);
                    }
                }
            }
        }
    }

    public static class IntersectionRealInterval
    extends AbstractAdaptingRealInterval {
        private final RealInterval i1;
        private final RealInterval i2;

        public IntersectionRealInterval(RealInterval i1, RealInterval i2) {
            super(i1.numDimensions());
            this.i1 = i1;
            this.i2 = i2;
            assert (i1.numDimensions() == i2.numDimensions());
        }

        @Override
        public void realMinMax(double[] realMin, double[] realMax) {
            int d;
            double[] min1 = new double[this.n];
            double[] max1 = new double[this.n];
            Bounds.getMinMax(this.i1, min1, max1);
            double[] min2 = new double[this.n];
            double[] max2 = new double[this.n];
            Bounds.getMinMax(this.i2, min2, max2);
            if (realMin != null) {
                for (d = 0; d < this.n; ++d) {
                    realMin[d] = Math.max(min1[d], min2[d]);
                }
            }
            if (realMax != null) {
                for (d = 0; d < this.n; ++d) {
                    realMax[d] = Math.min(max1[d], max2[d]);
                }
            }
        }
    }

    public static abstract class AbstractAdaptingRealInterval
    extends AbstractEuclideanSpace
    implements RealInterval {
        public AbstractAdaptingRealInterval(int n) {
            super(n);
        }

        @Override
        public double realMin(int d) {
            double[] min = new double[this.n];
            this.realMin(min);
            return min[d];
        }

        @Override
        public double realMax(int d) {
            double[] max = new double[this.n];
            this.realMax(max);
            return max[d];
        }

        @Override
        public void realMin(double[] realMin) {
            this.realMinMax(realMin, null);
        }

        @Override
        public void realMax(double[] realMax) {
            this.realMinMax(null, realMax);
        }

        @Override
        public void realMin(RealPositionable realMin) {
            double[] pos = new double[this.n];
            this.realMin(pos);
            for (int d = 0; d < this.n; ++d) {
                realMin.setPosition(pos[d], d);
            }
        }

        @Override
        public void realMax(RealPositionable realMax) {
            double[] pos = new double[this.n];
            this.realMax(pos);
            for (int d = 0; d < this.n; ++d) {
                realMax.setPosition(pos[d], d);
            }
        }

        public abstract void realMinMax(double[] var1, double[] var2);
    }

    public static class IntBounds
    extends Bounds<Interval, IntBounds> {
        public static final IntBounds UNBOUNDED = new IntBounds(null);

        public static IntBounds of(Predicate<?> predicate) {
            if (predicate instanceof Interval) {
                return IntBounds.of((Interval)((Object)predicate));
            }
            if (predicate instanceof RealInterval) {
                return IntBounds.of(new SmallestContainingInterval((RealInterval)((Object)predicate)));
            }
            return UNBOUNDED;
        }

        public static IntBounds of(Interval i) {
            if (i == null) {
                return UNBOUNDED;
            }
            return new IntBounds(i);
        }

        protected IntBounds(Interval interval) {
            super(interval);
        }

        @Override
        protected IntBounds intersectBounded(IntBounds arg0, IntBounds arg1) {
            return new IntBounds(new IntersectionInterval((Interval)arg0.interval(), (Interval)arg1.interval()));
        }

        @Override
        protected IntBounds unionBounded(IntBounds arg0, IntBounds arg1) {
            return new IntBounds(new UnionInterval((Interval)arg0.interval(), (Interval)arg1.interval()));
        }

        @Override
        protected IntBounds unbounded() {
            return UNBOUNDED;
        }
    }

    public static class UnionInterval
    extends AbstractAdaptingInterval {
        private final Interval i1;
        private final Interval i2;

        public UnionInterval(Interval i1, Interval i2) {
            super(i1.numDimensions());
            this.i1 = i1;
            this.i2 = i2;
            assert (i1.numDimensions() == i2.numDimensions());
        }

        @Override
        public void minMax(long[] min, long[] max) {
            long[] min1 = new long[this.n];
            long[] max1 = new long[this.n];
            Bounds.getMinMax(this.i1, min1, max1);
            long[] min2 = new long[this.n];
            long[] max2 = new long[this.n];
            Bounds.getMinMax(this.i2, min2, max2);
            if (Bounds.isEmpty(min1, max1)) {
                if (min != null) {
                    System.arraycopy(min2, 0, min, 0, this.n);
                }
                if (max != null) {
                    System.arraycopy(max2, 0, max, 0, this.n);
                }
            } else if (Bounds.isEmpty(min2, max2)) {
                if (min != null) {
                    System.arraycopy(min1, 0, min, 0, this.n);
                }
                if (max != null) {
                    System.arraycopy(max1, 0, max, 0, this.n);
                }
            } else {
                int d;
                if (min != null) {
                    for (d = 0; d < this.n; ++d) {
                        min[d] = Math.min(min1[d], min2[d]);
                    }
                }
                if (max != null) {
                    for (d = 0; d < this.n; ++d) {
                        max[d] = Math.max(max1[d], max2[d]);
                    }
                }
            }
        }
    }

    public static class IntersectionInterval
    extends AbstractAdaptingInterval {
        private final Interval i1;
        private final Interval i2;

        public IntersectionInterval(Interval i1, Interval i2) {
            super(i1.numDimensions());
            this.i1 = i1;
            this.i2 = i2;
            assert (i1.numDimensions() == i2.numDimensions());
        }

        @Override
        public void minMax(long[] min, long[] max) {
            int d;
            long[] min1 = new long[this.n];
            long[] max1 = new long[this.n];
            Bounds.getMinMax(this.i1, min1, max1);
            long[] min2 = new long[this.n];
            long[] max2 = new long[this.n];
            Bounds.getMinMax(this.i2, min2, max2);
            if (min != null) {
                for (d = 0; d < this.n; ++d) {
                    min[d] = Math.max(min1[d], min2[d]);
                }
            }
            if (max != null) {
                for (d = 0; d < this.n; ++d) {
                    max[d] = Math.min(max1[d], max2[d]);
                }
            }
        }
    }

    public static class SmallestContainingInterval
    extends AbstractAdaptingInterval {
        private final RealInterval source;

        public SmallestContainingInterval(RealInterval source) {
            super(source.numDimensions());
            this.source = source;
        }

        @Override
        public void minMax(long[] min, long[] max) {
            int d;
            if (min != null) {
                for (d = 0; d < this.n; ++d) {
                    min[d] = (long)Math.floor(this.source.realMin(d));
                }
            }
            if (max != null) {
                for (d = 0; d < this.n; ++d) {
                    max[d] = (long)Math.ceil(this.source.realMax(d));
                }
            }
        }
    }

    public static abstract class AbstractAdaptingInterval
    extends AbstractAdaptingRealInterval
    implements Interval {
        public AbstractAdaptingInterval(int n) {
            super(n);
        }

        @Override
        public long min(int d) {
            long[] min = new long[this.n];
            this.min(min);
            return min[d];
        }

        @Override
        public long max(int d) {
            long[] max = new long[this.n];
            this.max(max);
            return max[d];
        }

        @Override
        public void min(long[] min) {
            this.minMax(min, null);
        }

        @Override
        public void max(long[] max) {
            this.minMax(null, max);
        }

        @Override
        public void min(Positionable min) {
            long[] minArray = new long[this.n];
            this.min(minArray);
            min.setPosition(minArray);
        }

        @Override
        public void max(Positionable max) {
            long[] maxArray = new long[this.n];
            this.max(maxArray);
            max.setPosition(maxArray);
        }

        public abstract void minMax(long[] var1, long[] var2);

        @Override
        public void realMinMax(double[] realMin, double[] realMax) {
            int d;
            long[] min = realMin == null ? null : new long[this.n];
            long[] max = realMax == null ? null : new long[this.n];
            this.minMax(min, max);
            if (realMin != null) {
                for (d = 0; d < this.n; ++d) {
                    realMin[d] = min[d];
                }
            }
            if (realMax != null) {
                for (d = 0; d < this.n; ++d) {
                    realMax[d] = max[d];
                }
            }
        }

        @Override
        public void dimensions(long[] dimensions) {
            long[] min = new long[this.n];
            long[] max = new long[this.n];
            this.minMax(min, max);
            for (int d = 0; d < this.n; ++d) {
                dimensions[d] = max[d] - min[d] + 1L;
            }
        }

        @Override
        public long dimension(int d) {
            long[] min = new long[this.n];
            long[] max = new long[this.n];
            this.minMax(min, max);
            return max[d] - min[d] + 1L;
        }

        @Override
        public void dimensions(Positionable dimensions) {
            long[] min = new long[this.n];
            long[] max = new long[this.n];
            this.minMax(min, max);
            for (int d = 0; d < this.n; ++d) {
                dimensions.setPosition(max[d] - min[d] + 1L, d);
            }
        }
    }

    public static interface UnaryBoundsOperator {
        public <I extends RealInterval, B extends Bounds<I, B>> B apply(B var1);
    }

    public static interface BinaryBoundsOperator {
        public <I extends RealInterval, B extends Bounds<I, B>> B apply(B var1, B var2);
    }
}

