/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi;

import java.util.Arrays;
import java.util.function.Predicate;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.IterableRegion;
import net.imglib2.roi.KnownConstant;
import net.imglib2.roi.Mask;
import net.imglib2.roi.MaskInterval;
import net.imglib2.roi.MaskPredicate;
import net.imglib2.roi.RealMask;
import net.imglib2.roi.RealMaskRealInterval;
import net.imglib2.roi.Regions;
import net.imglib2.roi.mask.integer.DefaultMask;
import net.imglib2.roi.mask.integer.DefaultMaskInterval;
import net.imglib2.roi.mask.integer.MaskAsRandomAccessible;
import net.imglib2.roi.mask.integer.MaskIntervalAsRandomAccessibleInterval;
import net.imglib2.roi.mask.integer.RandomAccessibleAsMask;
import net.imglib2.roi.mask.integer.RandomAccessibleIntervalAsMaskInterval;
import net.imglib2.roi.mask.real.DefaultRealMask;
import net.imglib2.roi.mask.real.DefaultRealMaskRealInterval;
import net.imglib2.roi.mask.real.RealMaskAsRealRandomAccessible;
import net.imglib2.roi.mask.real.RealMaskRealIntervalAsRealRandomAccessibleRealInterval;
import net.imglib2.roi.mask.real.RealRandomAccessibleAsRealMask;
import net.imglib2.roi.mask.real.RealRandomAccessibleRealIntervalAsRealMaskRealInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.logic.BoolType;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;

public class Masks {
    public static Mask and(Mask left, Predicate<? super Localizable> right) {
        return left.and((Predicate)right);
    }

    public static MaskInterval and(MaskInterval left, Predicate<? super Localizable> right) {
        return left.and((Predicate)right);
    }

    public static Mask or(Mask left, Predicate<? super Localizable> right) {
        return left.or((Predicate)right);
    }

    public static MaskInterval or(MaskInterval left, MaskInterval right) {
        return left.or(right);
    }

    public static Mask xor(Mask left, Predicate<? super Localizable> right) {
        return left.xor((Predicate)right);
    }

    public static MaskInterval xor(MaskInterval left, MaskInterval right) {
        return left.xor(right);
    }

    public static Mask minus(Mask left, Predicate<? super Localizable> right) {
        return left.minus((Predicate)right);
    }

    public static MaskInterval minus(MaskInterval left, Predicate<? super Localizable> right) {
        return left.minus((Predicate)right);
    }

    public static Mask negate(Mask arg) {
        return arg.negate();
    }

    public static RealMask and(RealMask left, Predicate<? super RealLocalizable> right) {
        return left.and((Predicate)right);
    }

    public static RealMaskRealInterval and(RealMaskRealInterval left, Predicate<? super RealLocalizable> right) {
        return left.and((Predicate)right);
    }

    public static RealMask or(RealMask left, Predicate<? super RealLocalizable> right) {
        return left.or((Predicate)right);
    }

    public static RealMaskRealInterval or(RealMaskRealInterval left, RealMaskRealInterval right) {
        return left.or(right);
    }

    public static RealMask xor(RealMask left, Predicate<? super RealLocalizable> right) {
        return left.xor((Predicate)right);
    }

    public static RealMaskRealInterval xor(RealMaskRealInterval left, RealMaskRealInterval right) {
        return left.xor(right);
    }

    public static RealMask minus(RealMask left, Predicate<? super RealLocalizable> right) {
        return left.minus((Predicate)right);
    }

    public static RealMaskRealInterval minus(RealMaskRealInterval left, Predicate<? super RealLocalizable> right) {
        return left.minus((Predicate)right);
    }

    public static RealMask negate(RealMask arg) {
        return arg.negate();
    }

    public static RandomAccessible<BoolType> toRandomAccessible(Mask mask) {
        if (mask instanceof MaskInterval) {
            return Masks.toRandomAccessibleInterval((MaskInterval)mask);
        }
        return new MaskAsRandomAccessible<BoolType>(mask, new BoolType());
    }

    public static RandomAccessibleInterval<BoolType> toRandomAccessibleInterval(MaskInterval mask) {
        return new MaskIntervalAsRandomAccessibleInterval<BoolType>(mask, new BoolType());
    }

    public static RealRandomAccessible<BoolType> toRealRandomAccessible(RealMask mask) {
        if (mask instanceof RealMaskRealInterval) {
            return Masks.toRealRandomAccessibleRealInterval((RealMaskRealInterval)mask);
        }
        return new RealMaskAsRealRandomAccessible<BoolType>(mask, new BoolType());
    }

    public static RealRandomAccessibleRealInterval<BoolType> toRealRandomAccessibleRealInterval(RealMaskRealInterval mask) {
        return new RealMaskRealIntervalAsRealRandomAccessibleRealInterval<BoolType>(mask, new BoolType());
    }

    public static IterableRegion<BoolType> toIterableRegion(RealMaskRealInterval mask) {
        return Regions.iterable(Views.interval(Views.raster(Masks.toRealRandomAccessible(mask)), Intervals.largestContainedInterval(mask)));
    }

    public static IterableRegion<BoolType> toIterableRegion(MaskInterval mask) {
        return Regions.iterable(Masks.toRandomAccessibleInterval(mask));
    }

    public static <B extends BooleanType<B>> Mask toMask(RandomAccessible<B> ra) {
        if (ra instanceof RandomAccessibleInterval) {
            return Masks.toMaskInterval((RandomAccessibleInterval)ra);
        }
        return new RandomAccessibleAsMask<B>(ra);
    }

    public static <B extends BooleanType<B>> MaskInterval toMaskInterval(RandomAccessibleInterval<B> rai) {
        return new RandomAccessibleIntervalAsMaskInterval<B>(rai);
    }

    public static <B extends BooleanType<B>> RealMask toRealMask(RealRandomAccessible<B> rra) {
        if (rra instanceof RealRandomAccessibleRealInterval) {
            return Masks.toRealMaskRealInterval((RealRandomAccessibleRealInterval)rra);
        }
        return new RealRandomAccessibleAsRealMask<B>(rra);
    }

    public static <B extends BooleanType<B>> RealMaskRealInterval toRealMaskRealInterval(RealRandomAccessibleRealInterval<B> rrari) {
        return new RealRandomAccessibleRealIntervalAsRealMaskRealInterval<B>(rrari);
    }

    public static Mask emptyMask(int numDims) {
        return new DefaultMask(numDims, BoundaryType.UNSPECIFIED, t -> false, KnownConstant.ALL_FALSE);
    }

    public static MaskInterval emptyMaskInterval(int numDims) {
        return new DefaultMaskInterval(Masks.emptyInterval(numDims), BoundaryType.UNSPECIFIED, t -> false, KnownConstant.ALL_FALSE);
    }

    public static RealMask emptyRealMask(int numDims) {
        return new DefaultRealMask(numDims, BoundaryType.UNSPECIFIED, t -> false, KnownConstant.ALL_FALSE);
    }

    public static RealMaskRealInterval emptyRealMaskRealInterval(int numDims) {
        return new DefaultRealMaskRealInterval(Masks.emptyRealInterval(numDims), BoundaryType.UNSPECIFIED, t -> false, KnownConstant.ALL_FALSE);
    }

    public static Interval emptyInterval(int numDims) {
        long[] min = new long[numDims];
        Arrays.fill(min, Long.MAX_VALUE);
        long[] max = new long[numDims];
        Arrays.fill(max, Long.MIN_VALUE);
        return new FinalInterval(min, max);
    }

    public static RealInterval emptyRealInterval(int numDims) {
        double[] min = new double[numDims];
        Arrays.fill(min, Double.POSITIVE_INFINITY);
        double[] max = new double[numDims];
        Arrays.fill(max, Double.NEGATIVE_INFINITY);
        return new FinalRealInterval(min, max);
    }

    public static Mask allMask(int numDims) {
        return new DefaultMask(numDims, BoundaryType.UNSPECIFIED, t -> true, KnownConstant.ALL_TRUE);
    }

    public static RealMask allRealMask(int numDims) {
        return new DefaultRealMask(numDims, BoundaryType.UNSPECIFIED, t -> true, KnownConstant.ALL_TRUE);
    }

    public static <T, M extends MaskPredicate<T>> boolean sameTypesAndDimensions(M mask1, M mask2) {
        return mask1.maskType() == mask2.maskType() && mask1.boundaryType() == mask2.boundaryType() && mask1.numDimensions() == mask2.numDimensions();
    }
}

