/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.boundary;

import java.util.Arrays;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.AbstractConvertedRandomAccess;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.type.BooleanType;
import net.imglib2.type.logic.BoolType;

public final class BoundaryRandomAccess8<T extends BooleanType<T>>
extends AbstractConvertedRandomAccess<T, BoolType> {
    private final int n;
    private final long[] min;
    private final long[] max;
    private final long[][] offsets;
    private final long[][] resets;
    private final BoolType type;

    public BoundaryRandomAccess8(RandomAccessibleInterval<T> sourceInterval) {
        super(sourceInterval.randomAccess());
        this.n = sourceInterval.numDimensions();
        this.min = new long[this.n];
        this.max = new long[this.n];
        sourceInterval.min(this.min);
        sourceInterval.max(this.max);
        this.offsets = new long[(int)Math.pow(3.0, this.n) - 1][];
        this.resets = new long[this.offsets.length][];
        long[] omin = new long[this.n];
        Arrays.fill(omin, -1L);
        long[] omax = new long[this.n];
        Arrays.fill(omax, 1L);
        IntervalIterator idx = new IntervalIterator(new FinalInterval(omin, omax));
        int center = (this.offsets.length - 1) / 2;
        long[] pos = new long[this.n];
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = new long[this.n];
            this.resets[i] = new long[this.n];
            if (i == center) {
                idx.fwd();
            }
            idx.fwd();
            idx.localize(this.offsets[i]);
            for (int d = 0; d < this.n; ++d) {
                long[] lArray = this.offsets[i];
                int n = d;
                lArray[n] = lArray[n] - pos[d];
                int n2 = d;
                pos[n2] = pos[n2] + this.offsets[i][d];
                this.resets[i][d] = -pos[d];
            }
        }
        this.type = new BoolType();
    }

    private BoundaryRandomAccess8(BoundaryRandomAccess8<T> ba) {
        super(ba.source.copyRandomAccess());
        this.n = ba.n;
        this.min = ba.min;
        this.max = ba.max;
        this.offsets = ba.offsets;
        this.resets = ba.resets;
        this.type = ba.type.copy();
    }

    @Override
    public BoolType get() {
        if (((BooleanType)this.source.get()).get()) {
            for (int d = 0; d < this.n; ++d) {
                long pos = this.getLongPosition(d);
                if (pos > this.min[d] && pos < this.max[d]) continue;
                this.type.set(true);
                return this.type;
            }
            for (int i = 0; i < this.offsets.length; ++i) {
                this.source.move(this.offsets[i]);
                if (((BooleanType)this.source.get()).get()) continue;
                this.source.move(this.resets[i]);
                this.type.set(true);
                return this.type;
            }
            this.source.move(this.resets[this.resets.length - 1]);
        }
        this.type.set(false);
        return this.type;
    }

    @Override
    public BoolType getType() {
        return this.type;
    }

    @Override
    public BoundaryRandomAccess8<T> copy() {
        return new BoundaryRandomAccess8<T>(this);
    }
}

