/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.composite;

import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.KnownConstant;
import net.imglib2.roi.MaskInterval;
import net.imglib2.roi.Operators;
import net.imglib2.roi.composite.UnaryCompositeMaskPredicate;
import net.imglib2.util.Intervals;

public class DefaultUnaryCompositeMaskInterval
extends AbstractWrappedInterval<Interval>
implements UnaryCompositeMaskPredicate<Localizable>,
MaskInterval {
    private final Operators.UnaryMaskOperator operator;
    private final Predicate<? super Localizable> arg0;
    private final BoundaryType boundaryType;
    private final Predicate<? super Localizable> predicate;
    private final UnaryOperator<KnownConstant> knownConstantOp;

    public DefaultUnaryCompositeMaskInterval(Operators.UnaryMaskOperator operator, Predicate<? super Localizable> arg0, Interval interval, BoundaryType boundaryType, UnaryOperator<KnownConstant> knownConstantOp) {
        super(interval);
        this.operator = operator;
        this.arg0 = arg0;
        this.boundaryType = boundaryType;
        this.predicate = operator.predicate(arg0);
        this.knownConstantOp = knownConstantOp;
    }

    @Override
    public BoundaryType boundaryType() {
        return this.boundaryType;
    }

    @Override
    public KnownConstant knownConstant() {
        return Intervals.isEmpty((Interval)this.sourceInterval) ? KnownConstant.ALL_FALSE : (KnownConstant)((Object)this.knownConstantOp.apply(KnownConstant.of(this.arg0)));
    }

    @Override
    public boolean test(Localizable localizable) {
        return this.predicate.test(localizable);
    }

    @Override
    public Operators.UnaryMaskOperator operator() {
        return this.operator;
    }

    @Override
    public Predicate<? super Localizable> arg0() {
        return this.arg0;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UnaryCompositeMaskPredicate) || !(obj instanceof MaskInterval)) {
            return false;
        }
        UnaryCompositeMaskPredicate u = (UnaryCompositeMaskPredicate)obj;
        return u.operator() == this.operator && this.arg0.equals(u.arg0());
    }

    public int hashCode() {
        return this.arg0.hashCode() + this.operator.hashCode() * 43;
    }
}

