/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;

public class GeomMaths {
    public static boolean lineContains(double[] endpointOne, double[] endpointTwo, RealLocalizable testPoint, int dims) {
        double[] directionVector = GeomMaths.computeDirectionVector(endpointOne, endpointTwo, dims);
        double[] testVector = new double[dims];
        double projection = 0.0;
        for (int d = 0; d < dims; ++d) {
            testVector[d] = testPoint.getDoublePosition(d) - endpointOne[d];
            projection += testVector[d] * directionVector[d];
        }
        double[] point = new double[dims];
        double squaredDistance = 0.0;
        for (int d = 0; d < dims; ++d) {
            point[d] = endpointOne[d] + projection * directionVector[d];
            if (point[d] > Math.max(endpointOne[d], endpointTwo[d])) {
                point[d] = Math.max(endpointOne[d], endpointTwo[d]);
            }
            if (point[d] < Math.min(endpointOne[d], endpointTwo[d])) {
                point[d] = Math.min(endpointOne[d], endpointTwo[d]);
            }
            squaredDistance += (point[d] - testPoint.getDoublePosition(d)) * (point[d] - testPoint.getDoublePosition(d));
        }
        return squaredDistance <= 1.0E-15;
    }

    public static boolean pnpoly(TDoubleArrayList x, TDoubleArrayList y, RealLocalizable localizable) {
        double xl = localizable.getDoublePosition(0);
        double yl = localizable.getDoublePosition(1);
        boolean result = false;
        int i = 0;
        int j = x.size() - 1;
        while (i < x.size()) {
            double xj = x.get(j);
            double yj = y.get(j);
            double xi = x.get(i);
            double yi = y.get(i);
            if (yi > yl != yj > yl && xl < (xj - xi) * (yl - yi) / (yj - yi) + xi) {
                result = !result;
            }
            j = i++;
        }
        return result;
    }

    public static Interval getBounds(Collection<? extends Localizable> vertices) {
        assert (vertices.size() != 0);
        int numDims = vertices.iterator().next().numDimensions();
        long[] min = new long[numDims];
        Arrays.fill(min, Long.MAX_VALUE);
        long[] max = new long[numDims];
        Arrays.fill(max, Long.MIN_VALUE);
        for (Localizable localizable : vertices) {
            for (int d = 0; d < numDims; ++d) {
                long pos = localizable.getLongPosition(d);
                if (pos < min[d]) {
                    min[d] = pos;
                }
                if (pos <= max[d]) continue;
                max[d] = pos;
            }
        }
        return new FinalInterval(min, max);
    }

    public static RealInterval getBoundsReal(Collection<? extends RealLocalizable> vertices) {
        assert (vertices.size() != 0);
        int numDims = vertices.iterator().next().numDimensions();
        double[] min = new double[numDims];
        Arrays.fill(min, Double.POSITIVE_INFINITY);
        double[] max = new double[numDims];
        Arrays.fill(max, Double.NEGATIVE_INFINITY);
        for (RealLocalizable realLocalizable : vertices) {
            for (int d = 0; d < numDims; ++d) {
                double pos = realLocalizable.getDoublePosition(d);
                if (pos < min[d]) {
                    min[d] = pos;
                }
                if (!(pos > max[d])) continue;
                max[d] = pos;
            }
        }
        return new FinalRealInterval(min, max);
    }

    public static RealInterval getBoundsReal(double[][] vertices) {
        int dims = vertices[0].length;
        double[] min = new double[dims];
        double[] max = new double[dims];
        for (int i = 0; i < dims; ++i) {
            double maxValue = vertices[0][i];
            double minValue = vertices[0][i];
            for (int j = 1; j < vertices.length; ++j) {
                if (vertices[j][i] < minValue) {
                    minValue = vertices[j][i];
                }
                if (!(vertices[j][i] > maxValue)) continue;
                maxValue = vertices[j][i];
            }
            min[i] = minValue;
            max[i] = maxValue;
        }
        return new FinalRealInterval(min, max);
    }

    public static RealInterval getBoundsReal(double[] x, double[] y) {
        int l = x.length <= y.length ? x.length : y.length;
        double[] min = new double[]{x[0], y[0]};
        double[] max = new double[]{x[0], y[0]};
        for (int i = 1; i < l; ++i) {
            double xi = x[i];
            double yi = y[i];
            if (xi < min[0]) {
                min[0] = xi;
            }
            if (xi > max[0]) {
                max[0] = xi;
            }
            if (yi < min[1]) {
                min[1] = yi;
            }
            if (!(yi > max[1])) continue;
            max[1] = yi;
        }
        return new FinalRealInterval(min, max);
    }

    public static List<Localizable> bresenham(List<? extends RealLocalizable> vertices) {
        assert (vertices.size() > 1);
        assert (vertices.iterator().next().numDimensions() == 2);
        ArrayList<Localizable> tmp = new ArrayList<Localizable>();
        for (int i = 0; i < vertices.size(); ++i) {
            long x0 = Math.round(vertices.get(i).getDoublePosition(0));
            long y0 = Math.round(vertices.get(i).getDoublePosition(1));
            long x1 = Math.round(vertices.get((i + 1) % vertices.size()).getDoublePosition(0));
            long y1 = Math.round(vertices.get((i + 1) % vertices.size()).getDoublePosition(1));
            long dx = Math.abs(x1 - x0);
            long sx = x0 < x1 ? 1L : -1L;
            long dy = -Math.abs(y1 - y0);
            long sy = y0 < y1 ? 1L : -1L;
            long err = dx + dy;
            while (true) {
                tmp.add(new Point(x0, y0));
                if (x0 == x1 && y0 == y1) break;
                long e2 = 2L * err;
                if (e2 > dy) {
                    err += dy;
                    x0 += sx;
                }
                if (e2 >= dx) continue;
                err += dx;
                y0 += sy;
            }
            tmp.remove(tmp.size() - 1);
        }
        return tmp;
    }

    private static double[] computeDirectionVector(double[] pointOne, double[] pointTwo, int dims) {
        int d;
        double[] directionVector = new double[dims];
        double magnitude = 0.0;
        for (d = 0; d < dims; ++d) {
            directionVector[d] = pointTwo[d] - pointOne[d];
            magnitude += directionVector[d] * directionVector[d];
        }
        magnitude = Math.sqrt(magnitude);
        for (d = 0; d < dims; ++d) {
            directionVector[d] = directionVector[d] / magnitude;
        }
        return directionVector;
    }
}

