/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import net.imglib2.RealLocalizable;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.Masks;
import net.imglib2.roi.RealMaskRealInterval;
import net.imglib2.util.Util;

public interface Box
extends RealMaskRealInterval {
    public double sideLength(int var1);

    public RealLocalizable center();

    @Override
    default public Class<?> maskType() {
        return Box.class;
    }

    @Override
    public boolean equals(Object var1);

    public static int hashCode(Box box) {
        int result = 17;
        for (int d = 0; d < box.numDimensions(); ++d) {
            result = (int)((double)result + (31.0 * box.realMin(d) + 31.0 * box.realMax(d)));
        }
        if (box.boundaryType() == BoundaryType.CLOSED) {
            result += 5;
        } else if (box.boundaryType() == BoundaryType.OPEN) {
            result += 8;
        }
        return result;
    }

    public static boolean equals(Box box1, Box box2) {
        if (box1 == null && box2 == null) {
            return true;
        }
        if (box1 == null || box2 == null || !Masks.sameTypesAndDimensions(box1, box2)) {
            return false;
        }
        for (int d = 0; d < box1.numDimensions(); ++d) {
            if (box1.sideLength(d) == box2.sideLength(d)) continue;
            return false;
        }
        return Util.locationsEqual(box1.center(), box2.center());
    }
}

