/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import java.util.Arrays;
import net.imglib2.AbstractRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.GeomMaths;
import net.imglib2.roi.geom.real.Line;
import net.imglib2.roi.geom.real.WritableLine;
import net.imglib2.roi.util.AbstractRealMaskPoint;
import net.imglib2.roi.util.RealLocalizableRealPositionable;
import net.imglib2.util.Intervals;

public class DefaultWritableLine
extends AbstractRealInterval
implements WritableLine {
    private double[] pointOne;
    private double[] pointTwo;

    public DefaultWritableLine(RealLocalizable pointOne, RealLocalizable pointTwo) {
        this(DefaultWritableLine.createArray(pointOne), DefaultWritableLine.createArray(pointTwo), false);
    }

    public DefaultWritableLine(double[] pointOne, double[] pointTwo, boolean copy) {
        super(Math.min(pointOne.length, pointTwo.length));
        if (copy || pointOne.length != pointTwo.length) {
            this.pointOne = Arrays.copyOf(pointOne, this.n);
            this.pointTwo = Arrays.copyOf(pointTwo, this.n);
        } else {
            this.pointOne = pointOne;
            this.pointTwo = pointTwo;
        }
        for (int d = 0; d < this.n; ++d) {
            this.min[d] = Math.min(this.pointOne[d], this.pointTwo[d]);
            this.max[d] = Math.max(this.pointOne[d], this.pointTwo[d]);
        }
    }

    @Override
    public boolean test(RealLocalizable l) {
        if (Intervals.contains((RealInterval)this, l)) {
            return GeomMaths.lineContains(this.pointOne, this.pointTwo, l, this.n);
        }
        return false;
    }

    @Override
    public RealLocalizableRealPositionable endpointOne() {
        return new LineEndPoint(this.pointOne);
    }

    @Override
    public RealLocalizableRealPositionable endpointTwo() {
        return new LineEndPoint(this.pointTwo);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Line && Line.equals(this, (Line)obj);
    }

    public int hashCode() {
        return Line.hashCode(this);
    }

    private static double[] createArray(RealLocalizable l) {
        double[] pt = new double[l.numDimensions()];
        l.localize(pt);
        return pt;
    }

    private class LineEndPoint
    extends AbstractRealMaskPoint {
        public LineEndPoint(double[] pos) {
            super(pos);
        }

        @Override
        public void updateBounds() {
            for (int d = 0; d < this.n; ++d) {
                ((DefaultWritableLine)DefaultWritableLine.this).min[d] = Math.min(DefaultWritableLine.this.pointOne[d], DefaultWritableLine.this.pointTwo[d]);
                ((DefaultWritableLine)DefaultWritableLine.this).max[d] = Math.max(DefaultWritableLine.this.pointOne[d], DefaultWritableLine.this.pointTwo[d]);
            }
        }
    }
}

