/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import java.util.Arrays;
import net.imglib2.AbstractInterval;
import net.imglib2.Localizable;

public class BoundingBox
extends AbstractInterval {
    public BoundingBox(int n) {
        super(n);
        Arrays.fill(this.max, Long.MIN_VALUE);
        Arrays.fill(this.min, Long.MAX_VALUE);
    }

    public void update(Localizable position) {
        for (int d = 0; d < this.min.length; ++d) {
            long p = position.getLongPosition(d);
            if (p < this.min[d]) {
                this.min[d] = p;
            }
            if (p <= this.max[d]) continue;
            this.max[d] = p;
        }
    }

    public void update(long[] position) {
        for (int d = 0; d < this.min.length; ++d) {
            if (position[d] < this.min[d]) {
                this.min[d] = position[d];
            }
            if (position[d] <= this.max[d]) continue;
            this.max[d] = position[d];
        }
    }
}

