/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.view.Views;

public class Labelings {
    public static <T> LabelingMapping<T> getLabelingMapping(RandomAccessibleInterval<LabelingType<T>> labeling) {
        return ((LabelingType)Views.iterable(labeling).firstElement()).getMapping();
    }

    public static <T, U, I extends IntegerType<I>> ImgLabeling<U, I> remapLabels(ImgLabeling<T, I> labeling, Function<T, U> function) {
        Set<T> inputLabels = labeling.getMapping().getLabels();
        HashMap labelMap = new HashMap(inputLabels.size());
        inputLabels.stream().forEach(t -> labelMap.put(t, function.apply(t)));
        return Labelings.remapLabels(labeling, labelMap);
    }

    public static <T, U, I extends IntegerType<I>> ImgLabeling<U, I> remapLabels(ImgLabeling<T, I> labeling, Map<T, U> mapping) {
        List<Set<Set>> labelSets = labeling.getMapping().getLabelSets();
        ArrayList resultLabelSets = new ArrayList(labelSets.size());
        labelSets.forEach(labelSet -> resultLabelSets.add(labelSet.stream().map(t -> mapping.get(t)).collect(Collectors.toSet())));
        ImgLabeling result = new ImgLabeling(labeling.getIndexImg());
        LabelingMapping resultMapping = result.getMapping();
        resultMapping.setLabelSets(resultLabelSets);
        return result;
    }

    public static <T, I extends IntegerType<I>> Set<I> getOccurringPixelSets(ImgLabeling<T, I> img) {
        HashSet occurringValues = new HashSet();
        for (IntegerType pixel : Views.iterable(img.getIndexImg())) {
            if (pixel.getInteger() <= 0 || occurringValues.contains(pixel)) continue;
            occurringValues.add(pixel.copy());
        }
        return occurringValues;
    }

    public static <T, I extends IntegerType<I>> boolean hasIntersectingLabels(ImgLabeling<T, I> img) {
        List<Set<T>> labelSets = img.getMapping().getLabelSets();
        for (IntegerType i : Labelings.getOccurringPixelSets(img)) {
            if (labelSets.get(i.getInteger()).size() <= 1) continue;
            return true;
        }
        return false;
    }
}

