/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.labeling;

import java.util.Arrays;

class SortedInts {
    private static final SortedInts EMPTY_LIST = SortedInts.wrapSortedValues(new int[0]);
    private final int[] values;
    private final int hashCode;

    private SortedInts(int[] sortedValues) {
        this.values = sortedValues;
        this.hashCode = Arrays.hashCode(sortedValues);
    }

    public static SortedInts emptyList() {
        return EMPTY_LIST;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SortedInts)) {
            return false;
        }
        SortedInts other = (SortedInts)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    public boolean contains(int value) {
        return Arrays.binarySearch(this.values, value) >= 0;
    }

    public SortedInts copyAndAdd(int value) {
        int index = Arrays.binarySearch(this.values, value);
        if (index >= 0) {
            return this;
        }
        int insertionPoint = -1 - index;
        int[] newValues = new int[this.values.length + 1];
        System.arraycopy(this.values, 0, newValues, 0, insertionPoint);
        newValues[insertionPoint] = value;
        System.arraycopy(this.values, insertionPoint, newValues, insertionPoint + 1, this.values.length - insertionPoint);
        return SortedInts.wrapSortedValues(newValues);
    }

    public SortedInts copyAndRemove(int value) {
        int index = Arrays.binarySearch(this.values, value);
        if (index < 0) {
            return this;
        }
        int[] newValues = new int[this.values.length - 1];
        System.arraycopy(this.values, 0, newValues, 0, index);
        System.arraycopy(this.values, index + 1, newValues, index, this.values.length - index - 1);
        return SortedInts.wrapSortedValues(newValues);
    }

    public static SortedInts create(int ... values) {
        int[] newValues = Arrays.copyOf(values, values.length);
        Arrays.sort(newValues);
        return new SortedInts(newValues);
    }

    public static SortedInts wrapSortedValues(int ... sortedValues) {
        return new SortedInts(sortedValues);
    }

    public int[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    public int size() {
        return this.values.length;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public int get(int i) {
        return this.values[i];
    }

    public int hashCode() {
        return this.hashCode;
    }
}

