/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.ui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.ui.TransformEventHandler;
import net.imglib2.ui.TransformEventHandlerFactory;
import net.imglib2.ui.TransformListener;

public class TransformEventHandler3D
extends MouseAdapter
implements KeyListener,
TransformEventHandler<AffineTransform3D> {
    private static final TransformEventHandlerFactory<AffineTransform3D> factory = new TransformEventHandlerFactory<AffineTransform3D>(){

        @Override
        public TransformEventHandler<AffineTransform3D> create(TransformListener<AffineTransform3D> transformListener) {
            return new TransformEventHandler3D(transformListener);
        }
    };
    protected final AffineTransform3D affine = new AffineTransform3D();
    protected TransformListener<AffineTransform3D> listener;
    protected final AffineTransform3D affineDragStart = new AffineTransform3D();
    protected double oX;
    protected double oY;
    protected int axis = 0;
    protected int canvasW = 1;
    protected int canvasH = 1;
    protected int centerX = 0;
    protected int centerY = 0;
    private static final double step = Math.PI / 180;
    private static final String NL = System.getProperty("line.separator");
    private static final String helpString = "Mouse control:" + NL + " " + NL + "Pan and tilt the volume by left-click and dragging the image in the canvas, " + NL + "move the volume by middle-or-right-click and dragging the image in the canvas, " + NL + "browse alongside the z-axis using the mouse-wheel, and" + NL + "zoom in and out using the mouse-wheel holding CTRL+SHIFT or META." + NL + " " + NL + "Key control:" + NL + " " + NL + "X - Select x-axis as rotation axis." + NL + "Y - Select y-axis as rotation axis." + NL + "Z - Select z-axis as rotation axis." + NL + "CURSOR LEFT - Rotate clockwise around the choosen rotation axis." + NL + "CURSOR RIGHT - Rotate counter-clockwise around the choosen rotation axis." + NL + "CURSOR UP - Zoom in." + NL + "CURSOR DOWN - Zoom out." + NL + "./> - Forward alongside z-axis." + NL + ",/< - Backward alongside z-axis." + NL + "SHIFT - Rotate and browse 10x faster." + NL + "CTRL - Rotate and browse 10x slower.";

    public static TransformEventHandlerFactory<AffineTransform3D> factory() {
        return factory;
    }

    public TransformEventHandler3D(TransformListener<AffineTransform3D> listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AffineTransform3D getTransform() {
        AffineTransform3D affineTransform3D = this.affine;
        synchronized (affineTransform3D) {
            return this.affine.copy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransform(AffineTransform3D transform) {
        AffineTransform3D affineTransform3D = this.affine;
        synchronized (affineTransform3D) {
            this.affine.set(transform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanvasSize(int width, int height, boolean updateTransform) {
        if (updateTransform) {
            AffineTransform3D affineTransform3D = this.affine;
            synchronized (affineTransform3D) {
                this.affine.set(this.affine.get(0, 3) - (double)(this.canvasW / 2), 0, 3);
                this.affine.set(this.affine.get(1, 3) - (double)(this.canvasH / 2), 1, 3);
                this.affine.scale((double)width / (double)this.canvasW);
                this.affine.set(this.affine.get(0, 3) + (double)(width / 2), 0, 3);
                this.affine.set(this.affine.get(1, 3) + (double)(height / 2), 1, 3);
                this.update();
            }
        }
        this.canvasW = width;
        this.canvasH = height;
        this.centerX = width / 2;
        this.centerY = height / 2;
    }

    @Override
    public void setTransformListener(TransformListener<AffineTransform3D> transformListener) {
        this.listener = transformListener;
    }

    @Override
    public String getHelpString() {
        return helpString;
    }

    private void update() {
        if (this.listener != null) {
            this.listener.transformChanged(this.affine);
        }
    }

    private static double keyModfiedSpeed(int modifiers) {
        if ((modifiers & 0x40) != 0) {
            return 10.0;
        }
        if ((modifiers & 0x80) != 0) {
            return 0.1;
        }
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e) {
        AffineTransform3D affineTransform3D = this.affine;
        synchronized (affineTransform3D) {
            this.oX = e.getX();
            this.oY = e.getY();
            this.affineDragStart.set(this.affine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        AffineTransform3D affineTransform3D = this.affine;
        synchronized (affineTransform3D) {
            int modifiers = e.getModifiersEx();
            double dX = this.oX - (double)e.getX();
            double dY = this.oY - (double)e.getY();
            if ((modifiers & 0x400) != 0) {
                this.affine.set(this.affineDragStart);
                this.affine.set(this.affine.get(0, 3) - this.oX, 0, 3);
                this.affine.set(this.affine.get(1, 3) - this.oY, 1, 3);
                double v = Math.PI / 180 * TransformEventHandler3D.keyModfiedSpeed(modifiers);
                this.affine.rotate(0, -dY * v);
                this.affine.rotate(1, dX * v);
                this.affine.set(this.affine.get(0, 3) + this.oX, 0, 3);
                this.affine.set(this.affine.get(1, 3) + this.oY, 1, 3);
                this.update();
            } else if ((modifiers & 0x1800) != 0) {
                this.affine.set(this.affineDragStart);
                this.affine.set(this.affine.get(0, 3) - dX, 0, 3);
                this.affine.set(this.affine.get(1, 3) - dY, 1, 3);
                this.update();
            }
        }
    }

    private void scale(double s, double x, double y) {
        this.affine.set(this.affine.get(0, 3) - x, 0, 3);
        this.affine.set(this.affine.get(1, 3) - y, 1, 3);
        this.affine.scale(s);
        this.affine.set(this.affine.get(0, 3) + x, 0, 3);
        this.affine.set(this.affine.get(1, 3) + y, 1, 3);
    }

    private void rotate(int axisNo, double d) {
        this.affine.set(this.affine.get(0, 3) - (double)this.centerX, 0, 3);
        this.affine.set(this.affine.get(1, 3) - (double)this.centerY, 1, 3);
        this.affine.rotate(axisNo, d);
        this.affine.set(this.affine.get(0, 3) + (double)this.centerX, 0, 3);
        this.affine.set(this.affine.get(1, 3) + (double)this.centerY, 1, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        AffineTransform3D affineTransform3D = this.affine;
        synchronized (affineTransform3D) {
            int modifiers = e.getModifiersEx();
            double v = TransformEventHandler3D.keyModfiedSpeed(modifiers);
            int s = e.getWheelRotation();
            if ((modifiers & 0x80) != 0 && (modifiers & 0x40) != 0 || (modifiers & 0x100) != 0) {
                double dScale = 1.05;
                if (s > 0) {
                    this.scale(0.9523809523809523, e.getX(), e.getY());
                } else {
                    this.scale(1.05, e.getX(), e.getY());
                }
            } else {
                double dZ = v * (double)(-s);
                this.affine.set(this.affine.get(2, 3) - dZ, 2, 3);
            }
            this.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent e) {
        AffineTransform3D affineTransform3D = this.affine;
        synchronized (affineTransform3D) {
            int keyCode = e.getKeyCode();
            int keyModifiers = e.getModifiersEx() & 0x23C0;
            double v = TransformEventHandler3D.keyModfiedSpeed(e.getModifiersEx());
            if (keyCode == 88 && keyModifiers == 0) {
                this.axis = 0;
            } else if (keyCode == 89 && keyModifiers == 0) {
                this.axis = 1;
            } else if (keyCode == 90 && keyModifiers == 0) {
                this.axis = 2;
            } else if (keyCode == 37) {
                this.rotate(this.axis, Math.PI / 180 * v);
                this.update();
            } else if (keyCode == 39) {
                this.rotate(this.axis, Math.PI / 180 * -v);
                this.update();
            }
            if (keyCode == 38) {
                double dScale = 1.0 + 0.1 * v;
                this.scale(dScale, this.centerX, this.centerY);
                this.update();
            } else if (keyCode == 40) {
                double dScale = 1.0 + 0.1 * v;
                this.scale(1.0 / dScale, this.centerX, this.centerY);
                this.update();
            } else if (keyCode == 44) {
                this.affine.set(this.affine.get(2, 3) + v, 2, 3);
                this.update();
            } else if (keyCode == 46) {
                this.affine.set(this.affine.get(2, 3) - v, 2, 3);
                this.update();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

