/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.function.Function;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.converter.AbstractConvertedRandomAccess;

class FunctionView<A, B>
implements RandomAccessible<B> {
    protected final RandomAccessible<A> source;
    private final Function<A, B> function;

    public FunctionView(RandomAccessible<A> source, Function<A, B> function) {
        this.source = source;
        this.function = function;
    }

    @Override
    public int numDimensions() {
        return this.source.numDimensions();
    }

    @Override
    public RandomAccess<B> randomAccess() {
        return new FunctionRandomAccess(this.source.randomAccess());
    }

    @Override
    public RandomAccess<B> randomAccess(Interval interval) {
        return new FunctionRandomAccess(this.source.randomAccess(interval));
    }

    @Override
    public B getType() {
        return (B)this.randomAccess().getType();
    }

    class FunctionRandomAccess
    extends AbstractConvertedRandomAccess<A, B> {
        FunctionRandomAccess(RandomAccess<A> source) {
            super(source);
        }

        @Override
        public B get() {
            return FunctionView.this.function.apply(this.source.get());
        }

        @Override
        public B getType() {
            return this.get();
        }

        @Override
        public FunctionRandomAccess copy() {
            return new FunctionRandomAccess(this.source);
        }
    }
}

