/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.imglib2icy;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import java.util.Arrays;
import net.imglib2.img.Img;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.img.planar.PlanarImgs;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;

public class ImgLib2IcySequenceAdapter {
    private static long[] getDims(Sequence sequence) {
        int sizeX = sequence.getSizeX();
        int sizeY = sequence.getSizeY();
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        return new long[]{sizeX, sizeY, sizeC, sizeZ, sizeT};
    }

    private static long[] getSqueezedDims(Sequence sequence) {
        long[] dims = ImgLib2IcySequenceAdapter.squeezeSingletonDims(ImgLib2IcySequenceAdapter.getDims(sequence));
        return dims;
    }

    private static long[] squeezeSingletonDims(long[] originalDims) {
        long[] dims = new long[originalDims.length];
        int index = 0;
        for (long l : originalDims) {
            if (l <= 1L) continue;
            dims[index++] = l;
        }
        return Arrays.copyOf(dims, index);
    }

    public static double[] getCalibration(Sequence sequence) {
        double[] calibration = new double[]{sequence.getPixelSizeX(), sequence.getPixelSizeY(), sequence.getPixelSizeZ(), sequence.getTimeInterval()};
        return calibration;
    }

    public static <T extends NumericType<T> & RealType<T>> Img<T> wrap(Sequence sequence) {
        switch (sequence.getDataType_()) {
            case BYTE: {
                return ImgLib2IcySequenceAdapter.wrapByte(sequence);
            }
            case INT: {
                return ImgLib2IcySequenceAdapter.wrapInt(sequence);
            }
            case SHORT: {
                return ImgLib2IcySequenceAdapter.wrapShort(sequence);
            }
            case UBYTE: {
                return ImgLib2IcySequenceAdapter.wrapUnsignedByte(sequence);
            }
            case UINT: {
                return ImgLib2IcySequenceAdapter.wrapUnsignedInt(sequence);
            }
            case USHORT: {
                return ImgLib2IcySequenceAdapter.wrapUnsignedShort(sequence);
            }
            case DOUBLE: {
                return ImgLib2IcySequenceAdapter.wrapDouble(sequence);
            }
            case FLOAT: {
                return ImgLib2IcySequenceAdapter.wrapFloat(sequence);
            }
        }
        throw new RuntimeException("Only byte, int, short, float or double supported!");
    }

    public static Img<ByteType> wrapByte(Sequence sequence) {
        PlanarImg<ByteType, ByteArray> img = PlanarImgs.bytes(ImgLib2IcySequenceAdapter.getSqueezedDims(sequence));
        int no = 0;
        for (IcyBufferedImage image : sequence.getAllImage()) {
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                byte[] data = image.getDataXYAsByte(c);
                ByteArray plane = new ByteArray(data);
                img.setPlane(no++, plane);
            }
        }
        return img;
    }

    public static Img<DoubleType> wrapDouble(Sequence sequence) {
        PlanarImg<DoubleType, DoubleArray> img = PlanarImgs.doubles(ImgLib2IcySequenceAdapter.getSqueezedDims(sequence));
        int no = 0;
        for (IcyBufferedImage image : sequence.getAllImage()) {
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                double[] data = image.getDataXYAsDouble(c);
                DoubleArray plane = new DoubleArray(data);
                img.setPlane(no++, plane);
            }
        }
        return img;
    }

    public static Img<FloatType> wrapFloat(Sequence sequence) {
        PlanarImg<FloatType, FloatArray> img = PlanarImgs.floats(ImgLib2IcySequenceAdapter.getSqueezedDims(sequence));
        int no = 0;
        for (IcyBufferedImage image : sequence.getAllImage()) {
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                float[] data = image.getDataXYAsFloat(c);
                FloatArray plane = new FloatArray(data);
                img.setPlane(no++, plane);
            }
        }
        return img;
    }

    public static Img<IntType> wrapInt(Sequence sequence) {
        PlanarImg<IntType, IntArray> img = PlanarImgs.ints(ImgLib2IcySequenceAdapter.getSqueezedDims(sequence));
        int no = 0;
        for (IcyBufferedImage image : sequence.getAllImage()) {
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                int[] data = image.getDataXYAsInt(c);
                IntArray plane = new IntArray(data);
                img.setPlane(no++, plane);
            }
        }
        return img;
    }

    public static Img<ShortType> wrapShort(Sequence sequence) {
        PlanarImg<ShortType, ShortArray> img = PlanarImgs.shorts(ImgLib2IcySequenceAdapter.getSqueezedDims(sequence));
        int no = 0;
        for (IcyBufferedImage image : sequence.getAllImage()) {
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                short[] data = image.getDataXYAsShort(c);
                ShortArray plane = new ShortArray(data);
                img.setPlane(no++, plane);
            }
        }
        return img;
    }

    public static Img<UnsignedByteType> wrapUnsignedByte(Sequence sequence) {
        PlanarImg<UnsignedByteType, ByteArray> img = PlanarImgs.unsignedBytes(ImgLib2IcySequenceAdapter.getSqueezedDims(sequence));
        int no = 0;
        for (IcyBufferedImage image : sequence.getAllImage()) {
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                byte[] data = image.getDataXYAsByte(c);
                ByteArray plane = new ByteArray(data);
                img.setPlane(no++, plane);
            }
        }
        return img;
    }

    public static Img<UnsignedIntType> wrapUnsignedInt(Sequence sequence) {
        PlanarImg<UnsignedIntType, IntArray> img = PlanarImgs.unsignedInts(ImgLib2IcySequenceAdapter.getSqueezedDims(sequence));
        int no = 0;
        for (IcyBufferedImage image : sequence.getAllImage()) {
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                int[] data = image.getDataXYAsInt(c);
                IntArray plane = new IntArray(data);
                img.setPlane(no++, plane);
            }
        }
        return img;
    }

    public static Img<UnsignedShortType> wrapUnsignedShort(Sequence sequence) {
        PlanarImg<UnsignedShortType, ShortArray> img = PlanarImgs.unsignedShorts(ImgLib2IcySequenceAdapter.getSqueezedDims(sequence));
        int no = 0;
        for (IcyBufferedImage image : sequence.getAllImage()) {
            for (int c = 0; c < sequence.getSizeC(); ++c) {
                short[] data = image.getDataXYAsShort(c);
                ShortArray plane = new ShortArray(data);
                img.setPlane(no++, plane);
            }
        }
        return img;
    }

    private ImgLib2IcySequenceAdapter() {
    }
}

