/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.imglib2icy;

import icy.sequence.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.imglib2.img.Img;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.img.planar.PlanarImgs;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import plugins.tinevez.imglib2icy.ImgLib2IcyFunctions;
import plugins.tinevez.imglib2icy.VirtualSequence;

public class ImgLib2IcySplitSequenceAdapter {
    public static VirtualSequence.DimensionArrangement getDimensionArrangement(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        VirtualSequence.DimensionArrangement da = ImgLib2IcyFunctions.getDimensionArrangement(sequence);
        if (splitC) {
            da = da.dropC();
        }
        if (splitZ) {
            da = da.dropZ();
        }
        if (splitT) {
            da = da.dropT();
        }
        return da;
    }

    private static long[] getDims(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        int sizeX = sequence.getSizeX();
        int sizeY = sequence.getSizeY();
        int sizeC = splitC ? 0 : sequence.getSizeC();
        int sizeZ = splitZ ? 0 : sequence.getSizeZ();
        int sizeT = splitT ? 0 : sequence.getSizeT();
        return new long[]{sizeX, sizeY, sizeC, sizeZ, sizeT};
    }

    private static long[] getSqueezedDims(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        long[] dims = ImgLib2IcySplitSequenceAdapter.squeezeSingletonDims(ImgLib2IcySplitSequenceAdapter.getDims(sequence, splitC, splitZ, splitT));
        return dims;
    }

    private static int linearIndexFromCoordinate(int c, int z, int t, int sizeC, int sizeZ, boolean splitC, boolean splitZ, boolean splitT) {
        int C2;
        int B;
        int A;
        if (splitC) {
            if (splitZ) {
                A = 1;
                B = sizeC;
                C2 = splitT ? sizeC * sizeZ : 0;
            } else {
                A = 1;
                if (splitT) {
                    B = 0;
                    C2 = sizeC;
                } else {
                    B = 0;
                    C2 = 0;
                }
            }
        } else {
            A = 0;
            if (splitZ) {
                B = 1;
                C2 = splitT ? sizeZ : 0;
            } else {
                B = 0;
                C2 = splitT ? 1 : 0;
            }
        }
        return A * c + B * z + C2 * t;
    }

    private static long[] squeezeSingletonDims(long[] originalDims) {
        long[] dims = new long[originalDims.length];
        int index = 0;
        for (long l : originalDims) {
            if (l <= 1L) continue;
            dims[index++] = l;
        }
        return Arrays.copyOf(dims, index);
    }

    public static <T extends NumericType<T> & RealType<T>> List<Img<T>> wrap(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        switch (sequence.getDataType_()) {
            case BYTE: {
                return ImgLib2IcySplitSequenceAdapter.wrapByte(sequence, splitC, splitZ, splitT);
            }
            case INT: {
                return ImgLib2IcySplitSequenceAdapter.wrapInt(sequence, splitC, splitZ, splitT);
            }
            case SHORT: {
                return ImgLib2IcySplitSequenceAdapter.wrapShort(sequence, splitC, splitZ, splitT);
            }
            case UBYTE: {
                return ImgLib2IcySplitSequenceAdapter.wrapUnsignedByte(sequence, splitC, splitZ, splitT);
            }
            case UINT: {
                return ImgLib2IcySplitSequenceAdapter.wrapUnsignedInt(sequence, splitC, splitZ, splitT);
            }
            case USHORT: {
                return ImgLib2IcySplitSequenceAdapter.wrapUnsignedShort(sequence, splitC, splitZ, splitT);
            }
            case DOUBLE: {
                return ImgLib2IcySplitSequenceAdapter.wrapDouble(sequence, splitC, splitZ, splitT);
            }
            case FLOAT: {
                return ImgLib2IcySplitSequenceAdapter.wrapFloat(sequence, splitC, splitZ, splitT);
            }
        }
        throw new RuntimeException("Only byte, int, short, float or double supported!");
    }

    public static List<Img<ByteType>> wrapByte(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        ArrayList<Img<ByteType>> imgs = new ArrayList<Img<ByteType>>();
        ArrayList<Integer> planeCounters = new ArrayList<Integer>();
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int c = 0; c < sizeC; ++c) {
                    Integer count;
                    PlanarImg<ByteType, ByteArray> img;
                    int index = ImgLib2IcySplitSequenceAdapter.linearIndexFromCoordinate(c, z, t, sizeC, sizeZ, splitC, splitZ, splitT);
                    if (index >= imgs.size()) {
                        img = PlanarImgs.bytes(ImgLib2IcySplitSequenceAdapter.getSqueezedDims(sequence, splitC, splitZ, splitT));
                        imgs.add(img);
                        count = 0;
                        planeCounters.add(count);
                    } else {
                        img = (PlanarImg<ByteType, ByteArray>)imgs.get(index);
                        count = (Integer)planeCounters.get(index);
                    }
                    byte[] data = sequence.getDataXYAsByte(t, z, c);
                    ByteArray plane = new ByteArray(data);
                    Integer n = count;
                    count = count + 1;
                    img.setPlane((int)n, plane);
                    planeCounters.set(index, count);
                }
            }
        }
        return imgs;
    }

    public static List<Img<DoubleType>> wrapDouble(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        ArrayList<Img<DoubleType>> imgs = new ArrayList<Img<DoubleType>>();
        ArrayList<Integer> planeCounters = new ArrayList<Integer>();
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int c = 0; c < sizeC; ++c) {
                    Integer count;
                    PlanarImg<DoubleType, DoubleArray> img;
                    int index = ImgLib2IcySplitSequenceAdapter.linearIndexFromCoordinate(c, z, t, sizeC, sizeZ, splitC, splitZ, splitT);
                    if (index >= imgs.size()) {
                        img = PlanarImgs.doubles(ImgLib2IcySplitSequenceAdapter.getSqueezedDims(sequence, splitC, splitZ, splitT));
                        imgs.add(img);
                        count = 0;
                        planeCounters.add(count);
                    } else {
                        img = (PlanarImg<DoubleType, DoubleArray>)imgs.get(index);
                        count = (Integer)planeCounters.get(index);
                    }
                    double[] data = sequence.getDataXYAsDouble(t, z, c);
                    DoubleArray plane = new DoubleArray(data);
                    Integer n = count;
                    count = count + 1;
                    img.setPlane((int)n, plane);
                    planeCounters.set(index, count);
                }
            }
        }
        return imgs;
    }

    public static List<Img<FloatType>> wrapFloat(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        ArrayList<Img<FloatType>> imgs = new ArrayList<Img<FloatType>>();
        ArrayList<Integer> planeCounters = new ArrayList<Integer>();
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int c = 0; c < sizeC; ++c) {
                    Integer count;
                    PlanarImg<FloatType, FloatArray> img;
                    int index = ImgLib2IcySplitSequenceAdapter.linearIndexFromCoordinate(c, z, t, sizeC, sizeZ, splitC, splitZ, splitT);
                    if (index >= imgs.size()) {
                        img = PlanarImgs.floats(ImgLib2IcySplitSequenceAdapter.getSqueezedDims(sequence, splitC, splitZ, splitT));
                        imgs.add(img);
                        count = 0;
                        planeCounters.add(count);
                    } else {
                        img = (PlanarImg<FloatType, FloatArray>)imgs.get(index);
                        count = (Integer)planeCounters.get(index);
                    }
                    float[] data = sequence.getDataXYAsFloat(t, z, c);
                    FloatArray plane = new FloatArray(data);
                    Integer n = count;
                    count = count + 1;
                    img.setPlane((int)n, plane);
                    planeCounters.set(index, count);
                }
            }
        }
        return imgs;
    }

    public static List<Img<IntType>> wrapInt(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        ArrayList<Img<IntType>> imgs = new ArrayList<Img<IntType>>();
        ArrayList<Integer> planeCounters = new ArrayList<Integer>();
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int c = 0; c < sizeC; ++c) {
                    Integer count;
                    PlanarImg<IntType, IntArray> img;
                    int index = ImgLib2IcySplitSequenceAdapter.linearIndexFromCoordinate(c, z, t, sizeC, sizeZ, splitC, splitZ, splitT);
                    if (index >= imgs.size()) {
                        img = PlanarImgs.ints(ImgLib2IcySplitSequenceAdapter.getSqueezedDims(sequence, splitC, splitZ, splitT));
                        imgs.add(img);
                        count = 0;
                        planeCounters.add(count);
                    } else {
                        img = (PlanarImg<IntType, IntArray>)imgs.get(index);
                        count = (Integer)planeCounters.get(index);
                    }
                    int[] data = sequence.getDataXYAsInt(t, z, c);
                    IntArray plane = new IntArray(data);
                    Integer n = count;
                    count = count + 1;
                    img.setPlane((int)n, plane);
                    planeCounters.set(index, count);
                }
            }
        }
        return imgs;
    }

    public static List<Img<ShortType>> wrapShort(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        ArrayList<Img<ShortType>> imgs = new ArrayList<Img<ShortType>>();
        ArrayList<Integer> planeCounters = new ArrayList<Integer>();
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int c = 0; c < sizeC; ++c) {
                    Integer count;
                    PlanarImg<ShortType, ShortArray> img;
                    int index = ImgLib2IcySplitSequenceAdapter.linearIndexFromCoordinate(c, z, t, sizeC, sizeZ, splitC, splitZ, splitT);
                    if (index >= imgs.size()) {
                        img = PlanarImgs.shorts(ImgLib2IcySplitSequenceAdapter.getSqueezedDims(sequence, splitC, splitZ, splitT));
                        imgs.add(img);
                        count = 0;
                        planeCounters.add(count);
                    } else {
                        img = (PlanarImg<ShortType, ShortArray>)imgs.get(index);
                        count = (Integer)planeCounters.get(index);
                    }
                    short[] data = sequence.getDataXYAsShort(t, z, c);
                    ShortArray plane = new ShortArray(data);
                    Integer n = count;
                    count = count + 1;
                    img.setPlane((int)n, plane);
                    planeCounters.set(index, count);
                }
            }
        }
        return imgs;
    }

    public static List<Img<UnsignedByteType>> wrapUnsignedByte(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        ArrayList<Img<UnsignedByteType>> imgs = new ArrayList<Img<UnsignedByteType>>();
        ArrayList<Integer> planeCounters = new ArrayList<Integer>();
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int c = 0; c < sizeC; ++c) {
                    Integer count;
                    PlanarImg<UnsignedByteType, ByteArray> img;
                    int index = ImgLib2IcySplitSequenceAdapter.linearIndexFromCoordinate(c, z, t, sizeC, sizeZ, splitC, splitZ, splitT);
                    if (index >= imgs.size()) {
                        img = PlanarImgs.unsignedBytes(ImgLib2IcySplitSequenceAdapter.getSqueezedDims(sequence, splitC, splitZ, splitT));
                        imgs.add(img);
                        count = 0;
                        planeCounters.add(count);
                    } else {
                        img = (PlanarImg<UnsignedByteType, ByteArray>)imgs.get(index);
                        count = (Integer)planeCounters.get(index);
                    }
                    byte[] data = sequence.getDataXYAsByte(t, z, c);
                    ByteArray plane = new ByteArray(data);
                    Integer n = count;
                    count = count + 1;
                    img.setPlane((int)n, plane);
                    planeCounters.set(index, count);
                }
            }
        }
        return imgs;
    }

    public static List<Img<UnsignedIntType>> wrapUnsignedInt(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        ArrayList<Img<UnsignedIntType>> imgs = new ArrayList<Img<UnsignedIntType>>();
        ArrayList<Integer> planeCounters = new ArrayList<Integer>();
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int c = 0; c < sizeC; ++c) {
                    Integer count;
                    PlanarImg<UnsignedIntType, IntArray> img;
                    int index = ImgLib2IcySplitSequenceAdapter.linearIndexFromCoordinate(c, z, t, sizeC, sizeZ, splitC, splitZ, splitT);
                    if (index >= imgs.size()) {
                        img = PlanarImgs.unsignedInts(ImgLib2IcySplitSequenceAdapter.getSqueezedDims(sequence, splitC, splitZ, splitT));
                        imgs.add(img);
                        count = 0;
                        planeCounters.add(count);
                    } else {
                        img = (PlanarImg<UnsignedIntType, IntArray>)imgs.get(index);
                        count = (Integer)planeCounters.get(index);
                    }
                    int[] data = sequence.getDataXYAsInt(t, z, c);
                    IntArray plane = new IntArray(data);
                    Integer n = count;
                    count = count + 1;
                    img.setPlane((int)n, plane);
                    planeCounters.set(index, count);
                }
            }
        }
        return imgs;
    }

    public static List<Img<UnsignedShortType>> wrapUnsignedShort(Sequence sequence, boolean splitC, boolean splitZ, boolean splitT) {
        ArrayList<Img<UnsignedShortType>> imgs = new ArrayList<Img<UnsignedShortType>>();
        ArrayList<Integer> planeCounters = new ArrayList<Integer>();
        int sizeC = sequence.getSizeC();
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int c = 0; c < sizeC; ++c) {
                    Integer count;
                    PlanarImg<UnsignedShortType, ShortArray> img;
                    int index = ImgLib2IcySplitSequenceAdapter.linearIndexFromCoordinate(c, z, t, sizeC, sizeZ, splitC, splitZ, splitT);
                    if (index >= imgs.size()) {
                        img = PlanarImgs.unsignedShorts(ImgLib2IcySplitSequenceAdapter.getSqueezedDims(sequence, splitC, splitZ, splitT));
                        imgs.add(img);
                        count = 0;
                        planeCounters.add(count);
                    } else {
                        img = (PlanarImg<UnsignedShortType, ShortArray>)imgs.get(index);
                        count = (Integer)planeCounters.get(index);
                    }
                    short[] data = sequence.getDataXYAsShort(t, z, c);
                    ShortArray plane = new ShortArray(data);
                    Integer n = count;
                    count = count + 1;
                    img.setPlane((int)n, plane);
                    planeCounters.set(index, count);
                }
            }
        }
        return imgs;
    }

    private ImgLib2IcySplitSequenceAdapter() {
    }
}

