/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.imglib2icy;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import java.util.ArrayList;
import java.util.TreeMap;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.RealFloatConverter;
import net.imglib2.converter.RealUnsignedByteConverter;
import net.imglib2.converter.RealUnsignedShortConverter;
import net.imglib2.display.projector.IterableIntervalProjector2D;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class VirtualSequence
extends Sequence {
    private final IcyBufferedImage image;
    private final VolumetricImage volumetricImage;
    private final int minZ;
    private final int maxZ;
    private final int sizeZ;
    private final int sizeT;
    private int previousT = -1;
    private int previousZ = -1;
    private final int sizeX;
    private final int sizeY;
    private final DimensionArrangement arrangement;
    private final int sizeC;
    private final IterableIntervalProjector2D[] projectors;

    public VirtualSequence(RandomAccessibleInterval<?> source, DimensionArrangement arrangement) {
        super(source.toString() + " - " + (Object)((Object)arrangement));
        DataType dataType;
        boolean signed;
        Converter converter;
        AbstractRealType type;
        this.arrangement = arrangement;
        if (source.numDimensions() != arrangement.numDimensions()) {
            throw new IllegalArgumentException("Source does not have the same dimensionality that of the declared dimension arrangment. Expected " + arrangement.numDimensions() + " but got " + source.numDimensions() + ".");
        }
        this.sizeX = (int)source.dimension(0);
        this.sizeY = (int)source.dimension(1);
        if (arrangement.hasZ) {
            this.minZ = (int)source.min(arrangement.dimZ);
            this.maxZ = (int)source.max(arrangement.dimZ);
            this.sizeZ = (int)source.dimension(arrangement.dimZ);
        } else {
            this.minZ = 0;
            this.maxZ = 0;
            this.sizeZ = 1;
        }
        this.sizeT = arrangement.hasT ? (int)source.dimension(arrangement.dimT) : 1;
        this.sizeC = arrangement.hasC ? (int)source.dimension(arrangement.dimC) : 1;
        Type rawType = (Type)Util.getTypeFromInterval(source);
        if (!(rawType instanceof NativeType)) {
            throw new IllegalArgumentException("Non-native types are unsupported, got : " + rawType);
        }
        NativeType rt = (NativeType)rawType;
        if (rt instanceof UnsignedByteType) {
            type = new UnsignedByteType();
            converter = new RealUnsignedByteConverter(0.0, 255.0);
            signed = false;
            dataType = DataType.UBYTE;
        } else if (rt instanceof UnsignedShortType) {
            type = new UnsignedShortType();
            converter = new RealUnsignedShortConverter(0.0, 65535.0);
            signed = false;
            dataType = DataType.USHORT;
        } else if (rt instanceof FloatType) {
            type = new FloatType();
            converter = new RealFloatConverter();
            signed = false;
            dataType = DataType.FLOAT;
        } else {
            throw new IllegalArgumentException("Unsupported data type: " + rt);
        }
        RandomAccessibleInterval<?> rai = Views.isZeroMin(source) ? source : Views.zeroMin(source);
        this.projectors = new IterableIntervalProjector2D[this.sizeC];
        if (arrangement.hasC) {
            this.image = new IcyBufferedImage(this.sizeX, this.sizeY, this.sizeC, dataType);
            for (int c = 0; c < this.sizeC; ++c) {
                ArrayImg<AbstractRealType, Object[]> img;
                long[] targetDims = new long[]{this.sizeX, this.sizeY};
                switch (dataType) {
                    case FLOAT: {
                        img = ArrayImgs.floats(this.image.getDataXYAsFloat(c), targetDims);
                        break;
                    }
                    case UBYTE: {
                        img = ArrayImgs.unsignedBytes(this.image.getDataXYAsByte(c), targetDims);
                        break;
                    }
                    case USHORT: {
                        img = ArrayImgs.unsignedShorts(this.image.getDataXYAsShort(c), targetDims);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported data type: " + dataType);
                    }
                }
                IntervalView<?> slice = Views.hyperSlice(rai, arrangement.dimC, (long)c);
                IterableIntervalProjector2D projector = new IterableIntervalProjector2D(0, 1, slice, img, converter);
                projector.map();
                this.projectors[c] = projector;
            }
        } else {
            NativeImg img = new ArrayImgFactory().create(new long[]{this.sizeX, this.sizeY}, (NativeType)((Object)type));
            IterableIntervalProjector2D projector = new IterableIntervalProjector2D(0, 1, rai, img, converter);
            projector.map();
            this.projectors[0] = projector;
            Object data = ((ArrayDataAccess)((ArrayImg)img).update(null)).getCurrentStorageArray();
            this.image = new IcyBufferedImage(this.sizeX, this.sizeY, data, signed);
        }
        this.onImageAdded(this.image);
        this.volumetricImage = new VirtualVolumetricImage();
    }

    public IcyBufferedImage getImage(int t, int z) {
        if (this.previousT != t || this.previousZ != z) {
            for (IterableIntervalProjector2D projector : this.projectors) {
                projector.setPosition(z, this.arrangement.targetDimZ);
                projector.setPosition(t, this.arrangement.targetDimT);
                projector.map();
            }
            this.previousT = t;
            this.previousZ = z;
        }
        return this.image;
    }

    public VolumetricImage getVolumetricImage(int t) {
        if (t != this.previousT) {
            for (IterableIntervalProjector2D projector : this.projectors) {
                projector.setPosition(t, this.arrangement.targetDimT);
                projector.map();
            }
            this.previousT = t;
        }
        return this.volumetricImage;
    }

    public int getSizeT() {
        return this.sizeT;
    }

    public int getSizeZ() {
        return this.sizeZ;
    }

    public int getSizeZ(int t) {
        return this.sizeZ;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public ArrayList<IcyBufferedImage> getAllImage() {
        throw new UnsupportedOperationException("VirtualSequence cannot return a collection of its content.");
    }

    public ArrayList<VolumetricImage> getAllVolumetricImage() {
        throw new UnsupportedOperationException("VirtualSequence cannot return a collection of its content.");
    }

    public IcyBufferedImage getRef() {
        return this.image;
    }

    public static enum DimensionArrangement {
        XY(false, false, false, 0, 0, 0, 0, 0),
        XYC(true, false, false, 0, 0, 0, 0, 0),
        XYZ(false, true, false, 0, 2, 2, 0, 0),
        XYT(false, false, true, 0, 0, 0, 2, 2),
        XYCT(true, false, true, 2, 0, 0, 3, 2),
        XYCZ(true, true, false, 2, 3, 2, 0, 0),
        XYZT(false, true, true, 0, 2, 2, 3, 3),
        XYCZT(true, true, true, 2, 3, 2, 4, 3);

        private final boolean hasZ;
        private final int dimZ;
        private final int targetDimZ;
        private final boolean hasT;
        private final int dimT;
        private final int targetDimT;
        private final boolean hasC;
        private final int dimC;

        private DimensionArrangement(boolean hasC, boolean hasZ, boolean hasT, int dimC, int dimZ, int targetDimZ, int dimT, int targetDimT) {
            this.hasC = hasC;
            this.hasZ = hasZ;
            this.hasT = hasT;
            this.dimC = dimC;
            this.dimZ = dimZ;
            this.targetDimZ = targetDimZ;
            this.dimT = dimT;
            this.targetDimT = targetDimT;
        }

        public int numDimensions() {
            int ndims = 2;
            if (this.hasC) {
                ++ndims;
            }
            if (this.hasZ) {
                ++ndims;
            }
            if (this.hasT) {
                ++ndims;
            }
            return ndims;
        }

        public DimensionArrangement dropC() {
            switch (this.ordinal()) {
                case 1: {
                    return XY;
                }
                case 4: {
                    return XYT;
                }
                case 5: {
                    return XYZ;
                }
                case 7: {
                    return XYZT;
                }
            }
            return this;
        }

        public DimensionArrangement dropZ() {
            switch (this.ordinal()) {
                case 2: {
                    return XY;
                }
                case 5: {
                    return XYC;
                }
                case 6: {
                    return XYT;
                }
                case 7: {
                    return XYCT;
                }
            }
            return this;
        }

        public DimensionArrangement dropT() {
            switch (this.ordinal()) {
                case 3: {
                    return XY;
                }
                case 4: {
                    return XYC;
                }
                case 6: {
                    return XYT;
                }
                case 7: {
                    return XYCZ;
                }
            }
            return this;
        }
    }

    private class VirtualVolumetricImage
    extends VolumetricImage {
        private VirtualVolumetricImage() {
        }

        public ArrayList<IcyBufferedImage> getAllImage() {
            throw new UnsupportedOperationException("VirtualVolumetricImage cannot return a collection of its content.");
        }

        public TreeMap<Integer, IcyBufferedImage> getImages() {
            throw new UnsupportedOperationException("VirtualVolumetricImage cannot return a collection of its content.");
        }

        public IcyBufferedImage getImage(int z) {
            if (VirtualSequence.this.previousZ != z) {
                for (IterableIntervalProjector2D projector : VirtualSequence.this.projectors) {
                    projector.setPosition(z, VirtualSequence.this.arrangement.targetDimZ);
                    projector.map();
                }
                VirtualSequence.this.previousZ = z;
            }
            return VirtualSequence.this.image;
        }

        public IcyBufferedImage getFirstImage() {
            return this.getImage(VirtualSequence.this.minZ);
        }

        public IcyBufferedImage getLastImage() {
            return this.getImage(VirtualSequence.this.maxZ);
        }

        public int getNumImage() {
            return VirtualSequence.this.sizeZ;
        }

        public int getSize() {
            return VirtualSequence.this.sizeZ;
        }

        public void clear() {
            throw new UnsupportedOperationException("VirtualVolumetricImage cannot clear its content.");
        }

        public void setImage(int z, IcyBufferedImage image) {
            throw new UnsupportedOperationException("VirtualVolumetricImage cannot set its content.");
        }

        public boolean isEmpty() {
            return VirtualSequence.this.sizeZ < 1;
        }

        public boolean removeImage(int z) {
            throw new UnsupportedOperationException("VirtualVolumetricImage cannot remove an image from its content.");
        }

        public void pack() {
        }
    }
}

