/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame.progress;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.progress.TaskFrame;
import icy.gui.util.GuiUtil;
import icy.network.NetworkUtil;
import icy.preferences.GeneralPreferences;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class ToolTipFrame
extends TaskFrame {
    Timer timer;
    JEditorPane editorPane;
    JCheckBox doNotDisplayCheckbox;
    final int liveTime;
    final String id;

    public ToolTipFrame(final String message, int liveTime, String id) {
        this.liveTime = liveTime;
        this.id = id;
        if (this.headless) {
            return;
        }
        if (!(StringUtil.isEmpty(id) || GeneralPreferences.getPreferencesToolTips().getBoolean(id, true) && !this.alreadyExist(id))) {
            this.close();
            return;
        }
        if (liveTime != 0) {
            this.timer = new Timer("ToolTip timer");
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ToolTipFrame.this.doClose();
                }
            }, liveTime * 1000);
        }
        ThreadUtil.invokeLater(new Runnable(){
            final /* synthetic */ ToolTipFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.editorPane = new JEditorPane("text/html", message);
                this.this$0.editorPane.setMinimumSize(new Dimension(240, 60));
                this.this$0.editorPane.setEditable(false);
                this.this$0.editorPane.setToolTipText("Click to close the tool tip");
                Font font = UIManager.getFont("Label.font");
                String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
                ((HTMLDocument)this.this$0.editorPane.getDocument()).getStyleSheet().addRule(bodyRule);
                this.this$0.editorPane.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        this$0.doClose();
                    }
                });
                this.this$0.editorPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            NetworkUtil.openBrowser(e.getURL());
                        }
                    }
                });
                this.this$0.doNotDisplayCheckbox = new JCheckBox("Do not display again", false);
                this.this$0.doNotDisplayCheckbox.setToolTipText("Do not display this tooltip the next time");
                this.this$0.mainPanel.setLayout(new BorderLayout());
                this.this$0.mainPanel.add((Component)this.this$0.editorPane, "Center");
                if (!StringUtil.isEmpty(this.this$0.id)) {
                    this.this$0.mainPanel.add((Component)GuiUtil.createLineBoxPanel(this.this$0.doNotDisplayCheckbox, Box.createHorizontalGlue()), "South");
                }
                this.this$0.pack();
            }
        });
    }

    public ToolTipFrame(String message, String id) {
        this(message, 0, id);
    }

    public ToolTipFrame(String message, int liveTime) {
        this(message, liveTime, "");
    }

    public ToolTipFrame(String message) {
        this(message, 0, "");
    }

    private boolean alreadyExist(String id) {
        ArrayList<IcyFrame> frames = IcyFrame.getAllFrames(ToolTipFrame.class);
        for (IcyFrame f : frames) {
            if (f == this || !((ToolTipFrame)f).id.equals(id)) continue;
            return true;
        }
        return false;
    }

    void doClose() {
        if (!StringUtil.isEmpty(this.id) && this.doNotDisplayCheckbox.isSelected()) {
            GeneralPreferences.getPreferencesToolTips().putBoolean(this.id, false);
        }
        this.close();
    }

    public void setText(final String text) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invokeLater(new Runnable(){
            final /* synthetic */ ToolTipFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.editorPane.setText(text);
                this.this$0.pack();
            }
        });
    }

    @Override
    public void internalClose() {
        if (this.headless) {
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        super.internalClose();
    }
}

