/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.component.IcyTable;
import icy.gui.component.IcyTextField;
import icy.gui.plugin.PluginDetailPanel;
import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.PreferencePanel;
import icy.gui.util.ComponentUtil;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.preferences.RepositoryPreferences;
import icy.resource.ResourceUtil;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class PluginListPreferencePanel
extends PreferencePanel
implements IcyTextField.TextChangeListener,
ListSelectionListener {
    private static final long serialVersionUID = -2718763355377652489L;
    static final String[] columnNames = new String[]{"", "Name", "Version", "State", "Enabled"};
    static final String[] columnIds = new String[]{"Icon", "Name", "Version", "State", "Enabled"};
    List<PluginDescriptor> plugins = new ArrayList<PluginDescriptor>();
    final AbstractTableModel tableModel;
    final JTable table;
    final JComboBox repository;
    final JPanel repositoryPanel;
    final IcyTextField filter;
    final JButton refreshButton;
    final JButton documentationButton;
    final JButton detailButton;
    final JButton action1Button;
    final JButton action2Button;
    private final Runnable buttonsStateUpdater = new Runnable(){

        @Override
        public void run() {
            ThreadUtil.invokeNow(new Runnable(){

                @Override
                public void run() {
                    PluginListPreferencePanel.this.updateButtonsStateInternal();
                }
            });
        }
    };
    private final Runnable tableDataRefresher = new Runnable(){

        @Override
        public void run() {
            ThreadUtil.invokeNow(new Runnable(){

                @Override
                public void run() {
                    PluginListPreferencePanel.this.refreshTableDataInternal();
                }
            });
        }
    };
    private final Runnable pluginsListRefresher = new Runnable(){

        @Override
        public void run() {
            PluginListPreferencePanel.this.refreshPluginsInternal();
        }
    };
    private final Runnable repositoriesUpdater = new Runnable(){

        @Override
        public void run() {
            ThreadUtil.invokeNow(new Runnable(){

                @Override
                public void run() {
                    PluginListPreferencePanel.this.updateRepositoriesInternal();
                }
            });
        }
    };
    final ActionListener repositoryActionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginListPreferencePanel.this.repositoryChanged();
        }
    };

    PluginListPreferencePanel(PreferenceFrame parent, String nodeName, String parentName) {
        super(parent, nodeName, parentName);
        this.repository = new JComboBox();
        this.repository.setToolTipText("Select a repository");
        this.repository.addActionListener(this.repositoryActionListener);
        this.repositoryPanel = new JPanel();
        this.repositoryPanel.setLayout(new BoxLayout(this.repositoryPanel, 3));
        this.repositoryPanel.setVisible(false);
        JPanel internalRepPanel = new JPanel();
        internalRepPanel.setLayout(new BoxLayout(internalRepPanel, 2));
        internalRepPanel.add(new JLabel("Repository :"));
        internalRepPanel.add(Box.createHorizontalStrut(8));
        internalRepPanel.add(this.repository);
        internalRepPanel.add(Box.createHorizontalGlue());
        this.repositoryPanel.add(internalRepPanel);
        this.repositoryPanel.add(Box.createVerticalStrut(8));
        this.filter = new IcyTextField();
        this.filter.addTextChangeListener(this);
        Dimension buttonsDim = new Dimension(100, 24);
        this.refreshButton = new JButton("Reload list");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginListPreferencePanel.this.reloadPlugins();
            }
        });
        ComponentUtil.setFixedSize(this.refreshButton, buttonsDim);
        this.documentationButton = new JButton("Online doc");
        this.documentationButton.setToolTipText("Open the online documentation");
        this.documentationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<PluginDescriptor> selectedPlugins = PluginListPreferencePanel.this.getSelectedPlugins();
                if (selectedPlugins.size() == 1) {
                    NetworkUtil.openBrowser(selectedPlugins.get(0).getWeb());
                }
            }
        });
        ComponentUtil.setFixedSize(this.documentationButton, buttonsDim);
        this.detailButton = new JButton("Show detail");
        this.detailButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<PluginDescriptor> selectedPlugins = PluginListPreferencePanel.this.getSelectedPlugins();
                if (selectedPlugins.size() == 1) {
                    new PluginDetailPanel(selectedPlugins.get(0));
                }
            }
        });
        ComponentUtil.setFixedSize(this.detailButton, buttonsDim);
        this.action1Button = new JButton("null");
        this.action1Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginListPreferencePanel.this.doAction1();
            }
        });
        this.action1Button.setVisible(false);
        ComponentUtil.setFixedSize(this.action1Button, buttonsDim);
        this.action2Button = new JButton("null");
        this.action2Button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginListPreferencePanel.this.doAction2();
            }
        });
        this.action2Button.setVisible(false);
        ComponentUtil.setFixedSize(this.action2Button, buttonsDim);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 8, 8));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 3));
        buttonsPanel.add(this.refreshButton);
        buttonsPanel.add(Box.createVerticalStrut(34));
        buttonsPanel.add(this.documentationButton);
        buttonsPanel.add(Box.createVerticalStrut(8));
        buttonsPanel.add(this.detailButton);
        buttonsPanel.add(Box.createVerticalStrut(8));
        buttonsPanel.add(this.action1Button);
        buttonsPanel.add(Box.createVerticalStrut(8));
        buttonsPanel.add(this.action2Button);
        buttonsPanel.add(Box.createVerticalStrut(8));
        buttonsPanel.add(Box.createVerticalGlue());
        this.tableModel = new AbstractTableModel(){
            private static final long serialVersionUID = -8573364273165723214L;

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public String getColumnName(int column) {
                return columnNames[column];
            }

            @Override
            public int getRowCount() {
                return PluginListPreferencePanel.this.plugins.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (row < PluginListPreferencePanel.this.plugins.size()) {
                    PluginDescriptor plugin = PluginListPreferencePanel.this.plugins.get(row);
                    switch (column) {
                        case 0: {
                            if (plugin.isIconLoaded()) {
                                return ResourceUtil.scaleIcon(plugin.getIcon(), 32);
                            }
                            PluginListPreferencePanel.this.loadIconAsync(plugin);
                            return ResourceUtil.scaleIcon(PluginDescriptor.DEFAULT_ICON, 32);
                        }
                        case 1: {
                            return plugin.getName();
                        }
                        case 2: {
                            return plugin.getVersion().toString();
                        }
                        case 3: {
                            return PluginListPreferencePanel.this.getStateValue(plugin);
                        }
                        case 4: {
                            return PluginListPreferencePanel.this.isActive(plugin);
                        }
                    }
                }
                return "";
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (rowIndex < PluginListPreferencePanel.this.plugins.size()) {
                    PluginDescriptor plugin = PluginListPreferencePanel.this.plugins.get(rowIndex);
                    if (columnIndex == 4 && aValue instanceof Boolean) {
                        PluginListPreferencePanel.this.setActive(plugin, (Boolean)aValue);
                    }
                }
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 4;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return ImageIcon.class;
                    }
                    case 4: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        this.table = new IcyTable(this.tableModel);
        TableColumnModel colModel = this.table.getColumnModel();
        TableColumn col = colModel.getColumn(0);
        col.setIdentifier(columnIds[0]);
        col.setMinWidth(32);
        col.setPreferredWidth(32);
        col.setMaxWidth(32);
        col = colModel.getColumn(1);
        col.setIdentifier(columnIds[1]);
        col.setMinWidth(120);
        col.setPreferredWidth(200);
        col.setMaxWidth(500);
        col = colModel.getColumn(2);
        col.setIdentifier(columnIds[2]);
        col.setMinWidth(60);
        col.setPreferredWidth(60);
        col.setMaxWidth(60);
        col = colModel.getColumn(3);
        col.setIdentifier(columnIds[3]);
        col.setMinWidth(70);
        col.setPreferredWidth(90);
        col.setMaxWidth(120);
        col = colModel.getColumn(4);
        col.setIdentifier(columnIds[4]);
        col.setMinWidth(60);
        col.setPreferredWidth(60);
        col.setMaxWidth(60);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setRowHeight(32);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setShowVerticalLines(false);
        this.table.setAutoCreateRowSorter(true);
        this.table.getRowSorter().toggleSortOrder(1);
        this.table.setAutoResizeMode(4);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (!me.isConsumed() && me.getClickCount() == 2) {
                    PluginListPreferencePanel.this.detailButton.doClick();
                    me.consume();
                }
            }
        });
        JPanel tableTopPanel = new JPanel();
        tableTopPanel.setLayout(new BoxLayout(tableTopPanel, 3));
        tableTopPanel.add(Box.createVerticalStrut(2));
        tableTopPanel.add(this.repositoryPanel);
        tableTopPanel.add(this.filter);
        tableTopPanel.add(Box.createVerticalStrut(8));
        tableTopPanel.add(this.table.getTableHeader());
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        tablePanel.add((Component)tableTopPanel, "North");
        tablePanel.add((Component)new JScrollPane(this.table), "Center");
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)tablePanel, "Center");
        this.mainPanel.add((Component)buttonsPanel, "East");
        this.mainPanel.validate();
    }

    protected void loadIconAsync(final PluginDescriptor plugin) {
        ThreadUtil.bgRun(new Runnable(){
            final /* synthetic */ PluginListPreferencePanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                if (plugin.loadIcon()) {
                    this.this$0.refreshTableData();
                }
            }
        });
    }

    @Override
    protected void closed() {
        super.closed();
        this.plugins.clear();
    }

    private List<PluginDescriptor> filterList(List<PluginDescriptor> list, String filter) {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        boolean empty = StringUtil.isEmpty(filter, true);
        String filterUp = !empty ? filter.toUpperCase() : "";
        for (PluginDescriptor plugin : list) {
            String classname = plugin.getClassName().toUpperCase();
            String name = plugin.getName().toUpperCase();
            String desc = plugin.getDescription().toUpperCase();
            if (!empty && classname.indexOf(filterUp) == -1 && name.indexOf(filterUp) == -1 && desc.indexOf(filterUp) == -1) continue;
            result.add(plugin);
        }
        return result;
    }

    protected boolean isActive(PluginDescriptor plugin) {
        return false;
    }

    protected void setActive(PluginDescriptor plugin, boolean value) {
    }

    protected abstract void doAction1();

    protected abstract void doAction2();

    protected abstract void repositoryChanged();

    protected abstract void reloadPlugins();

    protected abstract String getStateValue(PluginDescriptor var1);

    protected abstract List<PluginDescriptor> getPlugins();

    protected int getPluginTableIndex(int rowIndex) {
        if (rowIndex == -1) {
            return rowIndex;
        }
        try {
            return this.table.convertRowIndexToView(rowIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return -1;
        }
    }

    protected int getPluginIndex(PluginDescriptor plugin) {
        return this.plugins.indexOf(plugin);
    }

    protected int getPluginModelIndex(PluginDescriptor plugin) {
        return this.getPluginIndex(plugin);
    }

    protected int getPluginTableIndex(PluginDescriptor plugin) {
        return this.getPluginTableIndex(this.getPluginModelIndex(plugin));
    }

    protected int getPluginIndex(String pluginClassName) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            PluginDescriptor plugin = this.plugins.get(i);
            if (!plugin.getClassName().equals(pluginClassName)) continue;
            return i;
        }
        return -1;
    }

    protected int getPluginModelIndex(String pluginClassName) {
        return this.getPluginIndex(pluginClassName);
    }

    protected int getPluginTableIndex(String pluginClassName) {
        return this.getPluginTableIndex(this.getPluginModelIndex(pluginClassName));
    }

    List<PluginDescriptor> getSelectedPlugins() {
        ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return result;
        }
        List<PluginDescriptor> cachedPlugins = this.plugins;
        for (int i = 0; i < rows.length; ++i) {
            try {
                int index = this.table.convertRowIndexToModel(rows[i]);
                if (index >= cachedPlugins.size()) continue;
                result.add(cachedPlugins.get(index));
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSelectedPlugins(HashSet<PluginDescriptor> newSelected) {
        List<PluginDescriptor> modelPlugins = this.plugins;
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        try {
            selectionModel.clearSelection();
            for (int i = 0; i < modelPlugins.size(); ++i) {
                PluginDescriptor plugin = modelPlugins.get(i);
                if (!newSelected.contains(plugin)) continue;
                try {
                    int ind = this.table.convertRowIndexToView(i);
                    if (ind == -1) continue;
                    selectionModel.addSelectionInterval(ind, ind);
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        finally {
            selectionModel.setValueIsAdjusting(false);
        }
    }

    protected void refreshPluginsInternal() {
        this.plugins = this.filterList(this.getPlugins(), this.filter.getText());
        this.refreshTableData();
    }

    protected final void refreshPlugins() {
        ThreadUtil.runSingle(this.pluginsListRefresher);
    }

    protected void updateButtonsStateInternal() {
        List<PluginDescriptor> selectedPlugins = this.getSelectedPlugins();
        boolean singleSelection = selectedPlugins.size() == 1;
        PluginDescriptor singlePlugin = singleSelection ? selectedPlugins.get(0) : null;
        this.detailButton.setEnabled(singleSelection);
        this.documentationButton.setEnabled(singleSelection && !StringUtil.isEmpty(singlePlugin.getWeb()));
    }

    protected final void updateButtonsState() {
        ThreadUtil.runSingle(this.buttonsStateUpdater);
    }

    protected void updateRepositoriesInternal() {
        ArrayList<RepositoryPreferences.RepositoryInfo> repositeries = RepositoryPreferences.getRepositeries();
        RepositoryPreferences.RepositoryInfo savedRepository = (RepositoryPreferences.RepositoryInfo)this.repository.getSelectedItem();
        this.repository.removeActionListener(this.repositoryActionListener);
        this.repository.removeAllItems();
        for (RepositoryPreferences.RepositoryInfo repos : repositeries) {
            if (!repos.isEnabled()) continue;
            this.repository.addItem(repos);
        }
        this.repository.addActionListener(this.repositoryActionListener);
        boolean selected = false;
        if (savedRepository != null) {
            String repositoryName = savedRepository.getName();
            for (int ind = 0; ind < this.repository.getItemCount(); ++ind) {
                RepositoryPreferences.RepositoryInfo repo = (RepositoryPreferences.RepositoryInfo)this.repository.getItemAt(ind);
                if (repo == null || !repo.getName().equals(repositoryName)) continue;
                this.repository.setSelectedIndex(ind);
                selected = true;
                break;
            }
        }
        if (!selected) {
            this.repository.setSelectedIndex(this.repository.getItemCount() > 0 ? 0 : -1);
        }
        this.repository.setMinimumSize(new Dimension(48, 18));
    }

    protected final void updateRepositories() {
        ThreadUtil.runSingle(this.repositoriesUpdater);
    }

    protected void refreshTableDataInternal() {
        List<PluginDescriptor> plugins = this.getSelectedPlugins();
        try {
            this.tableModel.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setSelectedPlugins(new HashSet<PluginDescriptor>(plugins));
        this.buttonsStateUpdater.run();
    }

    protected final void refreshTableData() {
        ThreadUtil.runSingle(this.tableDataRefresher);
    }

    protected void pluginsChanged() {
        this.refreshPlugins();
    }

    @Override
    protected void load() {
    }

    @Override
    protected void save() {
        this.updateRepositories();
    }

    @Override
    public void textChanged(IcyTextField source, boolean validate) {
        this.pluginsChanged();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selected = this.table.getSelectedRow();
        if (!e.getValueIsAdjusting() && selected != -1) {
            int fi = e.getFirstIndex();
            int li = e.getLastIndex();
            if (fi == -1 || fi <= selected && li >= selected) {
                this.updateButtonsState();
            }
        }
    }
}

