/*
 * Decompiled with CFR 0.152.
 */
package icy.image.lut;

import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.listener.ChangeListener;
import icy.file.xml.XMLPersistent;
import icy.image.colormap.IcyColorMap;
import icy.image.colormodel.IcyColorModel;
import icy.image.colorspace.IcyColorSpace;
import icy.image.colorspace.IcyColorSpaceEvent;
import icy.image.colorspace.IcyColorSpaceListener;
import icy.image.lut.LUTBand;
import icy.image.lut.LUTEvent;
import icy.image.lut.LUTListener;
import icy.math.Scaler;
import icy.math.ScalerEvent;
import icy.math.ScalerListener;
import icy.type.DataType;
import icy.util.XMLUtil;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LUT
implements IcyColorSpaceListener,
ScalerListener,
ChangeListener,
XMLPersistent {
    private static final String ID_NUM_CHANNEL = "numChannel";
    private static final String ID_SCALER = "scaler";
    private static final String ID_COLORMAP = "colormap";
    private List<LUTChannel> lutChannels = new ArrayList<LUTChannel>();
    final IcyColorSpace colorSpace;
    final Scaler[] scalers;
    final int numChannel;
    private boolean enabled = true;
    private final List<LUTListener> listeners;
    private final UpdateEventHandler updater;

    public LUT(IcyColorModel cm) {
        this.colorSpace = cm.getIcyColorSpace();
        this.scalers = cm.getColormapScalers();
        this.numChannel = this.colorSpace.getNumComponents();
        if (this.scalers.length != this.numChannel) {
            throw new IllegalArgumentException("Incorrect size for scalers : " + this.scalers.length + ".  Expected : " + this.numChannel);
        }
        DataType dataType = cm.getDataType_();
        for (int channel = 0; channel < this.numChannel; ++channel) {
            if (dataType == DataType.UBYTE) {
                this.scalers[channel].setLeftRightIn(dataType.getMinValue(), dataType.getMaxValue());
            }
            this.lutChannels.add(new LUTChannel(channel));
        }
        this.listeners = new ArrayList<LUTListener>();
        this.updater = new UpdateEventHandler(this, false);
        for (Scaler scaler : this.scalers) {
            scaler.addListener(this);
        }
        this.colorSpace.addListener(this);
    }

    protected int indexOf(Scaler scaler) {
        for (int i = 0; i < this.scalers.length; ++i) {
            if (this.scalers[i] != scaler) continue;
            return i;
        }
        return -1;
    }

    public IcyColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public Scaler[] getScalers() {
        return this.scalers;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public ArrayList<LUTChannel> getLutChannels() {
        return new ArrayList<LUTChannel>(this.lutChannels);
    }

    public LUTChannel getLutChannel(int channel) {
        return this.lutChannels.get(channel);
    }

    @Deprecated
    public ArrayList<LUTBand> getLutBands() {
        ArrayList<LUTBand> result = new ArrayList<LUTBand>();
        for (LUTChannel lutChannel : this.lutChannels) {
            result.add(new LUTBand(this, lutChannel.getChannel()));
        }
        return result;
    }

    @Deprecated
    public LUTBand getLutBand(int band) {
        return this.getLutBands().get(band);
    }

    public int getNumChannel() {
        return this.numChannel;
    }

    @Deprecated
    public int getNumComponents() {
        return this.getNumChannel();
    }

    public void copyFrom(LUT lut) {
        this.beginUpdate();
        try {
            this.setColorMaps(lut, true);
            this.setScalers(lut);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScalers(LUT lut) {
        Scaler[] srcScalers = lut.getScalers();
        int len = Math.min(this.scalers.length, srcScalers.length);
        this.beginUpdate();
        try {
            for (int i = 0; i < len; ++i) {
                Scaler src = srcScalers[i];
                Scaler dst = this.scalers[i];
                dst.setAbsLeftRightIn(src.getAbsLeftIn(), src.getAbsRightIn());
                dst.setLeftRightIn(src.getLeftIn(), src.getRightIn());
                dst.setLeftRightOut(src.getLeftOut(), src.getRightOut());
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Deprecated
    public void copyScalers(LUT lut) {
        this.setScalers(lut);
    }

    public void setColorMaps(LUT lut, boolean setAlpha) {
        this.getColorSpace().setColorMaps(lut.getColorSpace(), setAlpha);
    }

    @Deprecated
    public void setColormaps(LUT lut) {
        this.setColorMaps(lut, true);
    }

    @Deprecated
    public void copyColormaps(LUT lut) {
        this.setColorMaps(lut, true);
    }

    public void setAlphaToOpaque() {
        this.beginUpdate();
        try {
            for (LUTChannel lutChannel : this.getLutChannels()) {
                if (lutChannel.getColorMap().isAlpha()) continue;
                lutChannel.getColorMap().setAlphaToOpaque();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setAlphaToLinear() {
        this.beginUpdate();
        try {
            for (LUTChannel lutChannel : this.getLutChannels()) {
                lutChannel.getColorMap().setAlphaToLinear();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setAlphaToLinear3D() {
        this.beginUpdate();
        try {
            for (LUTChannel lutChannel : this.getLutChannels()) {
                lutChannel.getColorMap().setAlphaToLinear3D();
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public boolean isCompatible(LUT lut) {
        if (this.numChannel != lut.getNumChannel()) {
            return false;
        }
        Scaler[] cmScalers = lut.getScalers();
        for (int channel = 0; channel < this.numChannel; ++channel) {
            if (this.scalers[channel].isIntegerData() == cmScalers[channel].isIntegerData()) continue;
            return false;
        }
        return true;
    }

    public boolean isCompatible(IcyColorModel colorModel) {
        if (this.numChannel != colorModel.getNumComponents()) {
            return false;
        }
        Scaler[] cmScalers = colorModel.getColormapScalers();
        for (int comp = 0; comp < this.numChannel; ++comp) {
            if (this.scalers[comp].isIntegerData() == cmScalers[comp].isIntegerData()) continue;
            return false;
        }
        return true;
    }

    public void addListener(LUTListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LUTListener listener) {
        this.listeners.remove(listener);
    }

    public void fireLUTChanged(LUTEvent e) {
        for (LUTListener lutListener : new ArrayList<LUTListener>(this.listeners)) {
            lutListener.lutChanged(e);
        }
    }

    @Override
    public void onChanged(CollapsibleEvent compare) {
        LUTChannelEvent.LUTChannelEventType type;
        LUTEvent event = (LUTEvent)compare;
        this.fireLUTChanged(event);
        int channel = event.getComponent();
        LUTChannelEvent.LUTChannelEventType lUTChannelEventType = type = event.getType() == LUTEvent.LUTEventType.COLORMAP_CHANGED ? LUTChannelEvent.LUTChannelEventType.COLORMAP_CHANGED : LUTChannelEvent.LUTChannelEventType.SCALER_CHANGED;
        if (channel == -1) {
            for (LUTChannel lutChannel : this.lutChannels) {
                lutChannel.fireEvent(new LUTChannelEvent(lutChannel, type));
            }
        } else {
            LUTChannel lutChannel = this.getLutChannel(channel);
            lutChannel.fireEvent(new LUTChannelEvent(lutChannel, type));
        }
    }

    @Override
    public void colorSpaceChanged(IcyColorSpaceEvent e) {
        this.updater.changed(new LUTEvent(this, e.getComponent(), LUTEvent.LUTEventType.COLORMAP_CHANGED));
    }

    @Override
    public void scalerChanged(ScalerEvent e) {
        this.updater.changed(new LUTEvent(this, this.indexOf(e.getScaler()), LUTEvent.LUTEventType.SCALER_CHANGED));
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
    }

    public void endUpdate() {
        this.updater.endUpdate();
    }

    public boolean isUpdating() {
        return this.updater.isUpdating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        if (this.numChannel != XMLUtil.getElementIntValue(node, ID_NUM_CHANNEL, 1)) {
            return false;
        }
        this.beginUpdate();
        try {
            for (int ch = 0; ch < this.numChannel; ++ch) {
                Element n = XMLUtil.getElement(node, ID_SCALER + ch);
                if (n != null) {
                    this.scalers[ch].loadFromXML(n);
                }
                if ((n = XMLUtil.getElement(node, ID_COLORMAP + ch)) == null) continue;
                this.colorSpace.getColorMap(ch).loadFromXML(n);
            }
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementIntValue(node, ID_NUM_CHANNEL, this.numChannel);
        for (int ch = 0; ch < this.numChannel; ++ch) {
            Element n = XMLUtil.setElement(node, ID_SCALER + ch);
            if (n != null) {
                this.scalers[ch].saveToXML(n);
            }
            if ((n = XMLUtil.setElement(node, ID_COLORMAP + ch)) == null) continue;
            this.colorSpace.getColorMap(ch).saveToXML(n);
        }
        return true;
    }

    public class LUTChannel {
        private final int channel;
        private final List<LUTChannelListener> channelListeners;

        public LUTChannel(int channel) {
            this.channel = channel;
            this.channelListeners = new ArrayList<LUTChannelListener>();
        }

        public LUT getLut() {
            return LUT.this;
        }

        public void copyFrom(LUTChannel source) {
            this.setColorMap(source.getColorMap(), true);
            this.setScaler(source.getScaler());
        }

        public Scaler getScaler() {
            return LUT.this.getScalers()[this.channel];
        }

        public void setScaler(Scaler source) {
            Scaler scaler = this.getScaler();
            scaler.beginUpdate();
            try {
                scaler.setAbsLeftRightIn(source.getAbsLeftIn(), source.getAbsRightIn());
                scaler.setLeftRightIn(source.getLeftIn(), source.getRightIn());
                scaler.setLeftRightOut(source.getLeftOut(), source.getRightOut());
            }
            finally {
                scaler.endUpdate();
            }
        }

        public IcyColorMap getColorMap() {
            return LUT.this.getColorSpace().getColorMap(this.channel);
        }

        public void setColorMap(IcyColorMap colorMap, boolean setAlpha) {
            LUT.this.getColorSpace().setColorMap(this.channel, colorMap, setAlpha);
        }

        @Deprecated
        public void setColorMap(IcyColorMap colorMap) {
            this.setColorMap(colorMap, true);
        }

        @Deprecated
        public void copyColorMap(IcyColorMap colorMap) {
            this.setColorMap(colorMap, true);
        }

        public double getMin() {
            return this.getScaler().getLeftIn();
        }

        public void setMin(double value) {
            this.getScaler().setLeftIn(value);
        }

        public double getMax() {
            return this.getScaler().getRightIn();
        }

        public void setMax(double value) {
            this.getScaler().setRightIn(value);
        }

        public void setMinMax(double min, double max) {
            this.getScaler().setLeftRightIn(min, max);
        }

        public double getMinBound() {
            return this.getScaler().getAbsLeftIn();
        }

        public double getMaxBound() {
            return this.getScaler().getAbsRightIn();
        }

        public void setMinBound(double value) {
            this.getScaler().setAbsLeftIn(value);
        }

        public void setMaxBound(double value) {
            this.getScaler().setAbsRightIn(value);
        }

        public boolean isEnabled() {
            return this.getColorMap().isEnabled();
        }

        public void setEnabled(boolean value) {
            this.getColorMap().setEnabled(value);
        }

        @Deprecated
        public int getComponent() {
            return this.getChannel();
        }

        public int getChannel() {
            return this.channel;
        }

        public void addListener(LUTChannelListener listener) {
            this.channelListeners.add(listener);
        }

        public void removeListener(LUTChannelListener listener) {
            this.channelListeners.remove(listener);
        }

        public void fireEvent(LUTChannelEvent e) {
            for (LUTChannelListener listener : new ArrayList<LUTChannelListener>(this.channelListeners)) {
                listener.lutChannelChanged(e);
            }
        }
    }

    public static class LUTChannelEvent {
        private final LUTChannel lutChannel;
        private final LUTChannelEventType type;

        public LUTChannelEvent(LUTChannel lutChannel, LUTChannelEventType type) {
            this.lutChannel = lutChannel;
            this.type = type;
        }

        public LUTChannel getLutChannel() {
            return this.lutChannel;
        }

        public LUTChannelEventType getType() {
            return this.type;
        }

        public static enum LUTChannelEventType {
            SCALER_CHANGED,
            COLORMAP_CHANGED;

        }
    }

    public static interface LUTChannelListener
    extends EventListener {
        public void lutChannelChanged(LUTChannelEvent var1);
    }
}

