/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

import icy.type.geom.Line3D;
import icy.type.point.Point3D;
import java.util.Iterator;

public class Line3DIterator
implements Iterator<Point3D> {
    protected static final double DEFAULT_STEP = 1.0;
    protected boolean done;
    protected int count;
    protected final boolean forceLast;
    protected final Point3D pos;
    protected final Point3D last;
    protected double sx;
    protected double sy;
    protected double sz;

    public Line3DIterator(Line3D line, double step, boolean forceLastPoint) {
        double adjStep;
        this.pos = line.getP1();
        this.last = line.getP2();
        this.done = false;
        this.forceLast = forceLastPoint;
        double dx = this.last.getX() - this.pos.getX();
        double dy = this.last.getY() - this.pos.getY();
        double dz = this.last.getZ() - this.pos.getZ();
        double adx = Math.abs(dx);
        double ady = Math.abs(dy);
        double adz = Math.abs(dz);
        double d = adjStep = step <= 0.0 ? 1.0 : step;
        if (adx >= ady && adx >= adz) {
            if (adx == 0.0) {
                this.count = 0;
                this.sy = 0.0;
                this.sz = 0.0;
            } else {
                this.count = (int)(adx / adjStep);
                this.sy = ady / adx * adjStep;
                this.sz = adz / adx * adjStep;
            }
            this.sx = adjStep;
        } else if (ady >= adx && ady >= adz) {
            this.count = (int)(ady / adjStep);
            this.sx = adx / ady * adjStep;
            this.sy = adjStep;
            this.sz = adz / ady * adjStep;
        } else {
            this.count = (int)(adz / adjStep);
            this.sx = adx / adz * adjStep;
            this.sy = ady / adz * adjStep;
            this.sz = adjStep;
        }
        ++this.count;
        if (dx < 0.0) {
            this.sx = -this.sx;
        }
        if (dy < 0.0) {
            this.sy = -this.sy;
        }
        if (dz < 0.0) {
            this.sz = -this.sz;
        }
    }

    public Line3DIterator(Line3D line, double step) {
        this(line, step, true);
    }

    public Line3DIterator(Line3D line) {
        this(line, 1.0, true);
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public Point3D next() {
        Point3D result = (Point3D)this.pos.clone();
        if (--this.count <= 0) {
            if (this.forceLast) {
                this.done = this.pos.equals(this.last);
                this.pos.setLocation(this.last);
            } else {
                this.done = true;
            }
        } else {
            this.pos.setLocation(this.pos.getX() + this.sx, this.pos.getY() + this.sy, this.pos.getZ() + this.sz);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

