/*
 * Decompiled with CFR 0.152.
 */
package icy.roi.edit;

import icy.painter.Anchor2D;
import icy.roi.edit.AbstractPoint2DROIEdit;
import java.awt.geom.Point2D;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import plugins.kernel.roi.roi2d.ROI2DShape;

public class Point2DAddedROIEdit
extends AbstractPoint2DROIEdit {
    Point2D position;
    final int index;

    public Point2DAddedROIEdit(ROI2DShape roi, Anchor2D point) {
        super(roi, point, "ROI point added");
        this.position = point.getPosition();
        this.index = roi.getControlPoints().indexOf(point);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        ((ROI2DShape)this.getROI()).removePoint(this.point);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.point.setPosition(this.position);
        ((ROI2DShape)this.getROI()).addPoint(this.point, Math.min(this.index, this.getROI2DShape().getControlPoints().size()));
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        return false;
    }

    @Override
    public void die() {
        super.die();
        this.position = null;
    }
}

