/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom.areax;

import icy.type.geom.areax.AreaX;
import icy.type.geom.areax.ShapeBounds;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class AreaXOperation {
    public static final int ADD = 0;
    public static final int SUBTRACT = 1;
    public static final int XOR = 2;
    public static final int INTERSECT = 3;
    protected final Shape operand;
    protected final int operator;
    Rectangle2D bounds;

    public AreaXOperation(Shape shape, int operator) {
        if (operator != 0 && operator != 1 && operator != 2 && operator != 3) {
            throw new IllegalArgumentException("unrecognized operator (" + operator + ")");
        }
        if (shape == null) {
            throw new NullPointerException();
        }
        this.operand = shape;
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public Shape getOperand() {
        return this.operand;
    }

    public Rectangle2D getBounds() {
        if (this.bounds == null) {
            this.bounds = this.operand instanceof AreaX || this.operand instanceof Area ? this.operand.getBounds2D() : ShapeBounds.getBounds(this.operand);
        }
        return this.bounds;
    }
}

