/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.canvas;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.math.plot.components.DataFrame;
import org.math.plot.components.LegendPanel;
import org.math.plot.components.ScalesFrame;
import org.math.plot.plotObjects.Base;
import org.math.plot.plotObjects.BaseDependant;
import org.math.plot.plotObjects.BaseLabel;
import org.math.plot.plotObjects.BasePlot;
import org.math.plot.plotObjects.Label;
import org.math.plot.plotObjects.Plotable;
import org.math.plot.plots.Plot;
import org.math.plot.render.AWTDrawer;
import org.math.plot.render.AbstractDrawer;
import org.math.plot.utils.Array;
import org.math.plot.utils.FastMath;

public abstract class PlotCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
ComponentListener,
BaseDependant,
MouseWheelListener {
    public Base base;
    protected AbstractDrawer draw;
    protected BasePlot grid;
    public LegendPanel linkedLegendPanel;
    public LinkedList<Plot> plots;
    public LinkedList<Plotable> objects;
    boolean adjustBounds = true;
    JFrame scalesFrame = new ScalesFrame(this);
    DataFrame dataFrame = new DataFrame(this);
    boolean mapset = false;
    HashMap<Double, String>[] reversedMaps;
    protected static final RenderingHints AALIAS = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    public static Color NOTE_COLOR = Color.DARK_GRAY;
    public static Color EDIT_COLOR = Color.BLACK;
    public boolean allowEdit = true;
    public boolean allowNote = true;
    public boolean allowNoteCoord = true;
    public static final int ZOOM = 0;
    public static final int TRANSLATION = 1;
    public int ActionMode;
    protected boolean dragging = false;
    protected int[] mouseCurent = new int[2];
    protected int[] mouseClick = new int[2];
    int[] drawRect = null;
    final Stroke rectStroke = new BasicStroke(1.0f, 1, 2);

    public PlotCanvas() {
        this.initPanel();
        this.initBasenGrid();
        this.initDrawer();
    }

    public PlotCanvas(Base b, BasePlot bp) {
        this.initPanel();
        this.initBasenGrid(b, bp);
        this.initDrawer();
    }

    public PlotCanvas(double[] min, double[] max) {
        this.initPanel();
        this.initBasenGrid(min, max);
        this.initDrawer();
    }

    public PlotCanvas(double[] min, double[] max, String[] axesScales, String[] axesLabels) {
        this.initPanel();
        this.initBasenGrid(min, max, axesScales, axesLabels);
        this.initDrawer();
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public void attachLegend(LegendPanel lp) {
        this.linkedLegendPanel = lp;
    }

    private void initPanel() {
        this.objects = new LinkedList();
        this.plots = new LinkedList();
        this.setDoubleBuffered(true);
        this.setBackground(Color.white);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
    }

    public abstract void initDrawer();

    public void initBasenGrid(double[] min, double[] max, String[] axesScales, String[] axesLabels) {
        this.base = new Base(min, max, axesScales);
        this.grid = new BasePlot(this.base, axesLabels);
    }

    public abstract void initBasenGrid(double[] var1, double[] var2);

    public abstract void initBasenGrid();

    public void initBasenGrid(Base b, BasePlot bp) {
        this.base = b;
        this.grid = bp;
    }

    public void setActionMode(int am) {
        this.ActionMode = am;
    }

    public void setNoteCoords(boolean b) {
        this.allowNoteCoord = b;
    }

    public void setEditable(boolean b) {
        this.allowEdit = b;
    }

    public boolean getEditable() {
        return this.allowEdit;
    }

    public void setNotable(boolean b) {
        this.allowNote = b;
    }

    public boolean getNotable() {
        return this.allowNote;
    }

    public LinkedList<Plot> getPlots() {
        return this.plots;
    }

    public Plot getPlot(int i) {
        return this.plots.get(i);
    }

    public int getPlotIndex(Plot p) {
        for (int i = 0; i < this.plots.size(); ++i) {
            if (this.getPlot(i) != p) continue;
            return i;
        }
        return -1;
    }

    public LinkedList<Plotable> getPlotables() {
        return this.objects;
    }

    public Plotable getPlotable(int i) {
        return this.objects.get(i);
    }

    public BasePlot getGrid() {
        return this.grid;
    }

    public String[] getAxisScales() {
        return this.base.getAxesScales();
    }

    public void setAxisLabels(String ... labels) {
        this.grid.setLegend(labels);
        this.repaint();
    }

    public void setAxisLabel(int axe, String label) {
        this.grid.setLegend(axe, label);
        this.repaint();
    }

    public void setAxisScales(String ... scales) {
        this.base.setAxesScales(scales);
        this.setAutoBounds();
    }

    public void setAxiScale(int axe, String scale) {
        this.base.setAxesScales(axe, scale);
        this.setAutoBounds(axe);
    }

    public void setFixedBounds(double[] min, double[] max) {
        this.base.setFixedBounds(min, max);
        this.resetBase();
        this.repaint();
    }

    public void setFixedBounds(int axe, double min, double max) {
        this.base.setFixedBounds(axe, min, max);
        this.resetBase();
        this.repaint();
    }

    public void includeInBounds(double ... into) {
        boolean changed = this.base.includeInBounds(into);
        if (!changed) {
            return;
        }
        this.grid.resetBase();
        this.repaint();
    }

    public void includeInBounds(Plot plot) {
        boolean changed = this.base.includeInBounds(Array.min(plot.getBounds()));
        if (!(changed |= this.base.includeInBounds(Array.max(plot.getBounds())))) {
            return;
        }
        this.resetBase();
        this.repaint();
    }

    public void setAutoBounds() {
        if (this.plots.size() > 0) {
            Plot plot0 = this.getPlot(0);
            this.base.setRoundBounds(Array.min(plot0.getBounds()), Array.max(plot0.getBounds()));
        } else {
            double[] min = new double[this.base.dimension];
            double[] max = new double[this.base.dimension];
            for (int i = 0; i < this.base.dimension; ++i) {
                if (this.base.getAxeScale(i).equalsIgnoreCase("lin")) {
                    min[i] = 0.0;
                    max[i] = 1.0;
                    continue;
                }
                if (!this.base.getAxeScale(i).equalsIgnoreCase("log")) continue;
                min[i] = 1.0;
                max[i] = 10.0;
            }
            this.base.setRoundBounds(min, max);
        }
        for (int i = 1; i < this.plots.size(); ++i) {
            Plot ploti = this.getPlot(i);
            this.base.includeInBounds(Array.min(ploti.getBounds()));
            this.base.includeInBounds(Array.max(ploti.getBounds()));
        }
        this.resetBase();
        this.repaint();
    }

    public void setAutoBounds(int axe) {
        if (this.plots.size() > 0) {
            Plot plot0 = this.getPlot(0);
            this.base.setRoundBounds(axe, Array.min(plot0.getBounds())[axe], Array.max(plot0.getBounds())[axe]);
        } else {
            double min = 0.0;
            double max = 0.0;
            if (this.base.getAxeScale(axe).equalsIgnoreCase("lin") | this.base.getAxeScale(axe).equalsIgnoreCase("str")) {
                min = 0.0;
                max = 1.0;
            } else if (this.base.getAxeScale(axe).equalsIgnoreCase("log")) {
                min = 1.0;
                max = 10.0;
            }
            this.base.setRoundBounds(axe, min, max);
        }
        for (int i = 1; i < this.plots.size(); ++i) {
            Plot ploti = this.getPlot(i);
            this.base.includeInBounds(axe, Array.min(ploti.getBounds())[axe]);
            this.base.includeInBounds(axe, Array.max(ploti.getBounds())[axe]);
        }
        this.resetBase();
        this.repaint();
    }

    @Override
    public void resetBase() {
        this.draw.resetBaseProjection();
        this.grid.resetBase();
        for (int i = 0; i < this.objects.size(); ++i) {
            if (!(this.objects.get(i) instanceof BaseDependant)) continue;
            ((BaseDependant)((Object)this.objects.get(i))).resetBase();
        }
        this.repaint();
    }

    public void addLabel(String text, Color c, double ... where) {
        this.addPlotable(new Label(text, c, where));
    }

    public void addBaseLabel(String text, Color c, double ... where) {
        this.addPlotable(new BaseLabel(text, c, where));
    }

    public void addPlotable(Plotable p) {
        this.objects.add(p);
        this.repaint();
    }

    public void removePlotable(Plotable p) {
        this.objects.remove(p);
        this.repaint();
    }

    public void removePlotable(int i) {
        this.objects.remove(i);
        this.repaint();
    }

    public void removeAllPlotables() {
        this.objects.clear();
        this.repaint();
    }

    public void setAdjustBounds(boolean adjust) {
        this.adjustBounds = adjust;
    }

    public boolean getAdjustBounds() {
        return this.adjustBounds;
    }

    public int addPlot(Plot newPlot) {
        this.plots.add(newPlot);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        if (this.plots.size() == 1) {
            this.setAutoBounds();
        } else if (this.adjustBounds) {
            this.includeInBounds(newPlot);
        } else {
            this.repaint();
        }
        return this.plots.size() - 1;
    }

    public void setPlot(int I, Plot p) {
        this.plots.set(I, p);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        this.repaint();
    }

    public void changePlotData(int I, double[] ... XY) {
        this.getPlot(I).setData(XY);
        if (this.adjustBounds) {
            this.includeInBounds(this.getPlot(I));
        } else {
            this.repaint();
        }
    }

    public void changePlotName(int I, String name) {
        this.getPlot(I).setName(name);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        this.repaint();
    }

    public void changePlotColor(int I, Color c) {
        this.getPlot(I).setColor(c);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        this.repaint();
    }

    public void removePlot(int I) {
        this.plots.remove(I);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        if (this.plots.size() != 0) {
            if (this.adjustBounds) {
                this.setAutoBounds();
            } else {
                this.repaint();
            }
        }
    }

    public void removePlot(Plot p) {
        this.plots.remove(p);
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        if (this.plots.size() != 0 && this.adjustBounds) {
            this.setAutoBounds();
        }
    }

    public void removeAllPlots() {
        this.plots.clear();
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.updateLegends();
        }
        this.clearNotes();
    }

    public void addVectortoPlot(int numPlot, double[][] v) {
        this.getPlot(numPlot).addVector(v);
    }

    public void addQuantiletoPlot(int numPlot, int numAxe, double rate, boolean symetric, double[] q) {
        this.getPlot(numPlot).addQuantile(numAxe, rate, q, symetric);
    }

    public void addQuantiletoPlot(int numPlot, int numAxe, double rate, boolean symetric, double q) {
        this.getPlot(numPlot).addQuantile(numAxe, rate, q, symetric);
    }

    public void addQuantilestoPlot(int numPlot, int numAxe, double[][] q) {
        this.getPlot(numPlot).addQuantiles(numAxe, q);
    }

    public void addQuantilestoPlot(int numPlot, int numAxe, double[] q) {
        this.getPlot(numPlot).addQuantiles(numAxe, q);
    }

    public void addGaussQuantilestoPlot(int numPlot, int numAxe, double[] s) {
        this.getPlot(numPlot).addGaussQuantiles(numAxe, s);
    }

    public void addGaussQuantilestoPlot(int numPlot, int numAxe, double s) {
        this.getPlot(numPlot).addGaussQuantiles(numAxe, s);
    }

    public void toGraphicFile(File file) throws IOException {
        Image image = this.createImage(this.getWidth(), this.getHeight());
        this.paint(image.getGraphics());
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufferedImage.createGraphics();
        g.drawImage(image, 0, 0, Color.WHITE, null);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setScalesFrame(JFrame scalesFrame) {
        this.scalesFrame = scalesFrame;
    }

    public void displayScalesFrame() {
        this.scalesFrame.setVisible(true);
    }

    public void setDataFrame(DataFrame dataFrame) {
        this.dataFrame = dataFrame;
    }

    public void displayDataFrame(int i) {
        this.dataFrame.selectIndex(i);
    }

    public void displayDataFrame() {
        this.displayDataFrame(0);
    }

    public void resetMapData() {
        for (int i = 0; i < this.grid.getAxis().length; ++i) {
            this.grid.getAxis()[i].setStringMap(null);
            this.setAxiScale(i, "lin");
        }
        this.mapset = false;
    }

    public double[][] mapData(Object[][] data) {
        double[][] mapeddata = new double[data.length][data[0].length];
        if (!this.mapset) {
            for (int j = 0; j < data[0].length; ++j) {
                if (!Array.isDouble(data[0][j].toString())) {
                    int i;
                    this.setAxiScale(j, "str");
                    ArrayList<String> string_array_j = new ArrayList<String>(data.length);
                    for (i = 0; i < data.length; ++i) {
                        string_array_j.add(data[i][j].toString());
                    }
                    this.grid.getAxis(j).setStringMap(Array.mapStringArray(string_array_j));
                    this.grid.getAxis(j).init();
                    for (i = 0; i < data.length; ++i) {
                        mapeddata[i][j] = this.grid.getAxis(j).getStringMap().get(data[i][j].toString());
                    }
                    this.initReverseMap(j);
                    continue;
                }
                for (int i = 0; i < data.length; ++i) {
                    mapeddata[i][j] = Double.valueOf(data[i][j].toString());
                }
            }
            this.mapset = true;
        } else {
            for (int j = 0; j < data[0].length; ++j) {
                int i;
                if (!Array.isDouble(data[0][j].toString())) {
                    if (this.base.getAxeScale(j).equals("str")) {
                        for (i = 0; i < data.length; ++i) {
                            if (!this.grid.getAxis(j).getStringMap().containsKey(data[i][j].toString())) {
                                Set<String> s = this.grid.getAxis(j).getStringMap().keySet();
                                ArrayList<String> string_array_j = new ArrayList<String>(s.size() + 1);
                                string_array_j.addAll(s);
                                string_array_j.add(data[i][j].toString());
                                this.grid.getAxis(j).setStringMap(Array.mapStringArray(string_array_j));
                                this.initReverseMap(j);
                            }
                            mapeddata[i][j] = this.grid.getAxis(j).getStringMap().get(data[i][j].toString());
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("The mapping of this PlotPanel was not set on axis " + j);
                }
                for (i = 0; i < data.length; ++i) {
                    mapeddata[i][j] = Double.valueOf(data[i][j].toString());
                }
            }
        }
        return mapeddata;
    }

    public Object[][] reverseMapedData(double[][] mapeddata) {
        Object[][] stringdata = new Object[mapeddata.length][mapeddata[0].length];
        for (int i = 0; i < mapeddata.length; ++i) {
            stringdata[i] = this.reverseMapedData(mapeddata[i]);
        }
        return stringdata;
    }

    public Object[] reverseMapedData(double[] mapeddata) {
        Object[] stringdata = new Object[mapeddata.length];
        if (this.reversedMaps == null) {
            this.reversedMaps = new HashMap[this.grid.getAxis().length];
        }
        for (int j = 0; j < mapeddata.length; ++j) {
            stringdata[j] = this.reversedMaps[j] != null ? this.reversedMaps[j].get(mapeddata[j]) : Double.valueOf(mapeddata[j]);
        }
        return stringdata;
    }

    private void initReverseMap(int j) {
        if (this.reversedMaps == null) {
            this.reversedMaps = new HashMap[this.grid.getAxis().length];
        }
        if (this.grid.getAxis(j) != null) {
            this.reversedMaps[j] = Array.reverseStringMap(this.grid.getAxis(j).getStringMap());
        }
    }

    @Override
    public void paint(Graphics gcomp) {
        int i;
        Graphics2D gcomp2D = (Graphics2D)gcomp;
        gcomp2D.addRenderingHints(AALIAS);
        gcomp2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        gcomp2D.setColor(this.getBackground());
        gcomp2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.draw.initGraphics(gcomp2D);
        this.grid.plot(this.draw);
        for (i = 0; i < this.plots.size(); ++i) {
            this.getPlot(i).plot(this.draw);
            if (this.linkedLegendPanel == null) continue;
            this.linkedLegendPanel.nonote(i);
        }
        for (i = 0; i < this.objects.size(); ++i) {
            this.getPlotable(i).plot(this.draw);
        }
        if (this.drawRect != null) {
            gcomp2D.setColor(Color.black);
            gcomp2D.setStroke(this.rectStroke);
            gcomp2D.drawRect(this.drawRect[0], this.drawRect[1], this.drawRect[2], this.drawRect[3]);
        }
        if (this.allowNote) {
            for (i = 0; i < this.plots.size(); ++i) {
                if (this.getPlot((int)i).noted) {
                    if (this.linkedLegendPanel != null) {
                        this.linkedLegendPanel.note(i);
                    }
                    this.getPlot(i).note(this.draw);
                }
                if (!this.allowNoteCoord || this.getPlot((int)i).coordNoted == null) continue;
                this.getPlot(i).noteCoord(this.draw, this.getPlot((int)i).coordNoted);
            }
        }
    }

    public void clearNotes() {
        for (int i = 0; i < this.plots.size(); ++i) {
            this.getPlot((int)i).coordNoted = null;
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.dragging = true;
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        switch (this.ActionMode) {
            case 1: {
                this.draw.translate(this.mouseCurent[0] - this.mouseClick[0], this.mouseCurent[1] - this.mouseClick[1]);
                this.mouseClick[0] = this.mouseCurent[0];
                this.mouseClick[1] = this.mouseCurent[1];
                this.repaint();
                break;
            }
            case 0: {
                int x = FastMath.min(this.mouseClick[0], this.mouseCurent[0]);
                int y = FastMath.min(this.mouseClick[1], this.mouseCurent[1]);
                int w = FastMath.abs(this.mouseCurent[0] - this.mouseClick[0]);
                int h = FastMath.abs(this.mouseCurent[1] - this.mouseClick[1]);
                if (this.drawRect == null) {
                    this.drawRect = new int[4];
                }
                this.drawRect[0] = x;
                this.drawRect[1] = y;
                this.drawRect[2] = w;
                this.drawRect[3] = h;
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        switch (this.ActionMode) {
            case 0: {
                if (FastMath.abs(this.mouseCurent[0] - this.mouseClick[0]) > 10 && FastMath.abs(this.mouseCurent[1] - this.mouseClick[1]) > 10) {
                    int[] origin = new int[]{FastMath.min(this.mouseClick[0], this.mouseCurent[0]), FastMath.min(this.mouseClick[1], this.mouseCurent[1])};
                    double[] ratio = new double[]{FastMath.abs((double)(this.mouseCurent[0] - this.mouseClick[0]) / (double)this.getWidth()), FastMath.abs((double)(this.mouseCurent[1] - this.mouseClick[1]) / (double)this.getHeight())};
                    this.draw.dilate(origin, ratio);
                    this.drawRect = null;
                    this.repaint();
                    break;
                }
                this.drawRect = null;
                this.repaint();
            }
        }
        this.dragging = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int i;
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        this.mouseClick[0] = this.mouseCurent[0];
        this.mouseClick[1] = this.mouseCurent[1];
        if (this.allowEdit && e.getModifiers() == 16 && e.getClickCount() > 1) {
            for (i = 0; i < this.grid.getAxis().length; ++i) {
                if (this.grid.getAxis(i).isSelected(this.mouseClick, this.draw) == null) continue;
                this.grid.getAxis(i).edit(this);
                return;
            }
            for (i = 0; i < this.plots.size(); ++i) {
                if (this.getPlot(i).isSelected(this.mouseClick, this.draw) == null) continue;
                this.getPlot(i).edit(this);
                return;
            }
        }
        if (!this.dragging && this.allowNote) {
            for (i = 0; i < this.plots.size(); ++i) {
                double[] _coordNoted = this.getPlot(i).isSelected(this.mouseClick, this.draw);
                if (e.getModifiers() == 16) {
                    if (_coordNoted != null) {
                        this.getPlot((int)i).noted = !this.getPlot((int)i).noted;
                        continue;
                    }
                    this.getPlot((int)i).noted = false;
                    continue;
                }
                if (e.getModifiers() != 4 || _coordNoted == null) continue;
                if (this.getPlot((int)i).coordNoted != null) {
                    boolean alreadyNoted = true;
                    for (int j = 0; j < _coordNoted.length; ++j) {
                        alreadyNoted = alreadyNoted && _coordNoted[j] == this.getPlot((int)i).coordNoted[j];
                    }
                    if (alreadyNoted) {
                        this.getPlot((int)i).coordNoted = null;
                        continue;
                    }
                    this.getPlot((int)i).coordNoted = _coordNoted;
                    continue;
                }
                this.getPlot((int)i).coordNoted = _coordNoted;
            }
            this.repaint();
        } else {
            this.dragging = false;
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        for (int i = 0; i < this.plots.size(); ++i) {
            double[] _coordNoted;
            if (!this.getPlot((int)i).noted || (_coordNoted = this.getPlot(i).isSelected(this.mouseCurent, this.draw)) == null) continue;
            this.getPlot((int)i).coordNoted = _coordNoted;
            this.repaint();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseCurent[0] = e.getX();
        this.mouseCurent[1] = e.getY();
        e.consume();
        if (e.getWheelRotation() == -1) {
            if (Array.max(((AWTDrawer)this.draw).projection.totalScreenRatio) > 0.01) {
                int[] origin = new int[]{this.mouseCurent[0] - this.getWidth() / 3, this.mouseCurent[1] - this.getHeight() / 3};
                double[] ratio = new double[]{0.666, 0.666};
                this.draw.dilate(origin, ratio);
            }
        } else if (Array.max(((AWTDrawer)this.draw).projection.totalScreenRatio) < 1.0) {
            int[] origin = new int[]{(int)((double)this.mouseCurent[0] - (double)this.getWidth() / 1.333), (int)((double)this.mouseCurent[1] - (double)this.getHeight() / 1.333)};
            double[] ratio = new double[]{1.5, 1.5};
            this.draw.dilate(origin, ratio);
        } else {
            ((AWTDrawer)this.draw).projection.initBaseCoordsProjection(true);
        }
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.draw != null) {
            this.draw.resetBaseProjection();
        }
        this.repaint();
        if (this.linkedLegendPanel != null) {
            this.linkedLegendPanel.componentResized(e);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

