/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.render;

import org.math.plot.render.AWTDrawer;
import org.math.plot.utils.FastMath;

public abstract class Projection {
    protected int[][] baseScreenCoords;
    public static double DEFAULT_BORDER = 0.15;
    protected double borderCoeff = 1.0 - 2.0 * DEFAULT_BORDER;
    protected AWTDrawer draw;
    public double[] totalScreenRatio = new double[]{1.0, 1.0};
    public double[] maxScreenRatio = new double[]{1.0, 1.0};
    public double[] minScreenRatio = new double[]{0.01, 0.01};

    public Projection(AWTDrawer _draw) {
        this.draw = _draw;
    }

    public void initBaseCoordsProjection(boolean reset) {
        if (this.baseScreenCoords == null) {
            this.baseScreenCoords = new int[this.draw.canvas.base.baseCoords.length][2];
        }
        if (reset) {
            this.totalScreenRatio[0] = 1.0;
            this.totalScreenRatio[1] = 1.0;
        }
        for (int i = 0; i < this.draw.canvas.base.dimension + 1; ++i) {
            double[] ratio = this.baseCoordsScreenProjectionRatio(this.draw.canvas.base.baseCoords[i]);
            this.baseScreenCoords[i][0] = (int)((double)this.draw.canvas.getWidth() * (0.5 + this.borderCoeff * ratio[0] / this.totalScreenRatio[0]));
            this.baseScreenCoords[i][1] = (int)((double)this.draw.canvas.getHeight() * (0.5 - this.borderCoeff * ratio[1] / this.totalScreenRatio[1]));
        }
    }

    public void translate(int[] screenTranslation) {
        for (int i = 0; i < this.draw.canvas.base.dimension + 1; ++i) {
            this.baseScreenCoords[i][0] = this.baseScreenCoords[i][0] + screenTranslation[0];
            this.baseScreenCoords[i][1] = this.baseScreenCoords[i][1] + screenTranslation[1];
        }
    }

    public void dilate(int[] screenOrigin, double[] screenRatio) {
        if (this.totalScreenRatio[0] * screenRatio[0] > this.maxScreenRatio[0]) {
            screenRatio[0] = this.maxScreenRatio[0] / this.totalScreenRatio[0];
        }
        if (this.totalScreenRatio[1] * screenRatio[1] > this.maxScreenRatio[1]) {
            screenRatio[1] = this.maxScreenRatio[1] / this.totalScreenRatio[1];
        }
        if (this.totalScreenRatio[0] * screenRatio[0] < this.minScreenRatio[0]) {
            screenRatio[0] = this.minScreenRatio[0] / this.totalScreenRatio[0];
        }
        if (this.totalScreenRatio[1] * screenRatio[1] < this.minScreenRatio[1]) {
            screenRatio[1] = this.minScreenRatio[1] / this.totalScreenRatio[1];
        }
        for (int i = 0; i < this.draw.canvas.base.dimension + 1; ++i) {
            this.baseScreenCoords[i][0] = (int)((double)(this.baseScreenCoords[i][0] - screenOrigin[0]) / screenRatio[0]);
            this.baseScreenCoords[i][1] = (int)((double)(this.baseScreenCoords[i][1] - screenOrigin[1]) / screenRatio[1]);
        }
        this.totalScreenRatio[0] = this.totalScreenRatio[0] * screenRatio[0];
        this.totalScreenRatio[1] = this.totalScreenRatio[1] * screenRatio[1];
    }

    public int[] screenProjection(double ... pC) {
        int i;
        double[] sC = new double[]{this.baseScreenCoords[0][0], this.baseScreenCoords[0][1]};
        for (i = 0; i < this.draw.canvas.base.dimension; ++i) {
            double normdist_pC_baseCoords = 0.0;
            if (this.draw.canvas.base.axesScales[i].equalsIgnoreCase("log")) {
                normdist_pC_baseCoords = (FastMath.log(pC[i]) - FastMath.log(this.draw.canvas.base.baseCoords[0][i])) / (FastMath.log(this.draw.canvas.base.baseCoords[i + 1][i]) - FastMath.log(this.draw.canvas.base.baseCoords[0][i]));
            } else if (this.draw.canvas.base.axesScales[i].equalsIgnoreCase("lin") || this.draw.canvas.base.axesScales[i].equalsIgnoreCase("str")) {
                normdist_pC_baseCoords = (pC[i] - this.draw.canvas.base.baseCoords[0][i]) / (this.draw.canvas.base.baseCoords[i + 1][i] - this.draw.canvas.base.baseCoords[0][i]);
            }
            sC[0] = sC[0] + normdist_pC_baseCoords * (double)(this.baseScreenCoords[i + 1][0] - this.baseScreenCoords[0][0]);
            sC[1] = sC[1] + normdist_pC_baseCoords * (double)(this.baseScreenCoords[i + 1][1] - this.baseScreenCoords[0][1]);
        }
        if (this.draw.base_offset != null) {
            for (i = 0; i < this.draw.canvas.base.dimension; ++i) {
                sC[0] = sC[0] + this.draw.base_offset[i] * (double)(this.baseScreenCoords[i + 1][0] - this.baseScreenCoords[0][0]);
                sC[1] = sC[1] + this.draw.base_offset[i] * (double)(this.baseScreenCoords[i + 1][1] - this.baseScreenCoords[0][1]);
            }
        }
        if (this.draw.screen_offset != null) {
            sC[0] = sC[0] + (double)this.draw.screen_offset[0];
            sC[1] = sC[1] + (double)this.draw.screen_offset[1];
        }
        return new int[]{(int)sC[0], (int)sC[1]};
    }

    public int[] screenProjectionBase(double ... rC) {
        int i;
        double[] sC = new double[]{this.baseScreenCoords[0][0], this.baseScreenCoords[0][1]};
        for (i = 0; i < this.draw.canvas.base.dimension; ++i) {
            sC[0] = sC[0] + rC[i] * (double)(this.baseScreenCoords[i + 1][0] - this.baseScreenCoords[0][0]);
            sC[1] = sC[1] + rC[i] * (double)(this.baseScreenCoords[i + 1][1] - this.baseScreenCoords[0][1]);
        }
        if (this.draw.base_offset != null) {
            for (i = 0; i < this.draw.canvas.base.dimension; ++i) {
                sC[0] = sC[0] + this.draw.base_offset[i] * (double)(this.baseScreenCoords[i + 1][0] - this.baseScreenCoords[0][0]);
                sC[1] = sC[1] + this.draw.base_offset[i] * (double)(this.baseScreenCoords[i + 1][1] - this.baseScreenCoords[0][1]);
            }
        }
        if (this.draw.screen_offset != null) {
            sC[0] = sC[0] + (double)this.draw.screen_offset[0];
            sC[1] = sC[1] + (double)this.draw.screen_offset[1];
        }
        return new int[]{(int)sC[0], (int)sC[1]};
    }

    protected abstract double[] baseCoordsScreenProjectionRatio(double[] var1);
}

